<?php
//============================================================+
// File name   : tce_csv_result_allusers.php
// Begin       : 2006-03-30
// Last Update : 2006-10-01
// 
// Description : Functions to export users' results using 
//               CSV file format (tab delimited text).
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Tecnick.com S.r.l.
//               Via Ugo Foscolo n.19
//               09045 Quartu Sant'Elena (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//
// License: GNU GENERAL PUBLIC LICENSE v.2
//          http://www.gnu.org/copyleft/gpl.html
//============================================================+

/**
 * Display all test results in CSV format.
 * (Tab Delimited Text File)
 * @package com.tecnick.tcexam.admin
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2006-03-30
 */

if (isset($_REQUEST['testid']) AND ($_REQUEST['testid'] > 0)) {
	$test_id = $_REQUEST['testid'];
} else {
	echo "ERROR: testid has not been specified";
	exit;
}

if(!isset($_REQUEST['order_field']) OR empty($_REQUEST['order_field'])) {
	$order_field = "total_score, user_lastname, user_firstname";
} else {
	$order_field = urldecode($_REQUEST['order_field']);
}

// send headers

// fix for IE catching or PHP bug issue
header("Pragma: public");
// Date in the past
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
// always modified
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
header('Content-Description: TXT');
// force download dialog
header("Content-Type: application/force-download");
header("Content-Type: application/octet-stream", false);
header("Content-Type: application/download", false);
// use the Content-Disposition header to supply a recommended filename and 
// force the browser to display the save dialog.
header("Content-Disposition: attachment; filename=tcexam_test_results_".$test_id."_".date("YmdHis").".txt;");
/*
The Content-transfer-encoding header should be binary, since the file will be read 
directly from the disk and the raw bytes passed to the downloading computer.
The Content-length header is useful to set for downloads. The browser will be able to 
show a progress meter as a file downloads. The content-lenght can be determines by 
filesize function returns the size of a file. 
*/
header("Content-Transfer-Encoding: binary");

echo F_csv_export_result_allusers($test_id, $order_field);

/**
 * Export all test results to CSV.
 * @author Nicola Asuni
 * @copyright Copyright &copy; 2004-2006, Tecnick.com S.r.l. - Via Ugo Foscolo n.19 - 09045 Quartu Sant'Elena (CA) - ITALY - www.tecnick.com - info@tecnick.com
 * @link www.tecnick.com
 * @since 2006-03-30
 * @param int $test_id test ID
 * @param string $order_field ORDER BY portion of the SQL query
 * @return CSV data
 */
function F_csv_export_result_allusers($test_id, $order_field) {
	global $l, $db;
		require_once('../config/tce_config.php');
	require_once('../../shared/code/tce_functions_test_stats.php');
	
	$csv = ""; // CSV data to be returned
	
	// print column names
	$csv .= "#";
	$csv .= "\t".$l['w_score'];
	$csv .= "\t".$l['w_lastname'];
	$csv .= "\t".$l['w_firstname'];
	$csv .= "\t".$l['w_user'];
	$csv .= "\t".$l['w_answers_right'];
	$csv .= "\t".$l['w_answers_wrong'];
	$csv .= "\t".$l['w_questions_unanswered'];
	$csv .= "\t".$l['w_questions_undisplayed'];
	$csv .= "\t".$l['w_questions_unrated'];
	$csv .= "\t".$l['w_comment'];
	
	// output users stats
	$sqlr = "SELECT testuser_id, user_id, user_lastname, user_firstname, user_name, SUM(testlog_score) AS total_score 
		FROM ".K_TABLE_TESTS_LOGS.", ".K_TABLE_TEST_USER.", ".K_TABLE_USERS." 
		WHERE testlog_testuser_id=testuser_id
			AND testuser_user_id=user_id 
			AND testuser_test_id=".$test_id."
		GROUP BY testuser_id, user_id, user_lastname, user_firstname, user_name
		ORDER BY ".$order_field."";
	if($rr = F_db_query($sqlr, $db)) {
		$itemcount = 1;
		while($mr = F_db_fetch_array($rr)) {
			$csv .= "\n".$itemcount;
			$csv .= "\t".$mr['total_score'];
			$csv .= "\t".$mr['user_lastname'];
			$csv .= "\t".$mr['user_firstname'];
			$csv .= "\t".$mr['user_name'];
			$usrtestdata = F_getUserTestStat($test_id, $mr['user_id']);
			$csv .= "\t".$usrtestdata['right'];
			$csv .= "\t".$usrtestdata['wrong'];
			$csv .= "\t".$usrtestdata['unanswered'];
			$csv .= "\t".$usrtestdata['undisplayed'];
			$csv .= "\t".$usrtestdata['unrated'];
			$csv .= "\t".F_compact_string(htmlspecialchars($usrtestdata['comment'], ENT_NOQUOTES, $l['a_meta_charset']));
			$itemcount++;
		}
	}
	else {
		F_display_db_error();
	}
	
	return $csv;
}

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
