/**
 * Usage example:
 *
 *	<div id="newsScroller" onmouseover="stopScroller();" onmouseout="startScroller();">
 *		{foreach name=newsList from=$newsList item=item}
 *			<div class="scrollerItem" style="display: {if $smarty.foreach.newsList.first}block{else}none{/if};">
 *				<h2><a href="{$websiteUrl|escape}{$newsFolder|escape}/{$item.url}.html">{$item.headerTitle|escape}</a></h2>
 *				<p>{$item.description|strip_tags|escape}</p>
 *			</div>
 *		{/foreach}
 *	</div>
 */

var scroller;
var scrollerInterval;
var started = false;

function initScroller(scrollerId) {
	scroller = document.getElementById(scrollerId);
	startScroller();
}

function showNextItem() {
    if (!started)
        return false;
	var scrollerItems = $('#'+scroller.id).find('div');
	if(scrollerItems.length > 0 && scrollerItems != 'undefined') {
		for (var i = 0; i < scrollerItems.length; i++) {
			if (scrollerItems[i].style.display == 'block') {
				scrollerItems[i].style.display = 'none';
				break;
			}
		}
		if (i+1 >= scrollerItems.length)
				scrollerItems[0].style.display = 'block';
			else
				scrollerItems[i+1].style.display = 'block';
	}
	else {
		return false;
	}
}

function startScroller() {
	if (!started) {
		started = true;
		scrollerInterval = setInterval('showNextItem()', 4000);
	}
}

function stopScroller() {
    if (started) {
        started = false;
		clearInterval(scrollerInterval);
	}
}
