$(document).ready(function() {
	$('.adminpagelist div ul').sortable({
		connectWith:'.adminpagelist div ul, .no-menu, .stat-pages',
		cursor: 'pointer',
		delay: 100,
		dropOnEmpty: true
	});
	$('.adminpagelist').sortable({
		items: '.category-item',
		cancel: '#orderlegend'
	});
	$('.stat-pages').sortable({
		connectWith: '.no-menu, .adminpagelist div ul'
	});
	$('.no-menu').sortable({
		connectWith: '.stat-pages, .adminpagelist div ul'
	});

	$('#listsave').click(listSave);

	$('.show-hide').click(function() {
		var parentId = $(this).parent('div').parent().get(0).id;
		$('#' + parentId + ' ul').toggleClass("hide");
	});
});

/**
	 * Get and save new page order
	 * 
	 */
function listSave() {
	var websiteUrl = $('#hid-ws-url').val();
	var orderCounter = -1;
	var staticOrder = -1;
	//main menu
	var categoriesItems = $('.category-item');
	var list = [];
	for(var i=0; i < categoriesItems.length; i++) {
		orderCounter++;
		var category = {};
		category.pageId = categoriesItems[i].id;
		category.order = orderCounter;
		var subCatItems = $(categoriesItems[i]).find("ul li");
		var pages = [];
		for(var j=0; j < subCatItems.length; j++) {
			orderCounter++;
			var page = {}
			page.id = subCatItems[j].id;
			page.inmenu = subCatItems[j].title;
			page.order = orderCounter;
			pages.push(page);
		}
		category.pages = pages
		list.push(category);
	}

	//static menu
	var staticList = [];
	var staticItems = $('.stat-pages').find("li");
	for(var k=0; k<staticItems.length; k++) {
		staticOrder++;
		var statPage = {};
		statPage.id = staticItems[k].id;
		statPage.inmenu = staticItems[k].title;
		statPage.order = staticOrder;
		staticList.push(statPage);
	}

	//nomenu
	var nomenuList = [];
	var nomenuItems = $('.no-menu').find('li');
	for(var z=0; z<nomenuItems.length; z++) {
		var nomenuPage = {};
		nomenuPage.id = nomenuItems[z].id;
		nomenuPage.inmenu = nomenuItems[z].title;
		nomenuList.push(nomenuPage);
	}

	$.ajax({
		type: "post",
		url: websiteUrl+'sys/backend_page/order',
		data: 'orderList='+ json_encode(list) + '&staticOrderList='+ json_encode(staticList) + '&nomenuList=' + json_encode(nomenuList),
		success: function(response) {
			if(response == 'success') {
				//$('.adminlist').load('<?php echo $this->websiteUrl?>sys/backend_page/listall');
				top.location.reload();
			}
		}
	});
}

function editH1(elementId, websiteUrl, pageId) {
	akedit(websiteUrl +'sys/backend_page/edithtag/pageId/'+pageId, elementId,{
		type : 'text',
		name : "newH1",
		width: '204px',
		height: '20px',
		submit:'save'
	});
}

function editNavTitle(elementId, websiteUrl, pageId) {
	akedit(websiteUrl +'sys/backend_page/editnav/pageId/'+pageId, elementId,{
		type : 'text',
		name : "newH1",
		width: '232px',
		height: '20px',
		submit:'save'
	});
}

function editKeywords(elementId, websiteUrl, pageId) {
	akedit(websiteUrl +'sys/backend_page/editkeywords/pageId/'+pageId, elementId,{
		type : 'text',
		name : "newKeys",
		width: '154px',
		height: '20px',
		submit:'save'
	});
}

function checkAllMainMenu(){
		
	if($('#checkMainMenu').attr('checked')==true){
		$('div.category-item ul li span input[type="checkbox"]').attr('checked','checked');
	}else
	{
		$('div.category-item ul li span input[type="checkbox"]').attr('checked','');
	}
}

function checkAllStaticMenu(){
	if($('#checkStaticMenu').attr('checked')==true){
		$('#staticMenuCheck ul li span input[type="checkbox"]').attr('checked','checked');
	}else
	{
		$('#staticMenuCheck ul li span input[type="checkbox"]').attr('checked','');
	}
}

function checkNoCategoryMenu(){
	if($('#checkNoCategory').attr('checked')==true){
		$('#noCategory ul li span input[type="checkbox"]').attr('checked','checked');
	}else{
		$('#noCategory ul li span input[type="checkbox"]').attr('checked','');
	}

}

function deletePages()
{
	var websiteUrl = $('#hid-ws-url').val();
		var result1 = new Array();
		var result2 = new Array();
		var result3 = new Array();
		var arr1 = $('div.category-item ul li span input[type="checkbox"]');
		var arr2 = $('#staticMenuCheck ul li span input[type="checkbox"]');
		var arr3 = $('#noCategory ul li span input[type="checkbox"]');
		var flag = false;
		for(i=0;i<arr1.length;i++)
		{
			if(arr1[i].checked){
				result1[i] = arr1[i].id;
				flag=true;
			}else
			{
				result1[i]='0';
			}
		}
		for(i=0;i<arr2.length;i++)
		{
			if(arr2[i].checked){
				result2[i] = arr2[i].id;
				flag=true;
			}else
			{
				result2[i]='0';
			}
		}

		for(i=0;i<arr3.length;i++)
		{
			if(arr3[i].checked){
				result3[i] = arr3[i].id;
				flag=true;
			}else
			{
				result3[i]='0';
			}
		}
		if(!flag){
			return;
		}
		if(flag && !confirm("Do you really want to delete selected page(s)?"))
			{
				return;
			}


		$.ajax({
			type : 'POST',
			url:''+websiteUrl+'sys/backend_page/massdeletepages',
			data: ({
				result1 : json_encode(result1),
				result2 : json_encode(result2),
				result3 : json_encode(result3)
			}),
			success: function(response){
				
				response = json_decode(response);
				for(i=0;i<response.length;i++)
				{
					$('#'+response[i]).remove();
				}
				
				// $('#redirect-'+response).remove();
				//top.location.reload();
			}
		});

		
	
}