
CheckData = function(form) {
    var ltrim = /^\s+/g;
    var rtrim = /\s+$/g;
    var regEmail = /^([a-zA-Z0-9_.-])+@(([a-zA-Z0-9-])+.)+([a-zA-Z0-9]{2,4})$/;
    var regDigit = /^([0-9]{1,10})$/;
    var regSite = /^(http|https):\/\/(.+)$/;
    var site_url = form.site_url.value;
    var admin_email = form.admin_email.value;
    var img_small = form.img_small.value;
    var img_medium = form.img_medium.value;
    var img_large = form.img_large.value;
    var use_smtp = form.use_smtp.checked;
    var smtp_host = form.smtp_host.value;
    var smtp_password = form.smtp_password.value;
    var smtp_login = form.smtp_login.value;
    var img_max_width = form.img_max_width.value;
    var video_width = form.video_width.value;
    var video_height = form.video_height.value;
    var login = form.login.value;
    var password = form.password.value;
    site_url = site_url.replace(ltrim,'');
    site_url = site_url.replace(rtrim,'');
    admin_email = admin_email.replace(ltrim,'');
    admin_email = admin_email.replace(rtrim,'');
    login = login.replace(ltrim,'');
    login = login.replace(rtrim,'');
    password = password.replace(ltrim,'');
    password = password.replace(rtrim,'');

    if(use_smtp){
        smtp_host = smtp_host.replace(ltrim,'');
        smtp_host = smtp_host.replace(rtrim,'');
        smtp_login = smtp_login.replace(ltrim,'');
        smtp_login = smtp_login.replace(rtrim,'');
        smtp_password = smtp_password.replace(ltrim,'');
        smtp_password = smtp_password.replace(rtrim,'');        
    }
    
    var errors = new Array();
     if(site_url == '' || !site_url.match(regSite)) {
        errors.push(1); form.site_url.style.border = '1px solid red';
    } else {
        form.site_url.style.border = '1px solid #ccc';
    }
    if(admin_email == '' || !admin_email.match(regEmail)) {
        errors.push(1); form.admin_email.style.border = '1px solid red';
    } else {
        form.admin_email.style.border = '1px solid #ccc';
    }
    if(!img_small.match(regDigit) || img_small <= 0) {
        errors.push(1); form.img_small.style.border = '1px solid red';
    } else {
        form.img_small.style.border = '1px solid #ccc';
    }
    if(!img_medium.match(regDigit) || img_medium <= 0) {
        errors.push(1); form.img_medium.style.border = '1px solid red';
    } else {
        form.img_medium.style.border = '1px solid #ccc';
    }
    if(!img_large.match(regDigit) || img_large <= 0) {
        errors.push(1); form.img_large.style.border = '1px solid red';
    } else {
        form.img_large.style.border = '1px solid #ccc';
    }
    if(use_smtp && smtp_host == '') {
        errors.push(1); form.smtp_host.style.border = '1px solid red';
    } else {
        form.smtp_host.style.border = '1px solid #ccc';
    }
    if(use_smtp && smtp_login == '') {
        errors.push(1); form.smtp_login.style.border = '1px solid red';
    } else {
        form.smtp_login.style.border = '1px solid #ccc';
    }
    if(use_smtp && smtp_password == '') {
        errors.push(1); form.smtp_password.style.border = '1px solid red';
    } else {
        form.smtp_password.style.border = '1px solid #ccc';
    }
    if(!img_max_width.match(regDigit) || img_max_width <= 0) {
        errors.push(1); form.img_max_width.style.border = '1px solid red';
    } else {
        form.img_max_width.style.border = '1px solid #ccc';
    }
    if(!video_width.match(regDigit) || video_width <= 0) {
        errors.push(1); form.video_width.style.border = '1px solid red';
    } else {
        form.video_width.style.border = '1px solid #ccc';
    }
    if(!video_height.match(regDigit) || video_height <= 0) {
        errors.push(1); form.video_height.style.border = '1px solid red';
    } else {
        form.video_height.style.border = '1px solid #ccc';
    }
    if(login == '' || !login.match(/^[a-zA-Z0-9_.-]{2,255}$/)) {
        errors.push(1); form.login.style.border = '1px solid red';
    } else {
        form.login.style.border = '1px solid #ccc';
    }    
    if(password == '' || password.length < 5) {
        errors.push(1); form.password.style.border = '1px solid red';
    } else {
        form.password.style.border = '1px solid #ccc';
    }
    if(errors.length > 0) {
        return false;
    }
    return true;
}

UseSMTP = function(elm)
{
    var form = elm.form;
    if(elm.checked) {
        form.smtp_host.disabled = '';
        form.smtp_login.disabled = '';
        form.smtp_password.disabled = '';
    } else {
        form.smtp_host.value = '';
        form.smtp_host.disabled = 'disabled';
        form.smtp_login.value = '';
        form.smtp_login.disabled = 'disabled';
        form.smtp_password.value = '';
        form.smtp_password.disabled = 'disabled';
    }
}

