<?php
if (version_compare(PHP_VERSION, '5.0.0', '<')) {
	die('Sorry you need php 5 version or greater. Your versoin: ' . PHP_VERSION . '.');
}

class Install {

	private $_currentPath;

	public function  __construct() {
		$this->_currentPath = realpath('.');
	}

	public function Welcome() {
		echo Template::loadTemplate($this->_currentPath . '/template/welcome.html');
	}

	public function Step1() {
		$template = Template::loadTemplate($this->_currentPath . '/template/step1.html');

		$v = explode('.', phpversion());
		$version = (version_compare(PHP_VERSION, '5.0.0', '>')?Template::YES:Template::NO);



		$extensions = array('zlib', 'curl', 'session', 'mysqli', 'gd', 'json');
		$extension = Template::Extentions($extensions);

		$directories = array(
			'/public/'              => '0777',
			'/public/downloads/'    => '0777',
			'/public/galleries/'    => '0777',
			'/public/images/'       => '0777',
			'/public/previews/'     => '0777',
			'/public/themes/'       => '0777',
			'/public/tmp/'          => '0777',
			'/public/tmp/cache/'    => '0777',
			'/public/system/tmp/'   => '0777'
		);
		//$directory = Template::PermissionForDirectories($directories);
		$directory = Template::writeInFolders($directories);

		$files = array(
			'/.htaccess'                                    => '0666',
			//'/public/.htaccess'                             => '0666',
			'/public/robots.txt'                            => '0666',
			'/public/sitemap.xml'                           => '0666',
			'/application/configs/routesext.xml'            => '0666',
			'/public/system/js/tiny_mce/link_list.js'       => '0666',
			'/application/configs/application.ini'          => '0666',
			'/public/tmp/pfs.prs'                           => '0666'
		);
		//$file = Template::PermissionForFiles($files);
		$file = Template::writeInFiles($files);
		$navigation = Template::Navigation(1);

		$template = str_replace('{$version}', $version, $template);
		//$template = str_replace('{$magic_quotes}', $magic_quotes, $template);
		$template = str_replace('{$extensions}', $extension, $template);
		$template = str_replace('{$directories}', $directory, $template);
		$template = str_replace('{$files}', $file, $template);
		$template = str_replace('{$navigation}', $navigation, $template);
		echo $template;
	}

	public function Step2() {
		$template = Template::loadTemplate($this->_currentPath . '/template/step2.html');
		$message = $class = $db = $user = $password = $success = '';
		$host = 'localhost';

		if(!empty($_POST) && isset($_POST['create']) && $_POST['create'] == 'Create') {
			$flag = Functions::connectByDatabase($_POST['host'], $_POST['db'], $_POST['user'], $_POST['password']);

			if($flag == 'true') {
				$class = 'success';
				$message = 'The database was created.';
				$success = '<div id="success"></div>';
			} else {
				$class = 'errors';
				$message = $flag;
				Template::setError('Wrong data');
			}
			$host = (isset($_POST['host'])?trim($_POST['host']):'');
			$db = (isset($_POST['db'])?trim($_POST['db']):'');
			$user = (isset($_POST['user'])?trim($_POST['user']):'');
			$password = (isset($_POST['password'])?trim($_POST['password']):'');
		} else {
			Template::setError('Need enter data');
		}

		$navigation = Template::Navigation(2);

		$template = str_replace('{$success}', $success, $template);
		$template = str_replace('{$host}', $host, $template);
		$template = str_replace('{$user}', $user, $template);
		$template = str_replace('{$password}', $password, $template);
		$template = str_replace('{$db}', $db, $template);
		$template = str_replace('{$navigation}', $navigation, $template);
		$template = str_replace('{$class}', $class, $template);
		$template = str_replace('{$message}', $message, $template);
		echo $template;
	}

	public function Step3() {
		$template = Template::loadTemplate($this->_currentPath . '/template/step3.html');
		$site_url = $admin_email = $use_smtp = $smtp_host = $smtp_login = $smtp_password =
			$login = $password = $success =  '';
		$img_small = 200; $img_medium = 300; $img_large = 400; $img_max_width = 1024;
		//$video_width = 320; $video_height = 240;

		if(!empty($_POST) && isset($_POST['done']) && $_POST['done'] == 'Done') {
			Functions::saveConfiguration($_POST);
			$site_url = (isset($_POST['site_url'])?$_POST['site_url']:'');
			$admin_email = (isset($_POST['admin_email'])?$_POST['admin_email']:'');
			$img_small = (isset($_POST['img_small'])?$_POST['img_small']:'');
			$img_medium = (isset($_POST['img_medium'])?$_POST['img_medium']:'');
			$img_large = (isset($_POST['img_large'])?$_POST['img_large']:'');
			$use_smtp = (isset($_POST['use_smtp']) && $_POST['use_smtp']=='on'?'checked="checked"':'');
			$smtp_host = (isset($_POST['smtp_host'])?$_POST['smtp_host']:'');
			$smtp_login =  (isset($_POST['smtp_login'])?$_POST['smtp_login']:'');
			$smtp_password = (isset($_POST['smtp_password'])?$_POST['smtp_password']:'');
			$img_max_width = $img_max_width = 1024;//(isset($_POST['img_max_width'])?$_POST['img_max_width']:'');
			/*$video_width = (isset($_POST['video_width'])?$_POST['video_width']:'');
			$video_height = (isset($_POST['video_height'])?$_POST['video_height']:'');*/
			$login = (isset($_POST['login'])?$_POST['login']:'');
			$password = (isset($_POST['password'])?$_POST['password']:'');
			$success = '<div id="success"></div>';
		} else {
			Template::setError('Need enter data');
		}
		$navigation = Template::Navigation(3);

		$template = str_replace('{$success}', $success, $template);
		$template = str_replace('{$site_url}', $site_url, $template);
		$template = str_replace('{$admin_email}', $admin_email, $template);
		$template = str_replace('{$img_small}', $img_small, $template);
		$template = str_replace('{$img_medium}', $img_medium, $template);
		$template = str_replace('{$img_large}', $img_large, $template);
		$template = str_replace('{$use_smtp}', $use_smtp, $template);
		$template = str_replace('{$smtp_host}', $smtp_host, $template);
		$template = str_replace('{$smtp_login}', $smtp_login, $template);
		$template = str_replace('{$smtp_password}', $smtp_password, $template);
		/*$template = str_replace('{$img_max_width}', $img_max_width, $template);
		$template = str_replace('{$video_width}', $video_width, $template);
		$template = str_replace('{$video_height}', $video_height, $template);*/
		$template = str_replace('{$login}', $login, $template);
		$template = str_replace('{$password}', $password, $template);
		$template = str_replace('{$navigation}', $navigation, $template);
		echo $template;
	}

	public function Step4() {
		$template = Template::loadTemplate($this->_currentPath . '/template/step4.html');
		$config = parse_ini_file(realpath('../../') . '/application/configs/application.ini', true);
		$website_url = $config['website']['website.url'];
		$navigation = Template::Navigation(4);
		/*echo "<pre>";
		var_dump(htmlentities($navigation));
		echo "</pre>";*/
		$template = str_replace('{$navigation}', $navigation, $template);
		//$template = str_replace('{$site_url}', $website_url, $template);
		echo $template;
	}

	public function ThankYou() {

	/*	if(is_file("../../index.html"))
		{
			unlink("../../index.html");
	}*/
		$config = parse_ini_file(realpath('../../') . '/application/configs/application.ini', true);
		$website_url = $config['website']['website.url'];
		$show_magic_quotes = '';
		Functions::saveHtaccessFiles($website_url);

		if(get_magic_quotes_gpc()) {
			$show_magic_quotes = '
				<span class="developpers" style="font-weight:bold;display:block;widht:100%;">
				The "magic_quotes" are <span style="color:red;">On</span><br/>
				We recommend you to switch them Off.
				</span>';
		}

		$template = Template::loadTemplate($this->_currentPath . '/template/thankyou.html');
		$template = str_replace('{$magic_quotes}', $show_magic_quotes, $template);
		$config = parse_ini_file(realpath('../../') . '/application/configs/application.ini', true);
		$website_url = $config['website']['website.url'];
		$template = str_replace('{$site_url}', $website_url, $template);
		echo $template;
	}
}

class Functions {

	static public function changePermission($path, $mode) {
		@chmod($path, $mode);
		$perm = substr(sprintf('%o', fileperms($path)), -4);
		if($perm == $mode) {
			return true;
		}
		return false;
	}

	static public function connectByDatabase($host, $db, $user, $password) {
		$link = @mysql_connect($host, $user, $password);
		if($link === false) {
			return mysql_error();
		}

		if(!mysql_select_db($db, $link)) {
			return mysql_error();
		}

		$queries = Queries::$queries;
		foreach($queries as $query) {
			self::runQuery($query);
		}
		@mysql_close($link);

		$fileName = realpath('.') . '/config.txt';
		if(file_exists($fileName)) {
			$content = file_get_contents($fileName);
			if($content === false) {
				throw new Exception("Can't read file (" . $fileName . ").");
			}
			$content = str_replace('{$host}', $host, $content);
			$content = str_replace('{$user}', $user, $content);
			$content = str_replace('{$password}', $password, $content);
			$content = str_replace('{$db}', $db, $content);
			$content = str_replace('{$path}', realpath('../../') . '/', $content);
			if(false === file_put_contents(realpath('../../') . '/application/configs/application.ini', $content)) {
				throw new Exception("Can't save file (" . realpath('../../') . "/application/configs/application.ini).");
			}
		} else {
			throw new Exception("Can't find file $fileName or this file doesn't exist");
		}

		return 'true';
	}

	static public function saveConfiguration($data) {
		if(file_exists(realpath('../../') . '/application/configs/application.ini')) {
			$config = parse_ini_file(realpath('../../') . '/application/configs/application.ini', true);
			$host = $config["database : production"]["database.params.host"];
			$user = $config["database : production"]["database.params.username"];
			$password = $config["database : production"]["database.params.password"];
			$db = $config["database : production"]["database.params.dbname"];
			$img_max_width = 1024;
			$link = @mysql_connect($host, $user, $password);
			if($link === false) {
				throw new Exception(mysql_error());
			}
			if(!mysql_select_db($db, $link)) {
				throw new Exception(mysql_error());
			}

			if(isset($data['admin_email']) && preg_match("/^([a-zA-Z0-9_.-])+@(([a-zA-Z0-9-])+.)+([a-zA-Z0-9]{2,4})$/", trim($data['admin_email']))) {
				self::runQuery("update config set value = '" . trim($data['admin_email']) . "'  where name = 'admin_email'");
			}
			if(isset($data['img_small']) && intval($data['img_small']) > 0) {
				self::runQuery("update config set value = " . intval($data['img_small']) . "  where name = 'img_small'");
			}
			if(isset($data['img_medium']) && intval($data['img_medium']) > 0) {
				self::runQuery("update config set value = " . intval($data['img_medium']) . " where name = 'img_medium'");
			}
			if(isset($data['img_large']) && intval($data['img_large']) > 0) {
				self::runQuery("update config set value = " . intval($data['img_large']) . "  where name = 'img_large'");
			}
			if(isset($data['use_smtp']) && $data['use_smtp'] == 'on') {
				self::runQuery("update config set value = '" . (isset($data['smtp_host'])?trim($data['smtp_host']):'') . "'  where name = 'smtp_host'");
				self::runQuery("update config set value = '" . (isset($data['smtp_password'])?trim($data['smtp_password']):'') . "'  where name = 'smtp_password'");
				self::runQuery("update config set value = '" . (isset($data['smtp_login'])?trim($data['smtp_login']):'') . "'  where name = 'smtp_login'");
				self::runQuery("update config set value = " . ($data['use_smtp']=='on'?"1":"0") . "  where name = 'use_smtp'");
			}
			/*if(isset($data['img_max_width']) && intval($data['img_max_width']) > 0) {*/
			self::runQuery("update config set value = " . $img_max_width. "  where name = 'img_max_width'");
			/*}*/
			/*if(isset($data['video_width']) && intval($data['video_width']) > 0) {
				self::runQuery("update config set value = " . intval($data['video_width']) . "  where name = 'video_width'");
			}
			if(isset($data['video_height']) && intval($data['video_height']) > 0) {
				self::runQuery("update config set value = " . intval($data['video_height']) . "  where name = 'video_height'");
			}*/
			if(isset($data['login']) && trim($data['login']) != '' && isset($data['password']) && trim($data['password']) != '') {
				self::runQuery("insert into `user`(`role_id`,`id_user_seosamba`,`login`,`password`,`email`,`status`,`nickname`,`last_login`,`ipaddress`,`reg_date`) values (3,0,'" . $data['login'] . "',md5('" . $data['password'] . "'),'" . $data['admin_email'] . "','active','admin',NULL,NULL, NOW())");
			}
			@mysql_close($link);

			if(isset($data['site_url']) && preg_match("/^(http|https):\/\/(.+)$/", $data['site_url'])) {
				$siteURL = $data['site_url'] . ($data['site_url'][strlen($data['site_url'])-1] != '/'?'/':'');
				$content = file_get_contents(realpath('../../') . '/application/configs/application.ini');
				if($content === false) {
					throw new Exception("Can't read file (" . realpath('../../') . "/application/configs/application.ini).");
				}
				$content = str_replace('{$site_url}', $siteURL, $content);
				if(false === file_put_contents(realpath('../../') . '/application/configs/application.ini', $content)) {
					throw new Exception("Can't save file (" . realpath('../../') . "/application/configs/application.ini).");
				}
				//self::saveHtaccessFile($siteURL);
				self::saveRoutes($siteURL);
			} else {
				throw new Exception("Can't find  website URL.");
			}
		} else {
			throw new Exception("Can't find file (" . realpath('../../') . "/application/configs/application.ini) or this file doesn't exist.");
		}
	}

	static public function runQuery($query) {
		$success = @mysql_query($query);
		if($success === false) {
			throw new Exception(mysql_error());
		}
	}

//	static public function saveHtaccessFile($siteURL) {
//		if(file_exists(realpath('.') . '/htaccess.txt')) {
//			$content = file_get_contents(realpath('.') . '/htaccess.txt');
//			if($content === false) {
//				throw new Exception("Can't read file (" . realpath('.') . "/htaccess.txt).");
//			}
//			$content = str_replace('{$site_url}', $siteURL, $content);
//			if(false === file_put_contents(realpath('../') . '/.htaccess', $content)) {
//				throw new Exception("Can't save file (" . realpath('../') . "/.htaccess).");
//			}
//		} else {
//			throw new Exception("Can't find file (" . realpath('.') . "/htaccess.txt) or this file doesn't exist.");
//		}
//	}

	static public function saveHtaccessFiles($siteURL) {
		//$publicPath = realpath('../') . '/.htaccess'; //public path
		$rootPath = realpath('../../') . '/.htaccess'; //root path
		$parsedUrl = parse_url($siteURL);
		$siteDir = $parsedUrl['path'];
		$siteDir = ($siteDir == '/') ? '' : ltrim($siteDir, '/');

		//create public htaccess
		//var_dump(file_exists(realpath('../install').'/htaccess.txt'));
		/*if(file_exists(realpath('../install').'/htaccess.txt')) {
			$content = file_get_contents(realpath('.') . '/htaccess.txt');
			if($content === false) {
				throw new Exception("Can't read file (" . realpath('.') . "/htaccess.txt).");
			}
			$content = str_replace('{$site_url}', $siteURL, $content);
			if(false === file_put_contents(realpath('../') . '/.htaccess', $content)) {
				throw new Exception("Can't save file (" . realpath('../') . "/.htaccess).");
			}
		} else {
			throw new Exception("Can't find file (" . realpath('.') . "/htaccess.txt) or this file doesn't exist.");
		}*/

		//create root htaccess
		if(file_exists(realpath('../install').'/htaccessroot.txt')) {
			$content = file_get_contents(realpath('.') . '/htaccessroot.txt');
			if($content === false) {
				throw new Exception("Can't read file (" . realpath('.') . "/htaccessroot.txt).");
			}
			$content = str_replace('{$site_url}', $siteURL, $content);
			$content = str_replace('{$site_dir}', $siteDir, $content);
			if(false === file_put_contents(realpath('../../') . '/.htaccess', $content)) {
				throw new Exception("Can't save file (" . realpath('../../') . "/.htaccessroot).");
			}
		} else {
			throw new Exception("Can't find file (" . realpath('.') . "/htaccessroot.txt) or this file doesn't exist.");
		}
	}

	static public function saveRoutes($siteURL) {
		if(file_exists(realpath('../') . '/system/misc/routest.tpl.phtml')) {
			$content = file_get_contents(realpath('../') . '/system/misc/routest.tpl.phtml');
			if($content === false) {
				throw new Exception("Can't read file (" . realpath('../') . "/system/misc/routest.tpl.phtml).");
			}
			$url = '';
			$parseURL = parse_url($siteURL);
			if(isset($parseURL['path'])) {
				$tmpUrl = trim($parseURL['path'], '/');
				if($tmpUrl != '') {
					$url = $tmpUrl;
				}
			}
			$content = str_replace('%sitedir%', $url, $content);
			if(false === file_put_contents(realpath('../../') . '/application/configs/routesext.xml', $content)) {
				throw new Exception("Can't save file (" . realpath('../../') . "/application/configs/routesext.xml).");
			}
		} else {
			throw new Exception("Can't find file (" . realpath('../') . "/system/misc/routest.tpl.phtml) or this file doesn't exist.");
		}
	}
}

class Template {

	const YES = '<span style="color:green;">Yes</span>';
	const NO = '<span style="color:red;">No</span>';


	static public $errors = array();

	static function loadTemplate($path) {
		$content = file_get_contents($path);
		if($content === false) {
			throw new Exception("Can't read file (" . $path . ").");
		}
		return $content;
	}

	static public function Extentions($allow) {
		$extensions = get_loaded_extensions();
		$content = '';
		foreach($allow as $extension) {
			$content .= "<tr>\n<td align=\"left\"><label>" . $extension . ":</label></td>\n";
			$content .= "<td align=\"right\">";
			if(in_array($extension, $extensions)) {
				$content .= self::YES;
			} else {
				$content .= self::NO;
				self::setError("Your need extension: $extension");
			}
			$content .= "</td>\n</tr>\n";
		}
		return $content;
	}


	static public function writeInFolders($allow) {
		$content = '';
		$root = realpath('../../');
		foreach ($allow as $key => $value) {
			$content .= "<tr>\n<td align=\"left\"><label>" . $key . "</label></td>\n";
			$content .= "<td align=\"right\">";
			if(is_dir($root . $key)) {
				if(is_writable($root . $key)) {
					$content .= self::YES;
				}else {
					$content .= self::NO;//"<span style=\"color:red;font-size:14px;font-weight:bold;\">You need to make folder $key writable.</span>";
					self::setError("Folder $key  must be writable");
				}

			} else {
				$content .= '<span style="color:red;">You need create this folder</span>';
				self::setError("You need create $key folder and make it writable");
			}
			$content .= "</td>\n</tr>\n";
		}
		return $content;
	}

	static public function writeInFiles($allow) {
	//forprsculpting
		$contentToWrite = '#Test';
		$content = '';
		$root = realpath('../../');
		$res=null;
		foreach ($allow as $key => $value) {
			$content .= "<tr>\n<td align=\"left\"><label>" . $key . "</label></td>\n";
			$content .= "<td align=\"right\">";
			if(file_exists($root . $key)) {

				if(is_writable($root . $key)) {
					$content .= self::YES;
				}else {
					$content .= self::NO; //$content .= "<span style=\"color:red;font-size:14px;font-weight:bold;\">You need to make file $key writable.</span>";
					self::setError("File $key  must be writable");
				}

			} else {
				$content .= '<span style="color:red;">You need create this file</span>';
				self::setError("You need create $key file and make it writable");
			}
			$content .= "</td>\n</tr>\n";
		}
		return $content;

	}

	static public function PermissionForDirectories($allow) {
		$content = '';
		$root = realpath('../../');
		foreach ($allow as $key => $value) {
			$content .= "<tr>\n<td align=\"left\"><label>" . $key . "</label></td>\n";
			$content .= "<td align=\"right\">";
			if(is_dir($root . $key)) {
				$perm = substr(sprintf('%o', fileperms($root . $key)), -4);
				if($perm == $value) {
					$content .= self::YES;
				} else {
                    /*if(Functions::changePermission($root . $key, $value)) {
                        $content .= self::YES;
                    } else {
                        $content .= "<span style=\"color:red;font-size:14px;font-weight:bold;\">You need chmod $value</span>";
                        self::setError("Need change permission for directory $key  chmod $value");
                    }*/
					$content .= "<span style=\"color:red;font-size:14px;font-weight:bold;\">You need chmod $value</span>";
					self::setError("Need change permission for directory $key  chmod $value");
				}
			} else {
				$content .= '<span style="color:red;">You need create this folder</span>';
				self::setError("You need create $key folder and set chmod $value");
			}
			$content .= "</td>\n</tr>\n";
		}
		return $content;
	}

	static public function PermissionForFiles($allow) {
		$content = '';
		$root = realpath('../../');
		foreach ($allow as $key => $value) {
			$content .= "<tr>\n<td align=\"left\"><label>" . $key . "</label></td>\n";
			$content .= "<td align=\"right\">";
			if(file_exists($root . $key)) {
				$perm = substr(sprintf('%o', fileperms($root . $key)), -4);
				if($perm == $value) {
					$content .= self::YES;
				} else {
                        /*if(Functions::changePermission($root . $key, $value)) {
                            $content .= self::YES;
                        } else {
                            $content .= "<span style=\"color:red;font-size:14px;font-weight:bold;\">You need chmod $value</span>";
                            self::setError("Need change permission for file $key  chmod $value");
                        }*/
					$content .= "<span style=\"color:red;font-size:14px;font-weight:bold;\">You need chmod $value</span>";
					self::setError("Need change permission for file $key  chmod $value");
				}
			} else {
				$content .= '<span style="color:red;">You need create this file</span>';
				self::setError("You need create $key file and set chmod $value");
			}
			$content .= "</td>\n</tr>\n";
		}
		return $content;
	}

	static public function magicQuotes() {
		$content = '';
		$content .= "<tr>\n<td align=\"left\"><label>magic_quotes_gpc</label></td>\n";
		$content .= "<td align=\"right\">" . (get_magic_quotes_gpc() == 0?'<span style="color:green;">Off</span>':'<span style="margin-right:10px;">turn it Off (recommended)</span><span style="color:red;">On</span>') . "</td></tr>";
		$content .= "<tr>\n<td align=\"left\"><label>magic_quotes_runtime</label></td>\n";
		$content .= "<td align=\"right\">" . (get_magic_quotes_runtime() == 0?'<span style="color:green;">Off</span>':'<span style="margin-right:10px;">turn it Off (recommended)</span><span style="color:red;">On</span>') . "</td></tr>";
		return $content;
	}

	static public function setError($error) {
		self::$errors[] = $error;
	}

	static public function getErrors() {
		return self::$errors;
	}

	static public function Navigation($step) {
		$content = "<div  class=\"navigation\">\n";
		if($step!=1) {
			$content .= "<div class=\"back\">\n";
			$content .= "<form action=\"index.php\" method=\"post\">\n";
			$content .= "<input type=\"hidden\" name=\"step\" value=\"" . ($step-1) . "\">\n";
			$content .= "<input type=\"submit\" name=\"back\" value=\"Back\">\n</form>\n</div>\n";
		}
		$content .= "<div align='center' class=\"next\">\n";
		$errors = self::$errors;
		if(empty($errors)) {
			$content .= "<form action=\"index.php\" method=\"post\">\n";
			$content .= "<input type=\"hidden\" name=\"step\" value=\"" . ($step+1) . "\">\n";
			$content .= "<input type=\"submit\" name=\"next\" value=\"Next\">\n</form>\n";
		} else {
			if($step == 1 ) {
				$content .= "<form action=\"index.php\" method=\"post\">\n";
				$content .= "<input type=\"hidden\" name=\"step\" value=\"" . $step . "\">\n";
				$content .= "<input type=\"submit\" name=\"check\" value=\"Check Again\">\n</form>\n";
			}
		}
		$content .= "</div></div>\n";
		return $content;
	}

}

class Queries {


	static public $queries = array(
	"CREATE TABLE `category` (
  		`id` int(10) NOT NULL auto_increment,
  		`id_parent` int(11) default NULL,
  		`name` varchar(255) default NULL,
	PRIMARY KEY  (`id`),
	KEY `parentId` (`id_parent`)
	) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `comment` (
  		`id` int(10) unsigned NOT NULL auto_increment,
  		`content` text,
  		`container_id` int(10) unsigned NOT NULL,
  		`date` datetime default NULL,
  		`user_id` int(10) unsigned NOT NULL,
  		`user_email` varchar(60) default '',
  		`abuse` tinyint(1) default '0',
  		`user_sign` varchar(40) default '',
  		`user_website` varchar(40) default '',
  		`publish` tinyint(1) default '1',
  		`rank` tinyint(3) default '0',
  		`topic` varchar(60) default '',
  		`keyword` varchar(60) default '',
  		`notify` tinyint(1) default '0',
  	PRIMARY KEY  (`id`)
	) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `config` (
  		`name` varchar(100) NOT NULL default '',
  		`value` varchar(255) NOT NULL,
  	PRIMARY KEY  (`name`)
	) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `container` (
  		`id` int(10) unsigned NOT NULL auto_increment,
  		`container_type_id` int(10) unsigned NOT NULL,
  		`user_id` int(11) NOT NULL,
  		`page_id` int(11) NOT NULL,
  		`name` varchar(255) default NULL,
  		`options_values` varchar(255) default NULL,
  		`published` enum('0','1') default '1',
  		`is_forsale` enum('0','1') default '0',
		`price` float default NULL,
		`first_option` varchar(255) default NULL,
		`second_option` varchar(255) default NULL,
		`allow_comments` enum('0','1') default '1',
		`publishing_date` datetime default NULL,
  	PRIMARY KEY  (`id`)
	) ENGINE=MyISAM AUTO_INCREMENT=59 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `container_type` (
  		`id` int(10) unsigned NOT NULL auto_increment,
  		`name` varchar(255) default NULL,
  		`template` varchar(255) default NULL,
  	PRIMARY KEY  (`id`)
	) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `content` (
  		`id` int(10) unsigned NOT NULL auto_increment,
  		`id_language` int(10) unsigned NOT NULL,
  		`id_container` int(10) unsigned NOT NULL,
  		`value` text,
  	PRIMARY KEY  (`id`)
	) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `deeplink` (
  		`id` int(10) unsigned NOT NULL auto_increment,
  		`name` varchar(255) NOT NULL,
		`url` varchar(255) NOT NULL,
  		`type` enum('int','ext') default 'int',
  		`ban` enum('0','1') NOT NULL default '0',
  		`nofollow` enum('0','1') NOT NULL default '0',
  		`ext_ws_id` int(10) unsigned default NULL,
  	PRIMARY KEY  (`id`)
	) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `deeplink_content` (
  		`deeplink_id` int(11) unsigned NOT NULL,
  		`content_id` int(11) unsigned NOT NULL
	) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `featured_area` (
  		`id` int(10) unsigned NOT NULL auto_increment,
  		`name` varchar(164) NOT NULL,
  		`content` text,
  		`order` tinyint(3) default NULL,
  	PRIMARY KEY  (`id`)
	) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `forms` (
		`id` int(10) unsigned NOT NULL auto_increment,
		`name` varchar(64) NOT NULL,
		`code` text NOT NULL,
		`email` varchar(64) NOT NULL,
		`successMessage` text NOT NULL,
		`errorMessage` text NOT NULL,
		`emailFrom` varchar(64) NOT NULL,
		`emailMessage` text NOT NULL,
		`useSMTP` enum('0','1') NOT NULL default '0',
	PRIMARY KEY  (`id`)
	) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `language` (
		`id` int(10) unsigned NOT NULL auto_increment,
		`name` varchar(64) default NULL,
  	PRIMARY KEY  (`id`)
	) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `link_reference` (
		`id_container` int(10) unsigned default NULL,
		`link` varchar(255) default NULL
	) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `message` (
		`id` int(10) unsigned NOT NULL auto_increment,
		`user_id` int(10) unsigned NOT NULL,
		`content` text,
		`date_sent` datetime default NULL,
	PRIMARY KEY  (`id`)
	) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `news` (
		`id` int(10) unsigned NOT NULL auto_increment,
		`id_newscategory` int(10) unsigned NOT NULL,
		`title` varchar(255) NOT NULL,
		`page_url` varchar(255) default NULL,
		`intro` text NOT NULL,
		`text` text NOT NULL,
		`date` datetime NOT NULL,
		`order` int(10) unsigned NOT NULL,
		`is_archived` enum('0','1') NOT NULL default '0',
		`is_featured` enum('0','1') NOT NULL default '0',
		`disable_archive` enum('0','1') NOT NULL default '0',
		`last_update` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
		`news_meta_description` text NOT NULL,
		`news_meta_keywords` text NOT NULL,
  	PRIMARY KEY  (`id`)
	) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `newscategory` (
		`id` int(10) unsigned NOT NULL auto_increment,
		`name` varchar(255) NOT NULL,
	PRIMARY KEY  (`id`)
	) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `page` (
		`id` int(10) unsigned NOT NULL auto_increment,
		`template_id` int(10) unsigned NOT NULL,
		`category_id` int(11) NOT NULL,
		`nav_name` varchar(255) default NULL,
		`meta_description` text,
		`meta_keywords` text,
		`header_title` varchar(255) default NULL,
		`h1` varchar(255) default NULL,
		`url` varchar(255) default NULL,
		`short_description` text,
		`date` datetime default NULL,
		`owner` int(10) unsigned default NULL,
		`last_update` datetime default NULL,
		`is_404page` enum('0','1') default '0',
		`bestpractices` enum('1','0') default '0',
		`show_in_menu` enum('0','1','2','3') default '0',
		`order` tinyint(3) unsigned default NULL,
		`static_order` tinyint(4) default NULL,
		`weight` tinyint(3) unsigned default '0',
		`seosamba_rule_id` int(10) unsigned default NULL,
		`silo_id` int(10) unsigned default NULL,
		`targeted_key_phrase` VARCHAR(255) NULL,
	PRIMARY KEY (`id`)
	) ENGINE=MyISAM AUTO_INCREMENT=83 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `page_changelog` (
		`page_id` int(10) unsigned NOT NULL,
		`header_title` varchar(255) default NULL,
		`url` varchar(255) default NULL,
		`meta_keywords` text,
		`meta_description` text
	) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `page_has_fa` (
		`page_id` int(10) unsigned NOT NULL,
		`fa_id` int(10) unsigned NOT NULL
	) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `page_image` (
		`id` int(10) unsigned NOT NULL auto_increment,
		`page_id` int(10) unsigned NOT NULL,
		`name` varchar(255) default NULL,
		`path` varchar(255) default NULL,
		`description` text,
	PRIMARY KEY  (`id`)
	) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `plugin` (
		`id` int(10) unsigned NOT NULL auto_increment,
		`name` varchar(255) default NULL,
		`status` enum('enabled','disabled') default 'disabled',
		PRIMARY KEY  (`id`)
	) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `renamed_pages` (
		`id_page` int(10) unsigned default NULL,
		`url` varchar(255) default NULL,
		`new_url` varchar(255) default NULL,
		`original_old_url` varchar(255) default ''
	) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `role` (
		`id` int(10) unsigned NOT NULL auto_increment,
		`name` varchar(45) default NULL,
	PRIMARY KEY  (`id`)
	) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `seo_data` (
		`page_id` int(10) unsigned default NULL,
		`seo_top` longtext,
		`seo_bottom` longtext,
	UNIQUE KEY `page_id` (`page_id`)
	) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `silo` (
		`id` int(10) unsigned NOT NULL auto_increment,
		`name` varchar(255) default NULL,
		`as_cat` enum('0','1') default '0',
	PRIMARY KEY  (`id`)
	) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `template` (
		`id` int(10) unsigned NOT NULL auto_increment,
		`name` varchar(45) default NULL,
		`content` text,
		`preview_path` varchar(60) default NULL,
		`theme_name` varchar(60) default NULL,
	PRIMARY KEY  (`id`)
	) ENGINE=InnoDB AUTO_INCREMENT=192 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `user` (
		`id` int(10) unsigned NOT NULL auto_increment,
		`role_id` int(10) unsigned NOT NULL,
		`id_user_seosamba` int(10) unsigned default NULL,
		`login` varchar(30) default NULL COMMENT 'user login',
		`password` varchar(35) default NULL COMMENT 'user password',
		`email` varchar(45) default NULL,
		`status` enum('active','banned','blocked') default 'active',
		`nickname` varchar(40) default NULL,
		`last_login` datetime default NULL,
		`ipaddress` varchar(30) default NULL,
		`reg_date` datetime default NULL,
	PRIMARY KEY  (`id`)
	) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `user_page_permission` (
		`id` int(10) unsigned NOT NULL auto_increment,
		`id_user` int(10) unsigned default NULL,
		`id_page` int(10) unsigned default NULL,
	PRIMARY KEY  (`id`)
	) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `variable_content` (
		`name` varchar(250) NOT NULL default '',
		`value` text NOT NULL,
	PRIMARY KEY  (`name`)
	) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `website_info` (
		`id` int(10) unsigned NOT NULL auto_increment,
		`name` varchar(45) default NULL,
		`url` varchar(255) default NULL,
		`description` text,
		`address` varchar(255) default NULL,
		`phone` varchar(64) default NULL,
		`fax` varchar(64) default NULL,
		`industry` varchar(128) default NULL,
		`geo_code` int(11) default NULL,
		`email` varchar(255) default NULL,
	PRIMARY KEY  (`id`)
	) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `whitelabel_services` (
		`cpanel_logo` varchar(255) default NULL,
		`services_content` text
	) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"CREATE TABLE `password_recovering` (
		`link` VARCHAR(100) CHARACTER SET utf8 NOT NULL DEFAULT '',
        `time` VARCHAR(255) CHARACTER SET utf8 NOT NULL
    ) ENGINE=MYISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;"
	,
	"insert into `config`(`name`,`value`) values ('current_theme','default'),('default_page','index'),('zfp',''),('admin_email','admin@localhost'),('img_small','200'),('img_medium','300'),('img_large','450'),('img_page_desc_large',''),('img_page_desc_small',''),('smtp_host',''),('smtp_password',''),('smtp_login',''),('use_smtp','0'),('img_max_width','1024'),('plugin_cache','0'), ('default_news_folder', 'news'), ('page_teaser_size',200), ('translate_language','english');"
	,
	"insert  into `role`(`id`,`name`) values (1,'admin'),(2,'user'),(3,'superadmin');"
	,

	"insert  into `page`(`id`,`template_id`,`category_id`,`nav_name`,`meta_description`,`meta_keywords`,`header_title`,`h1`,`url`,`short_description`,`date`,`owner`,`last_update`,`is_404page`,`bestpractices`,`show_in_menu`,`order`,`static_order`,`weight`,`seosamba_rule_id`,`silo_id`,`targeted_key_phrase`) values (81,1,102,'Home','SEO Toaster is the most advanced SEO CMS out of the box and is also free & open source. SEO Toaster: easy to use, build, seo, and scale.','seo cms, open source cms, free cms, free seo software, open source cms, seo toaster','Open Source SEO CMS | Free SEO Software | SEOTOASTER','Open source & free SEO CMS - SEO Toaster','index','','0000-00-00 00:00:00',0,'2010-02-18 16:25:41','0','0','2',1,0,0,0,0,'index'),(82,2,-1,'no category','','','no category','no category','no-category','','2009-10-29 11:49:12',1,'2010-02-18 16:25:41','0','0','1',0,100,0,0,0,'no-category'),(85,2,67,'What is seotoaster?','seotoaster is the first cloud CMS where websites can be connected with each others, the first complete front-end edition and administration CMS, the most advanced SEO CMS right out of the box: no plug in required.','SEO CMS, Open Source CMS software, open source cms, private label website builder, Free SEO Software, seotoaster screenshots','Open Source CMS Software','What is seotoaster?','Open-Source-CMS-Software','seotoaster is the first cloud CMS where websites can be connected with each others, the first complete front-end edition and administration CMS, the most advanced SEO CMS right out of the box: no plug in required.','0000-00-00 00:00:00',0,'2010-02-18 16:25:41','0','0','2',0,1,0,0,0,'Open-Source-CMS-Software'),(129,3,125,'Create a page','','','Create a page','Create a page','create-a-page','','0000-00-00 00:00:00',0,'2010-02-18 17:18:28','0','0','1',0,100,0,0,0,'create-a-page'),(130,3,126,'Add or Edit content','','','Add or Edit content','How to add and edit content','add-or-edit-content','','0000-00-00 00:00:00',0,'2010-02-18 17:21:25','0','0','1',0,100,0,0,0,'add-or-edit-content'),(91,2,81,'How to use seotoaster','How to use seotoaster, tips and tricks and videos to demonstrate seotoaster\'s capabilities','how to use seo toaster, help with seotoaster, free website marketing tools','How to use seotoaster - free website marketing tools','How to use seotoaster','how-to-use-seotoaster','How to use seotoaster, tips and tricks and videos to demonstrate seotoaster\'s capabilities','0000-00-00 00:00:00',0,'2010-02-18 16:25:41','0','0','1',1,100,0,0,0,'how-to-use-seotoaster'),(102,3,94,'Sorry we could not find the requested page','this is a 404 page','','Sorry we could not find the requested page','Sorry we could not find the requested page','sorry-we-could-not-find-the-requested-page','','2009-11-27 04:00:55',2,'2010-02-18 16:25:41','1','0','0',0,100,0,0,0,'sorry-we-could-not-find-the-requested-page'),(104,3,96,'More Information','More information about using seotoaster','automated 301 redirects,.htaccess, automated 301 redirects SEO, 301 redirect htaccess file,	301 redirect search engines, rewriterule 301 redirect','More Information','More Information','More-information','more inforamtion about seotoaster','0000-00-00 00:00:00',0,'2010-02-18 18:11:14','0','0','1',2,100,0,0,0,'More-information'),(105,3,97,'Search Results','Search Results for queries on seotoaster','seotoaster,search results','Search Results','Search Results','search-results','Search Results for queries on seotoaster','0000-00-00 00:00:00',0,'2010-02-18 16:25:41','0','0','0',0,100,0,0,0,'search-results');"
	,
	"insert  into `category`(`id`,`id_parent`,`name`) values (-1,0,'no category'),(67,-1,'What is seotoaster?'),(81,0,'How to use seotoaster'),(126,81,'Add or Edit content'),(125,81,'Create a page'),(94,-1,'Sorry we could not find the requested page'),(96,81,'More Information'),(97,-1,'Search Results'),(124,-1,'Create a page'),(102,-1,'Home');"
	,
	"insert  into `container`(`id`,`container_type_id`,`user_id`,`page_id`,`name`,`options_values`,`published`,`is_forsale`,`price`,`first_option`,`second_option`,`allow_comments`,`publishing_date`) values
(57,3,2,81,'screen1-left',NULL,'1','0',NULL,NULL,NULL,'1','2009-11-08 18:30:11'),
(58,3,2,81,'screen3-left',NULL,'1','0',NULL,NULL,NULL,'1','2009-11-08 18:30:45'),
(59,1,2,81,'screen3-right',NULL,'1','0',NULL,NULL,NULL,'1','2010-01-22 00:00:00'),
(60,1,2,81,'screen2-right',NULL,'1','0',NULL,NULL,NULL,'1','2010-01-30 00:00:00'),
(61,3,2,81,'screen4-left',NULL,'1','0',NULL,NULL,NULL,'1','2009-11-08 18:56:59'),
(62,1,2,81,'screen5-right',NULL,'1','0',NULL,NULL,NULL,'1','2010-01-22 00:00:00'),
(63,3,2,81,'screen2-left',NULL,'1','0',NULL,NULL,NULL,'1','2009-11-08 18:59:07'),
(64,3,2,81,'screen5-left',NULL,'1','0',NULL,NULL,NULL,'1','2009-11-08 19:04:04'),
(65,1,2,81,'screen6-right',NULL,'1','0',NULL,NULL,NULL,'1','2009-11-23 00:00:00'),
(66,3,2,81,'annoucement',NULL,'1','0',NULL,NULL,NULL,'1','2009-11-09 14:30:23'),
(67,3,2,81,'annoucements',NULL,'1','0',NULL,NULL,NULL,'1','2009-11-09 15:06:39'),
(72,2,2,0,'footer',NULL,'1','0',NULL,NULL,NULL,'1','2010-01-07 00:00:00'),
(75,1,2,85,'1',NULL,'1','0',NULL,NULL,NULL,'1','2010-01-07 00:00:00'),
(76,3,2,85,'1',NULL,'1','0',NULL,NULL,NULL,'1','2009-11-10 09:35:52'),
(77,3,2,85,'2',NULL,'1','0',NULL,NULL,NULL,'1','2009-11-10 09:36:01'),
(78,1,2,85,'2',NULL,'1','0',NULL,NULL,NULL,'1','2010-01-07 00:00:00'),
(80,1,2,81,'annoucements',NULL,'1','0',NULL,NULL,NULL,'1','2010-02-18 00:00:00'),
(88,2,2,0,'right1',NULL,'1','0',NULL,NULL,NULL,'1','2010-02-17 00:00:00'),
(221,1,17,130,'3',NULL,'1','0',NULL,NULL,NULL,'1','2010-02-18 00:00:00'),
(220,3,17,130,'3',NULL,'1','0',NULL,NULL,NULL,'1','2010-02-18 17:22:52'),
(96,3,2,91,'1',NULL,'1','0',NULL,NULL,NULL,'1','2009-11-18 14:18:30'),
(99,1,2,91,'1',NULL,'1','0',NULL,NULL,NULL,'1','2010-02-17 00:00:00'),
(133,1,2,102,'1',NULL,'1','0',NULL,NULL,NULL,'1','2009-11-27 00:00:00'),
(141,1,2,104,'1',NULL,'1','0',NULL,NULL,NULL,'1','2010-02-18 00:00:00'),
(142,3,2,104,'1',NULL,'1','0',NULL,NULL,NULL,'1','2009-11-28 07:08:29'),
(143,1,2,104,'2',NULL,'1','0',NULL,NULL,NULL,'1','2010-02-18 00:00:00'),
(144,3,2,104,'2',NULL,'1','0',NULL,NULL,NULL,'1','2009-11-28 07:49:10'),
(145,1,2,105,'1',NULL,'1','0',NULL,NULL,NULL,'1','2009-11-30 00:00:00'),
(146,4,2,105,'date',NULL,'1','0',NULL,NULL,NULL,'1','2009-11-30 03:12:45'),
(219,1,17,130,'2',NULL,'1','0',NULL,NULL,NULL,'1','2010-02-18 00:00:00'),
(218,3,17,130,'2',NULL,'1','0',NULL,NULL,NULL,'1','2010-02-18 17:22:19'),
(217,1,17,130,'1',NULL,'1','0',NULL,NULL,NULL,'1','2010-02-18 00:00:00'),
(216,3,17,130,'1',NULL,'1','0',NULL,NULL,NULL,'1','2010-02-18 17:21:39'),
(215,1,17,129,'1',NULL,'1','0',NULL,NULL,NULL,'1','2010-02-18 00:00:00'),
(214,3,17,129,'1',NULL,'1','0',NULL,NULL,NULL,'1','2010-02-18 17:19:04')
"
	,
	"insert  into `content`(`id`,`id_language`,`id_container`,`value`) 	values  (52,1,57,'As an example, edit this text by clicking here --->');"
	,
	"insert  into `content`(`id`,`id_language`,`id_container`,`value`) 	values  	(53,1,58,'Easy front-end inline editing and administration');"
	,

	"insert  into `content`(`id`,`id_language`,`id_container`,`value`) 	values  	(56,1,61,'Only 4 standard HTML & 2 CSS templates required to build a theme');"
	,
	"insert  into `content`(`id`,`id_language`,`id_container`,`value`) 	values  	(57,1,62,'<p>&nbsp;</p>\n<ul>\n<li>Free, open source and white label ready CMS</li>\n<li>Pre-configured widgets such as featured pages, <a title=\"How to add a search engine\" href=\"http://www.seotoaster.com/implementing-lucene.html\">search engine</a>,&nbsp; and more</li>\n<li><a title=\"Working with media\" href=\"http://www.seotoaster.com/working-with-media.html\">Embed videos from youtube</a> or vimeo right into your web pages, no player needed.</li>\n<li><a title=\"How to add and edit content\" href=\"http://www.seotoaster.com/add-and-edit-content.html\">Add server side code</a> without leaving your website<span class=\"code\">&nbsp;</span></li>\n<li>Customize and integrate open-source shopping cart and other applications with our easy plug-in system</li>\n</ul>\n<p>&nbsp;</p>');"
	,
	"insert  into `content`(`id`,`id_language`,`id_container`,`value`) 	values  	(58,1,63,'Embed all latest SEO techniques automatically right into your website');"
	,
	"insert  into `content`(`id`,`id_language`,`id_container`,`value`) 	values  	(59,1,64,'The foundation for scalable successful web businesses, affiliates, franchises, agencies');"
	,
	"insert  into `content`(`id`,`id_language`,`id_container`,`value`) 	values  	(60,1,65,'<h3>With an optional subscription to   SEO Samba;</h3>\n<ul>\n<li>Centralize   SEO &amp; marketing</li>\n<li>Market automatically to directories &amp; websites</li>\n</ul>\n<h3>And access instantly new features;</h3>\n<ul>\n<li>Webmaster tools integration</li>\n<li>Landing page experiment</li>\n<li>Website analytics</li>\n<li>Network-wide widgets</li>\n<li>Build Google news</li>\n<li>Seamless email marketing</li>\n<li>Private labeling for agencies</li>\n</ul>');"
	,
	"insert  into `content`(`id`,`id_language`,`id_container`,`value`) 	values  	(61,1,66,'Download of SEOTOASTER will start on the 9th of November 2009');"
	,
	"insert  into `content`(`id`,`id_language`,`id_container`,`value`) 	values  	(62,1,67,'Download of SEOTOASTER will start on the 10th of November 2009');"
	,
	"insert  into `content`(`id`,`id_language`,`id_container`,`value`) 	values  	(67,1,72,'<p>&copy; 2009 - 2010 seotoaster</p>');"
	,
	"insert  into `content`(`id`,`id_language`,`id_container`,`value`) 	values  	(70,1,75,'<div class=\"important\"><ol>\n<li>The first cloud CMS where websites can be connected with each others, centrally marketed and managed.</li>\n<li>The first complete front-end edition and administration CMS.</li>\n<li><span><span style=\"font: normal normal normal 7pt/normal \'Times New Roman\';\">&nbsp;</span></span>The most advanced   SEO CMS right out of the box: no plug in required.</li>\n</ol></div>');"
	,
	"insert  into `content`(`id`,`id_language`,`id_container`,`value`) 	values  	(72,1,77,'Free and Open Source CMS Software');"
	,
	"insert  into `content`(`id`,`id_language`,`id_container`,`value`) 	values  	(73,1,78,'<ul>\n<li>seotoaster is easy for content writers, and website administrators featuring complete front-end edition.</li>\n<li>seotoaster is easy for web designers requiring only 4 HTML template and 2 CSS to build a complete theme.</li>\n<li>seotoaster is the most advanced   SEO CMS right out of the box, no plug-ins required; featuring automated 301 redirection creation, automated optimized on-site linking, automated link sculpting using JS, and even point and click link siloing.</li>\n<li>seotoaster is also the foundation for scalable successful web businesses; Build one, two and more websites then network them all to centralize your   SEO and compound your marketing impact with a subscription to   SEO Samba.</li>\n<li>seotoaster ships with a set of sexy themes ready to power your next project. Over 40 additional free websites themes are also available for download from our <a title=\"Download themes for your website\" href=\"http://www.seotoaster.com/working-with-themes.html#themes\" target=\"_self\">free websites themes store</a>.</li>\n<li>seotoaster includes a plug-in system to extend it with functionalities such as shopping carts &amp; more.</li>\n</ul>\n<h2><a name=\"screenshots\"></a>Screenshots</h2>\n<p>{\$gallery:screenshots}</p>');"
	,
	"insert  into `content`(`id`,`id_language`,`id_container`,`value`) 	values  	(75,1,80,'<p>{\$static_menu}</p>');"
	,
	"insert  into `content`(`id`,`id_language`,`id_container`,`value`) 	values  	(209,1,214,'Creating and Editing a Page for your Website is Easy');"
	,
	"insert  into `content`(`id`,`id_language`,`id_container`,`value`) 	values  	(210,1,215,'<ol>\n<li>Click on \"Create a page\" in the control panel on the left of your screen.</li>\n<li>Fill in the required fields.</li>\n<li>Select which navigation this page belongs to.</li>\n<li>Input your teaser text and upload you teaser picture for later use in featured area or search result</li>\n<li>click done, and voila, your page is ready to be edited.</li>\n<li>To change a page\'s properties, go to the page you want to change and click \"Edit page properties\" in the control panel on the left of your screen.</li>\n<li>To delete a page, simply go to the page you want to delete and click \"Delete this page\" in the control panel on the left of your screen.</li>\n</ol>\n<p><a class=\"thickbox\" href=\"http://www.seotoaster.com/images/tutorials/original/add-edit-page.png\"></a></p>\n<p style=\"text-align: center;\">&nbsp;</p>\n<p style=\"text-align: center;\">
<a class=\"thickbox\" href=\"themes/default/images/add-edit-page.png\">
<img src=\"themes/default/images/add-edit-page.png\" border=\"0\" alt=\"add-edit-page\" width=\"350\" /></a>
</p>\n
<p style=\"text-align: center;\">&nbsp;</p>\n<div class=\"screencast\">\n<object width=\"400\" height=\"300\" data=\"http://vimeo.com/moogaloop.swf?clip_id=7708543&amp;server=vimeo.com&amp;show_title=1&amp;show_byline=1&amp;show_portrait=0&amp;color=&amp;fullscreen=1\" type=\"application/x-shockwave-flash\">\n<param name=\"allowfullscreen\" value=\"true\" />\n<param name=\"allowscriptaccess\" value=\"always\" />\n<param name=\"src\" value=\"http://vimeo.com/moogaloop.swf?clip_id=7708543&amp;server=vimeo.com&amp;show_title=1&amp;show_byline=1&amp;show_portrait=0&amp;color=&amp;fullscreen=1\" />\n</object>\n</div>\n<p style=\"text-align:center\"><a href=\"http://vimeo.com/7708543\">How to create a page with SEOToaster</a> from <a href=\"http://vimeo.com/user2658407\">seotoaster</a> on <a href=\"http://vimeo.com\">Vimeo</a>.</p>');"
	,
	"insert  into `content`(`id`,`id_language`,`id_container`,`value`) 	values  	(83,1,88,'<p>{\$main_menu}</p>');"
	,
	"insert  into `content`(`id`,`id_language`,`id_container`,`value`) 	values  	(91,1,96,'Watch the videos, seotoaster is amazingly easy to use ');"
	,
	"insert  into `content`(`id`,`id_language`,`id_container`,`value`) 	values  	(94,1,99,'<p class=\"important\"><strong>Note:</strong><br />We decided to <strong><span style=\"text-decoration: underline;\">avoid Internet Explorer</span></strong> altogether when building seotoaster\'s user interface. So when administrating your website, please use a browser that can handle the latest CSS and JS technologies such as: Safari, Chrome, FireFox.&nbsp;</p>\n<p style=\"text-align: center;\"><strong>Stay tune as we are adding help pages one by one.</strong></p>\n<p>{\$pages_list_img}</p>\n<p>&nbsp;</p>\n<div class=\"developpers\">\n<p><strong>Note to &nbsp;users:</strong> in order to get this list of page above, we simply added the following widget in the editor:&nbsp;<span class=\"code\">{%pages_list_img}</span> and it bring a &lt;ul&gt;&lt;/li&gt; list of pages in this category...</p>\n<p>&nbsp;</p>\n<p>Cool huh?</p>\n</div>');"
	,
	"insert  into `content`(`id`,`id_language`,`id_container`,`value`) 	values  	(128,1,133,'<p>&nbsp;</p>\n<p>&nbsp;</p>\n<p>How about trying one of the following resources?</p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n<p>{\$sitemap}</p>');"
	,
	"insert  into `content`(`id`,`id_language`,`id_container`,`value`) 	values  	(136,1,141,'<div class=\"developpers\">Make sure to read and watch our tutorials and videos on <a href=\"http://www.seotoaster.com/how-to-use-seotoaster.html\">seotoaster.com</a>.<br />Once you are done with learning / trying /breaking and experimenting, if you want to stay on the cutting edge of the toaster, make sure to sign up for our <a title=\"Toasting Thursday\'s talks\" href=\"http://www.seotoaster.com/seo-training-free.html\">Toasting Thursday\'s talks at 12.30 PST</a>&nbsp;</div>');"
	,
	"insert  into `content`(`id`,`id_language`,`id_container`,`value`) 	values  	(137,1,142,'Learn more about Seo Toaster');"
	,
	"insert  into `content`(`id`,`id_language`,`id_container`,`value`) 	values  	(140,1,145,'<p>{\$search_result}</p>');"
	,
	"insert  into `content`(`id`,`id_language`,`id_container`,`value`) 	values  	(141,1,146,'return date(DATE_RFC822);');"
	,
	"insert  into `content`(`id`,`id_language`,`id_container`,`value`) 	values  	(215,1,220,'Content Widgets Screencast Demo');"
	,
	"insert  into `content`(`id`,`id_language`,`id_container`,`value`) 	values  	(216,1,221,'<div class=\"screencast\"><a name=\"screencast\"></a> \n<object width=\"400\" height=\"300\" data=\"http://vimeo.com/moogaloop.swf?clip_id=7704485&amp;server=vimeo.com&amp;show_title=1&amp;show_byline=1&amp;show_portrait=0&amp;color=&amp;fullscreen=1\" type=\"application/x-shockwave-flash\">\n<param name=\"allowfullscreen\" value=\"true\" />\n<param name=\"allowscriptaccess\" value=\"always\" />\n<param name=\"src\" value=\"http://vimeo.com/moogaloop.swf?clip_id=7704485&amp;server=vimeo.com&amp;show_title=1&amp;show_byline=1&amp;show_portrait=0&amp;color=&amp;fullscreen=1\" />\n</object>\n<p><a href=\"http://vimeo.com/7704485\">Seotoaster Content widgets demo</a> from <a href=\"http://vimeo.com/user2658407\">seotoaster</a> on <a href=\"http://vimeo.com\">Vimeo</a>.</p>\n</div>');"
	,
	"insert  into `content`(`id`,`id_language`,`id_container`,`value`) 	values
	(214,1,219,'<div class=\"pspaced\">\n<p><img style=\"border: 0px initial initial;\" src=\"themes/default/images/editaddcontent.jpg\" alt=\"editaddcontent\" /><img style=\"border: 0px initial initial;\" src=\"themes/default/images/editaddcontent.jpg\" alt=\"editaddcontent\" /><img style=\"border: 0px initial initial;\" src=\"themes/default/images/editaddcontent.jpg\" alt=\"editaddcontent\" /><img style=\"border: 0px initial initial;\" src=\"themes/default/images/editaddcontent.jpg\" alt=\"editaddcontent\" />&nbsp;</p>\n<p><strong>How many content area can I put on a template?<br /></strong>You can create as many content widget as you want in a template</p>\n<p><strong>How can I create Content Areas?</strong><br />To create a content widget simply put:<br /><code>{%content:name-of-content-area}</code></p>\n<p><strong>Where do I put these content areas?</strong><br />anywhere you want to be able to add content for this page.</p>\n<p><strong>Give me some code&nbsp;example to add these content areas to my templates:</strong><br />EX:&nbsp;<code>{%content:left-top}</code> or&nbsp;<code>{%content:1}</code> or&nbsp;<code>{%content:xyz}</code> etc..</p>\n</div>\n
	<div class=\"pspaced\">\n<p><a name=\"static\"></a><img style=\"border: 0px initial initial;\" src=\"themes/default/images/editadd-static-content.png\" alt=\"editadd-static\" /><img style=\"border: 0px initial initial;\" src=\"themes/default/images/editadd-static-content.png\" alt=\"editadd-static\" /><img style=\"border: 0px initial initial;\" src=\"themes/default/images/editadd-static-content.png\" alt=\"editadd-static\" /><img style=\"border: 0px initial initial;\" src=\"themes/default/images/editadd-static-content.png\" alt=\"editadd-static\" />&nbsp;</p>\n<p><strong>Why do you call it \"static\" content?</strong><br />Whatever you put in this content widget will appear on EVERY PAGE that uses this static content widget.</p>\n<p><strong>Why would I use this for?? Same content on every page?</strong><br />A good example would be your footer text. it appears on every page.</p>\n<p><strong>Give me some code&nbsp;example to add these content areas to my templates:<br /></strong>to add a footer just add:&nbsp;<code>{%static:footer}</code></p>\n</div>
	\n
	<div class=\"pspaced\">\n<p><img style=\"border: 0px initial initial;\" src=\"themes/default/images/editadd-header.jpg\" alt=\"editadd-header\" /><img style=\"border: 0px initial initial;\" src=\"themes/default/images/editadd-header.jpg\" alt=\"editadd-header\" /><img style=\"border: 0px initial initial;\" src=\"themes/default/images/editadd-header.jpg\" alt=\"editadd-header\" /><img style=\"border: 0px initial initial;\" src=\"themes/default/images/editadd-header.jpg\" alt=\"editadd-header\" />&nbsp;</p>\n<p><strong>Why did you create a header widget when we already have the content widget?</strong><br />The content widget opens a very fancy editor allowing for HTML editing and all. We wanted the header to W3C compliant every time, so this is why we added this widget that opens a one line text field, nothing else than text can be added.</p>\n<p><strong>Give me some code&nbsp;example to add these header areas to my templates:<br /></strong>to add an h2 header for example just add:&nbsp;<code>&lt;\\h2&gt;{%header:xyz}&lt;\\/h2&gt;</code></p>\n</div>
	\n
	<div class=\"pspaced\">
	\n
	<p>
	<img style=\"border: 0px initial initial;\" src=\"themes/default/images/editadd-static-header.png\" alt=\"editadd-static-header\" />
	<img style=\"border: 0px initial initial;\" src=\"themes/default/images/editadd-static-header.png\" alt=\"editadd-static-header\" />
	<img style=\"border: 0px initial initial;\" src=\"themes/default/images/editadd-static-header.png\" alt=\"editadd-static-header\" />
	<img style=\"border: 0px initial initial;\" src=\"themes/default/images/editadd-static-header.png\" alt=\"editadd-static-header\" />
	&nbsp;
	</p>
	\n
	<p><strong>Why do you call it \"static\" header?</strong>
	<br />
	Whatever you put in this content widget will appear on EVERY PAGE that uses this static header	widget.
	<br />
	</p>
	<p>
	<strong>Why would I use this for?? Same header on every page?</strong>
	<br />
	A good example would be your header text. it appears on every page.
	<br />
	</p>
	<p>
	<strong>Give me some code example to add these headers to my templates:</strong>
	<br />
	to add a header just add: {%staticheader:siteName}
	<br />
	</p>
	\n</div>\n<div class=\"pspaced\">\n<p><img style=\"border: 0px initial initial;\" src=\"themes/default/images/editadd-code.jpg\" alt=\"editadd-code\" /><img style=\"border: 0px initial initial;\" src=\"themes/default/images/editadd-code.jpg\" alt=\"editadd-code\" /><img style=\"border: 0px initial initial;\" src=\"themes/default/images/editadd-code.jpg\" alt=\"editadd-code\" /><img style=\"border: 0px initial initial;\" src=\"themes/default/images/editadd-code.jpg\" alt=\"editadd-code\" />&nbsp;</p>\n<p><strong>What do you mean? I can add PHP code from the front?</strong><br />Yes, you can add scripts right there in the front. But pay attention! This is an advanced feature and you should know what you are doing when using it.</p>\n<p><strong>Why would I want to use this feature?</strong><br />Maybe as a quick shortcut to pull data from a database, use the \"include\" php function to bring up the latest statistics from a message board??</p>\n<p><strong>Is there any thing else I should know?</strong><br />Yes! When entering PHP code in this area, do not use &lt;?php --- &nbsp;?&gt; Enter your code without the PHP markup.</p>\n<p><strong>Give me some code&nbsp;example to add these header areas to my templates:<br /></strong>to add an h2 header for example just add:&nbsp;<code>&lt;\\h2&gt;{%code:xyz}&lt;\\/h2&gt;</code></p>\n</div>
	');"
	,

	"insert  into `link_reference`(`id_container`,`link`) values (80,'http://www.seotoaster.com/download-seotoaster'),(80,'http://www.seotoaster.com/Open-Source-CMS-Software'),(80,'http://www.seotoaster.com/who-is-seotoaster'),(80,'http://www.seotoaster.com/support'),(80,'http://www.seotoaster.com/contact-us'),(92,'http://www.seotoaster.com/index'),(97,'http://www.seotoaster.com/download-seotoaster'),(112,'http://www.seotoaster.com/add-and-edit-content'),(80,'http://www.seotoaster.com/how-to-use-seotoaster'),(70,'http://www.seotoaster.com/installation'),(79,'http://www.seotoaster.com/contact-us'),(88,'http://www.seotoaster.com/demo-seotoaster-cms-free-seo-software'),(80,'http://www.seotoaster.com/demo-seotoaster-cms-free-seo-software'),(80,'http://www.seotoaster.com/seo-affiliate-program'),(154,'http://www.seotoaster.com/how-to-create-a-page'),(154,'http://www.seotoaster.com/how-to-create-templates'),(166,'http://www.seotoaster.com/how-to-use-seotoaster'),(65,'http://www.seotoaster.com/on-site-seo-techniques'),(69,'http://www.seotoaster.com/on-site-seo-techniques'),(75,'http://www.seotoaster.com/on-site-seo-techniques'),(78,'http://www.seotoaster.com/on-site-seo-techniques'),(79,'http://www.seotoaster.com/on-site-seo-techniques'),(94,'http://www.seotoaster.com/on-site-seo-techniques'),(100,'http://www.seotoaster.com/on-site-seo-techniques'),(130,'http://www.seotoaster.com/on-site-seo-techniques'),(132,'http://www.seotoaster.com/on-site-seo-techniques'),(135,'http://www.seotoaster.com/on-site-seo-techniques'),(137,'http://www.seotoaster.com/on-site-seo-techniques'),(150,'http://www.seotoaster.com/on-site-seo-techniques'),(152,'http://www.seotoaster.com/on-site-seo-techniques'),(168,'http://www.seotoaster.com/on-site-seo-techniques'),(143,'http://www.seotoaster.com/on-site-seo-techniques'),(140,'http://www.seotoaster.com/automated-301-redirects-seo'),(140,'http://www.seotoaster.com/Optimized-user-experience'),(140,'http://www.seotoaster.com/deep-linking'),(140,'http://www.seotoaster.com/Google-Wheel-Keyword-Research'),(140,'http://www.seotoaster.com/how-to-create-a-page'),(69,'http://www.seotoaster.com/contact-us'),(117,'http://www.seotoaster.com/contact-us'),(203,'http://www.seotoaster.com/support'),(203,'http://www.seotoaster.com/how-to-use-seotoaster'),(206,'http://www.seotoaster.com/installation'),(59,'http://www.seotoaster.com/add-and-edit-content'),(59,'http://www.seotoaster.com/import-images-from-picasa'),(62,'http://www.seotoaster.com/working-with-media'),(60,'http://www.seotoaster.com/automated-301-redirects-seo'),(60,'http://www.seotoaster.com/Optimized-user-experience'),(60,'http://www.seotoaster.com/deep-linking'),(60,'http://www.seotoaster.com/link-siloing'),(62,'http://www.seotoaster.com/implementing-lucene'),(62,'http://www.seotoaster.com/how-to-add-a-comment-system'),(60,'http://www.seotoaster.com/on-site-seo-techniques'),(60,'http://www.seotoaster.com/Google-Wheel-Keyword-Research'),(62,'http://www.seotoaster.com/add-and-edit-content'),(80,'http://www.seotoaster.com/yahoo-merchant-alternative'),(69,'http://www.seotoaster.com/how-to-use-seotoaster'),(140,'http://www.seotoaster.com/link-siloing'),(99,'http://www.seotoaster.com/seo-training-free'),(212,'http://www.seotoaster.com/seo-training-free');"
	,
	"insert  into `page_image`(`id`,`page_id`,`name`,`path`,`description`) values (19,81,'opensourcefreeseocmsseotoaster.jpg','previews/opensourcefreeseocmsseotoaster.jpg',''),(22,81,'opensourcefreeseocmsseotoaster.jpg','previews/opensourcefreeseocmsseotoaster.jpg',''),(23,85,'what-is-seotoaster?.jpg','previews/what-is-seotoaster?.jpg',''),(24,81,'opensourcefreeseocmsseotoaster.jpg','previews/opensourcefreeseocmsseotoaster.jpg',''),(25,81,'opensourcefreeseocmsseotoaster.jpg','previews/opensourcefreeseocmsseotoaster.jpg',''),(27,85,'what-is-seotoaster?.jpg','previews/what-is-seotoaster?.jpg',''),(30,81,'opensourcefreeseocmsseotoaster.jpg','previews/opensourcefreeseocmsseotoaster.jpg',''),(31,81,'opensourcefreeseocmsseotoaster.jpg','previews/opensourcefreeseocmsseotoaster.jpg',''),(32,81,'opensourcefreeseocmsseotoaster.jpg','previews/opensourcefreeseocmsseotoaster.jpg',''),(33,85,'what-is-seotoaster?.jpg','previews/what-is-seotoaster?.jpg',''),(37,85,'what-is-seotoaster?.jpg','previews/what-is-seotoaster?.jpg',''),(38,81,'opensourcefreeseocmsseotoaster.jpg','previews/opensourcefreeseocmsseotoaster.jpg',''),(39,85,'what-is-seotoaster?.jpg','previews/what-is-seotoaster?.jpg',''),(60,81,'opensourcefreeseocmsseotoaster.jpg','previews/opensourcefreeseocmsseotoaster.jpg',''),(61,81,'opensourcefreeseocmsseotoaster.jpg','previews/opensourcefreeseocmsseotoaster.jpg','');"
	,
	"insert  into `renamed_pages`(`id_page`,`url`,`new_url`,`original_old_url`) values (104,'automated-301-redirects-seo.html','More-information','');"
	,
	"insert  into `template`(`id`,`name`,`content`,`preview_path`,`theme_name`) values (2,'category','<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\r\n\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\r\n<head>\r\n\r\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\r\n\r\n<title>{\$page_title}</title>\r\n\r\n<meta name=\"keywords\" content=\"{\$meta_keywords}\" />\r\n\r\n<meta name=\"description\" content=\"{\$meta_description}\" />\r\n\r\n<link href=\"style.css\" rel=\"stylesheet\" type=\"text/css\" media=\"screen\" />\r\n\r\n<link href=\"content.css\" rel=\"stylesheet\" type=\"text/css\" media=\"screen\" />\r\n\r\n<link rel=\"shortcut icon\" href=\"http://www.seotoaster.com/themes/seotoaster_site/images/favicon.ico\"/>\r\n\r\n</head>\r\n\r\n<body id=\"inner\">\r\n\r\n<div id=\"wrapper\"> {\$static_menu}\r\n\r\n  <div id=\"header-top\">\r\n\r\n    <h1>{\$page_h1}</h1>\r\n\r\n  </div>\r\n\r\n  <div id=\"rightcolumn\"> <img src=\"images/toaster-seo-right.jpg\" id=\"toasterright\" /> {\$static:right1}\r\n\r\n    <h3>{\$header:right2}</h3>\r\n\r\n    {\$content:right2}\r\n\r\n    <h3>{\$header:right3}</h3>\r\n\r\n    {\$content:right3}\r\n\r\n    <h3>{\$header:right4}</h3>\r\n\r\n    {\$content:right4} </div>\r\n\r\n  <div id=\"content\">\r\n\r\n    <h2>{\$header:1}</h2>\r\n\r\n    {\$content:1}\r\n\r\n    <h2>{\$header:2}</h2>\r\n\r\n    {\$content:2}\r\n\r\n    <h2>{\$header:3}</h2>\r\n\r\n    {\$content:3} </div>\r\n\r\n  <div id=\"footer\"> {\$static:footer} </div>\r\n\r\n</div>\r\n\r\n<!-- end wrapper -->\r\n<script type=\"text/javascript\">\r\ndocument.body.innerHTML=document.body.innerHTML.replace(/{%/g,\\'{\$\\');\r\n</script>\r\n</body>\r\n\r\n</html>','','seotoaster_site'),(3,'default','<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\r\n\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\r\n<head>\r\n\r\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\r\n\r\n<title>{\$page_title}</title>\r\n\r\n<meta name=\"keywords\" content=\"{\$meta_keywords}\" />\r\n\r\n<meta name=\"description\" content=\"{\$meta_description}\" />\r\n\r\n<link rel=\"shortcut icon\" href=\"http://www.seotoaster.com/themes/seotoaster_site/images/favicon.ico\"/>\r\n\r\n<link href=\"style.css\" rel=\"stylesheet\" type=\"text/css\" media=\"screen\" /> \r\n\r\n<link href=\"content.css\" rel=\"stylesheet\" type=\"text/css\" media=\"screen\" />\r\n\r\n</head>\r\n\r\n<body id=\"inner\">\r\n\r\n<div id=\"wrapper\"> \r\n\r\n  {\$static_menu}\r\n\r\n  <div id=\"header-top\">\r\n\r\n    <h1>{\$page_h1}</h1>\r\n\r\n  </div>\r\n\r\n  <div id=\"rightcolumn\"> <img src=\"images/toaster-seo-right.jpg\" id=\"toasterright\" alt=\"Open Source CMS\"/> \r\n\r\n {\$search_form:105}\r\n\r\n{\$static:right1}\r\n\r\n</div>\r\n\r\n  <div id=\"content\">\r\n\r\n{\$static:thursdaymeeting}\r\n\r\n    <h2>{\$header:1}</h2>\r\n\r\n    {\$content:1}\r\n\r\n    <h2>{\$header:2}</h2>\r\n\r\n    {\$content:2}\r\n\r\n    <h2>{\$header:3}</h2>\r\n\r\n    {\$content:3} \r\n\r\n    <h2>{\$header:4}</h2>\r\n\r\n    {\$content:4} \r\n\r\n</div>\r\n\r\n  <div id=\"footer\"> {\$static:footer} </div>\r\n\r\n</div>\r\n\r\n<!-- end wrapper -->\r\n\r\n<script type=\"text/javascript\">\r\n\r\ndocument.body.innerHTML=document.body.innerHTML.replace(/{%/g,\'{\$\');\r\n\r\n</script>\r\n\r\n</body>\r\n\r\n</html>','default.jpg','seotoaster_site'),(1,'index','<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\r\r\n\r\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\r\r\n    <head>\r\r\n        <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\r\r\n<meta name=\"google-site-verification\" content=\"quD3efFfYWs9EHXLvXCb67WaTS9V2coDzRZ9tvBpZhE\" />\r\r\n<meta name=\"google-site-verification\" content=\"quD3efFfYWs9EHXLvXCb67WaTS9V2coDzRZ9tvBpZhE\" />\r\r\n        <title>{\$page_title}</title>\r\r\n        <meta name=\"keywords\" content=\"{\$meta_keywords}\" />\r\r\n        <meta name=\"description\" content=\"{\$meta_description}\" />\r\r\n<link href=\"style.css\" rel=\"stylesheet\" type=\"text/css\" media=\"screen\" /> \r\r\n<link href=\"content.css\" rel=\"stylesheet\" type=\"text/css\" media=\"screen\" />\r\r\n       \r\r\n<link rel=\"shortcut icon\" href=\"http://www.seotoaster.com/themes/seotoaster_site/images/favicon.ico\"/>\r\r\n\r\r\n<script type=\"text/javascript\">\r\r\n		function troll(sc) {\r\r\n	$(\"#scroolnav a\").removeClass(\"selected\");\r\r\n		$(\"#scroolnav a#\"+sc).toggleClass(\"selected\");\r\r\n		var offsetbelt = $(\"#scrollerbelt\").offset();\r\r\n		var offset = $(\"#screen\"+sc).offset();\r\r\n		var goal=(offsetbelt.left - offset.left);\r\r\n		$(\"div #scrollerbelt\").animate({\"left\": goal}, 400); \r\r\n		}\r\r\n</script>\r\r\n    </head>\r\r\n\r\r\n    <body>\r\r\n    	<div id=\"wrapper\">\r\r\n        <div id=\"scrollermask\">\r\r\n            <div id=\"scrollerbelt\">\r\r\n                <div id=\"screen1\" class=\"screens\">\r\r\n                    <ul>\r\r\n                        <li class=\"left\" style=\"background:#ffffff url(\'images/seotoaster-slider-logo.jpg\') no-repeat top left;\">\r\r\n                            <h2>{\$header:screen1-left}</h2>\r\r\n                        </li>\r\r\n                    </ul>\r\r\n                </div>\r\r\n\r\r\n                <div id=\"screen2\" class=\"screens\">\r\r\n                    <ul>\r\r\n                        <li class=\"left\" style=\r\r\n                        \"background:#ffffff url(\'images/bg-slider-editor.jpg\') no-repeat top left;\">\r\r\n                            <h2>{\$header:screen3-left}</h2>\r\r\n                        </li>\r\r\n\r\r\n                        <li class=\"right\">\r\r\n                        {\$content:screen3-right}</li>\r\r\n                    </ul>\r\r\n                </div>\r\r\n\r\r\n                <div id=\"screen3\" class=\"screens\">\r\r\n                    <ul>\r\r\n                        <li class=\"left\" style=\r\r\n                        \"background:#ffffff url(\'images/bg-slider-build.jpg\') no-repeat top left;\">\r\r\n                            <h2>{\$header:screen4-left}</h2>\r\r\n                        </li>\r\r\n\r\r\n                        <li class=\"right\">\r\r\n                        {\$content:screen5-right}</li>\r\r\n                    </ul>\r\r\n                </div>\r\r\n\r\r\n                <div id=\"screen4\" class=\"screens\">\r\r\n                    <ul>\r\r\n                        <li class=\"left\" style=\r\r\n                        \"background:#ffffff url(\'images/bg-slider-seo.jpg\') no-repeat top left;\">\r\r\n                            <h2>{\$header:screen2-left}</h2>\r\r\n                        </li>\r\r\n\r\r\n                        <li class=\"right\">\r\r\n                            <p>{\$content:screen2-right}</p>\r\r\n                        </li>\r\r\n                    </ul>\r\r\n                </div>\r\r\n\r\r\n                <div id=\"screen5\" class=\"screens\">\r\r\n                    <ul>\r\r\n                        <li class=\"left\" style=\r\r\n                        \"background:#ffffff url(\'images/bg-slider-scale.jpg\') no-repeat top left;\">\r\r\n                            <h2>{\$header:screen5-left}</h2>\r\r\n                        </li>\r\r\n\r\r\n                        <li class=\"right\">\r\r\n                        {\$content:screen6-right}</li>\r\r\n                    </ul>\r\r\n                </div>\r\r\n            </div>\r\r\n            <!-- end scroller-belt-->\r\r\n        </div>\r\r\n        <!-- end scroller-mask-->\r\r\n\r\r\n        <div id=\"scroolnav\">\r\r\n            <a id=\"link1\" href=\"javascript:void(0);\" onclick=\r\r\n            \"javascript:troll(\'1\');\"></a> <span class=\"easyto\">EASY\r\r\n            TO:</span> <a id=\"2\" href=\"javascript:void(0);\"\r\r\n            onclick=\"javascript:troll(\'2\');\">USE</a> <a id=\"3\"\r\r\n            href=\"javascript:void(0);\" onclick=\r\r\n            \"javascript:troll(\'3\');\">BUILD</a> <a id=\"4\" href=\r\r\n            \"javascript:void(0);\" onclick=\r\r\n            \"javascript:troll(\'4\');\">SEO</a> <a id=\"5\" href=\r\r\n            \"javascript:void(0);\" onclick=\r\r\n            \"javascript:troll(\'5\');\">SCALE</a>\r\r\n        </div>\r\r\n\r\r\n        <div style=\r\r\n        \"display:block;height:30px;text-align:center;margin-top:20px;\">\r\r\n            {\$content:annoucements}\r\r\n        </div>\r\r\n		</div><!-- end wrapper -->\r\r\n    </body>\r\r\n</html>','','seotoaster_site'),
	(4,'news','<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\">
	<head>
	<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />
	<title>{\$page_title}</title>
	<meta name=\"keywords\" content=\"{\$meta_keywords}\" />
	<meta name=\"description\" content=\"{\$meta_description}\" />
	<link rel=\"shortcut icon\" href=\"http://www.seotoaster.com/themes/seotoaster_site/images/favicon.ico\"/>
	<link href=\"style.css\" rel=\"stylesheet\" type=\"text/css\" media=\"screen\" />
	<link href=\"content.css\" rel=\"stylesheet\" type=\"text/css\" media=\"screen\" />
	</head>
	<body id=\"inner\">
	<div id=\"wrapper\">
	{\$static_menu}
	<div id=\"rightcolumn\"> <a href=\"http://www.seotoaster.com\"><img src=\"images/toaster-seo-right.jpg\" id=\"toasterright\" alt=\"Open Source CMS\"/></a>
	{\$main_menu}
    </div>
	<div id=\"content\">
	{\$newslist}
	{\$newsitem}
	</div>
	</div>
</body>
</html>','','seotoaster_site');"
	,
	"CREATE PROCEDURE `replaceDeeplinkUrl`(IN oldUrl VARCHAR(255), IN newUrl VARCHAR(255))
	BEGIN
		DECLARE minId INT(10);
		DECLARE maxId INT(10);
		SELECT MIN(`deeplink`.`id`) INTO minId FROM `deeplink` WHERE `deeplink`.`url` = oldUrl;
		SELECT MAX(`deeplink`.`id`) INTO maxId FROM `deeplink` WHERE `deeplink`.`url` = oldUrl;
		UPDATE `deeplink` SET `deeplink`.`url` = newUrl WHERE `deeplink`.`id` BETWEEN minId AND maxId;
	END;"
	);
}

try {
	$install = new Install();
	$step = (isset($_POST['step'])?intval($_POST['step']):0);

	switch ($step) {
		/*case '0':
			$install->Welcome();
			break;*/
		case '1':
			$install->Step1();
			break;
		case '2':
			$install->Step2();
			break;
		case '3':
			$install->Step3();
			break;
		case '4':
			$install->Step4();
			break;
		case '5':
			$install->ThankYou();
			break;
		default:
			$install->Step1();
			break;
	}
}
catch (Exception $e) {
	echo $e->getMessage();
}

?>