<?php if (substr_count($_SERVER['HTTP_ACCEPT_ENCODING'], 'gzip') && !extension_loaded('zlib')) ob_start("ob_gzhandler"); else ob_start(); ?>
<?php
// Define path to application directory
defined('APPLICATION_PATH')
    || define('APPLICATION_PATH', realpath(dirname(__FILE__) . '/../application'));

// Define application environment
defined('APPLICATION_ENV')
    || define('APPLICATION_ENV', (getenv('APPLICATION_ENV') ? getenv('APPLICATION_ENV') : 'production'));

// Ensure library/ is on include_path
set_include_path(implode(PATH_SEPARATOR, array(
    realpath(APPLICATION_PATH . '/../library'),
    get_include_path(),
)));


//check if user moved his website
require_once 'Zend/Config/Xml.php';
require_once 'Zend/Config/Ini.php';
$xml = new Zend_Config_Xml(APPLICATION_PATH . '/configs/routesext.xml', 'routes');
$config = new Zend_Config_Ini(APPLICATION_PATH . '/configs/application.ini');
$parsedSiteUrl = parse_url($config->website->website->url);
$path = ($parsedSiteUrl['path'] == '/') ? '' : ltrim($parsedSiteUrl['path'], '/');
$explodedRoutes = explode('sys', $xml->default->route);
$neededPart = ($explodedRoutes[0] == '/') ? '' : $explodedRoutes[0];
//if($path != '') {
	if($neededPart != $path) {
		require_once 'system/misc/moved.php';
		exit;
	}
//}




/** Zend_Application */
require_once 'Zend/Application.php';  

// Create application, bootstrap, and run
$application = new Zend_Application(
    APPLICATION_ENV, 
    APPLICATION_PATH . '/configs/application.ini'
);

$application->bootstrap()
            ->run();