<?php

/**
 * Description of ThingsModel
 *
 * @author NE
 */
class Default_Model_ThingsModel extends RCMS_Core_BaseModel {
protected $_translateLanguagesTableName = 'translate_languages';
	/**
     * Search picture or file name in content
     * @param <string> $str
     * @return <array>
     */
    public function selectContentIdByValueLike($str)
    {
        $select = $this->_adapter->select()
        ->from(
            array('content' => 'content'),
            array('content_id' => 'id',
                        'container_id' => 'id_container'
            )
        )
        ->join(
            array('container'=>'container'),
                    'container.id = content.id_container',
            array('page_id' => 'page_id')
        )
        ->joinLeft(
            array('page' => 'page'),
                    'container.page_id = page.id',
                    array('page_url' => 'url')
                    )
                ->where('content.value LIKE \'%' . $str . '%\'')
                ->order('page.id DESC');
        return $this->_adapter->fetchAll($select);
    }

	//@todo move it from here!
	public function selectConfigForImage()
    {
        $select = $this->_adapter->select('name, value')->from('config')->where('name IN("img_small","img_medium","img_large","img_max_width")');        
        return $this->_adapter->fetchAssoc($select);
    }

	public function selectLanguageById($id)
    {
      	$select = $this->getAdapter()->select()->from($this->_translateLanguagesTableName,array('language'=>'language'))->where('id = ?',$id)->limit(1);
		return $this->getAdapter()->fetchOne($select);
    }

	public function selectLanguage(){
		$select = $this->getAdapter()->select()->from('config',array('value'=>'value'))->where('name = ?','translate_language')->limit(1);
		return $this->getAdapter()->fetchOne($select);
	}
}

