<?php
/**
 * Description for Theme Model
 *
 * @author Pavel Savchuk
 */
class Default_Model_ThemeModel extends RCMS_Core_BaseModel {
	protected $_translateLanguagesTableName = 'translate_languages';
	
    private $_categoryTableName = "category";

    public function updateCurrentThemeInConfigTable($theme)
    {
        $data = array('value' => $theme);
        return $this->_adapter->update('config', $data, "name = 'current_theme'");
    }

    public function selectTemplateByName($theme)
    {
        $where = sprintf("name = '%s'", $theme);
        $sql = $this->_adapter->select("COUNT(*)")->from('template')->where($where);
        return $this->_adapter->fetchOne($sql);
    }

    public function selectTemplateByTemplateName($name)
    {
        $where = sprintf("name = '%s'", $name);
        $sql = $this->_adapter->select()->from('template')->where($where);
        return $this->_adapter->fetchRow($sql);
    }

    public function selectCurrentTheme()
    {
        $sql = $this->_adapter->select()
        ->from(array('config'=>'config'), array('value'=>'value'))
        ->where("name='current_theme'");
        return $this->_adapter->fetchOne($sql);
    }

    public function deleteTemplates()
    {
        return $this->_adapter->delete('template');
    }

/*
* @method delete template by id
     * @param $templateId
     * @return boolean
 */
    public function deleteTemplateById($id)
    {
        if($id>0){
            $where = sprintf("id = %d", $id);
            return $this->_adapter->delete('template', $where);
        }
    }


 /**
     * @method update template
     * @param $templateId,$pageId
     * @return array
     */
    public function updateTemplateIdForPageTable($templateId,$pageId)
    {
        return $this->getAdapter()->update('page', array('template_id' => $templateId),'id = '.$pageId);
    }

    /**
     * @method select all pages
     * @return array
     */
    public function selectAllPages()
    {
        $select = $this->_adapter->select()
        ->from('page');
        return $this->_adapter->fetchAll($select, null,  Zend_Db::FETCH_ASSOC);
    }

 /**
     * @method Check is category
     * @param $categoryId
     * @return boolean
     */
    public function isCategory($categoryId)
    {
        if(intval($categoryId)>0){
            $categoryObj = $this->selectCategoryById($categoryId);
            if($categoryObj->id_parent==0)
            {
                return true;
            }
        }else
        {
            return false;
        }
        return false;

    }

   /**
     * @method Select category by $id
     * @param string $parentId
     */
    public function selectCategoryById($id)
    {
        if($id>0){
            $select = $this->getAdapter()->select()->from($this->_categoryTableName)->where('id=?', $id);
            $result = $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_OBJ);
            return $result;
        }else
        {
            return null;
        }
    }

	public function selectLanguageById($id)
    {
      	$select = $this->getAdapter()->select()->from($this->_translateLanguagesTableName,array('language'=>'language'))->where('id = ?',$id)->limit(1);
		return $this->getAdapter()->fetchOne($select);
    }

	public function selectLanguage(){
		$select = $this->getAdapter()->select()->from('config',array('value'=>'value'))->where('name = ?','translate_language')->limit(1);
		return $this->getAdapter()->fetchOne($select);
	}
}

