<?php

/**
 * Description for Redirect Model
 *
 * @author Pavel Savchuk
 */
class Default_Model_RedirectModel extends RCMS_Core_BaseModel {

    protected $_pageTableName = 'page';

    protected $_renamedTableName = 'renamed_pages';

	/**
	 *Selects all pages urls except no-categiry
	 * @return <array>
	 */
    public function selectPagesUrl() {
        $select = $this->getAdapter()->select()
			->from(
				array('page' => $this->_pageTableName),
                array('id', 'url')
			)
			->where('url <> ?', RCMS_Object_QuickConfig_QuickConfig::$draftCategoryUrl)
			->where('url <> "no-category" ')
			->where('is_404page != "1"')
			->order("url");
        $result = $this->getAdapter()->fetchPairs($select);
        return $result;
    }

	/**
	 *Selects all redirects
	 * @return <array>
	 */
      public function getAllRedirects()
   {
       $select = $this->getAdapter()->select()->from($this->_renamedTableName);
       $result = $this->_adapter->fetchAll($select, null, Zend_Db::FETCH_OBJ);
       return $result;
   }

	/**
	 *Updates original old url
	 * @param integer $id
	 * @param string $originalOldUrl
	 * @return <array>
	 */
   public function updateOriginalOldUrl($id,$originalOldUrl)
   {
       $data = array(
            'original_old_url'=>$originalOldUrl,
        );
     return $this->getAdapter()->update($this->_renamedTableName, $data,"id_page = ".$id);
   }

   public function selectDraftCategoryId() {
	   $select = $this->getAdapter()->select()
		->from(
			array('c' => 'category'),
			array(
				'id'
			)
		)
		->where('c.name=?', RCMS_Object_QuickConfig_QuickConfig::$draftCategoryName);
		return $this->getAdapter()->fetchOne($select);
   }

   public function getParentCategory($id) {
	   $select = $this->getAdapter()->select()
		->from(
			array('c' => 'category'),
			array(
				'parentCategoryId' => 'id_parent'
			)
		)
		->joinLeft(
			array('p' => 'page'),
			'c.id = p.category_id'
		)
		->where('p.id=?', $id);
	   return $this->getAdapter()->fetchOne($select);
   }
}

