<?php
/**
 * Description for Plugin Model
 *
 * @author Pavel Savchuk
 */
class Default_Model_PluginModel extends RCMS_Core_BaseModel {
protected $_translateLanguagesTableName = 'translate_languages';

	public function selectTemplateByTemplateName($name) {
		$where = sprintf("name = '%s'", $name);
		$sql = $this->_adapter->select()->from('template')->where($where);
		return $this->_adapter->fetchRow($sql);
	}

	public function selectCurrentTheme() {
		$sql = $this->_adapter->select()
			->from(array('config'=>'config'), array('value'=>'value'))
			->where("name='current_theme'");
		return $this->_adapter->fetchOne($sql);
	}


	/**
	 * This function selects data by id.
	 * @param integer $id
	 * @return object
	 */
	public function selectPluginByName($name) {
		$select = $this->_adapter->select()->from('plugin')->where('name = ?', $name);
		return $this->_adapter->fetchRow($select);
	}

	/**
	 * This function intall plugin.
	 * @param string $sql
	 * @return object
	 */
	public function executePluginSql($sql) {
		
			$arr = explode("/*~query~*/", $sql);

			if($arr){
			foreach($arr as $qr)
			try{
				$this->getAdapter()->getConnection();
			    $this->getAdapter()->query(trim($qr));
				$this->getAdapter()->closeConnection();
			}catch (Exception $e)
			{
				//echo $e->getMessage();
				return false;
			}


			}
			return true;
	}

	/**
	 * This function selects data by id.
	 * @param integer $id
	 * @return object
	 */
	public function selectContentPairs() {
		$select = $this->_adapter->select()->from('content',array(
			'id' => 'id',
			'value' => 'value'
			));
		return $this->getAdapter()->fetchAssoc($select);
	}

	public function updateContent($id,$value) {
		$data = array (
			'value'		=> $value
		);
		$where =  sprintf("id = %d",$id);
		return $this->_adapter->update('content', $data, $where);
	}

	public function selectTemplates() {
		$select = $this->_adapter->select()->from('template',
			array('id' => 'id', 'content' => 'content','name'=>'name'));
		return $this->getAdapter()->fetchAssoc($select);
	}

	public function updateTemplate($id,$value) {
		$data = array (	'content' => $value );
		$where =  sprintf("id = %d",$id);
		return $this->_adapter->update('template', $data, $where);
	}

public function selectLanguageById($id)
    {
      	$select = $this->getAdapter()->select()->from($this->_translateLanguagesTableName,array('language'=>'language'))->where('id = ?',$id)->limit(1);
		return $this->getAdapter()->fetchOne($select);
    }

 public function selectLanguage(){
		$select = $this->getAdapter()->select()->from('config',array('value'=>'value'))->where('name = ?','translate_language')->limit(1);
		return $this->getAdapter()->fetchOne($select);
	}
}

