<?php

/**
 * Description for Page Model
 *
 * @author Pavel Savchuk
 */
class Default_Model_PageModel extends RCMS_Core_BaseModel {

	protected $_categoryTableName = 'category';

	protected $_pageTableName = 'page';

	protected $_imageTableName = 'page_image';

	protected $_featureadAreaTableName = 'featured_area';

	protected $_pageHasFaTable = 'page_has_fa';

	protected $_contentTableName = 'content';

	protected $_tablePageHasFaName = 'page_has_fa';

	public function selectTest($name) {
		$select = $this->getAdapter()->select()->from('test')->where("name = ?",$name)->limit(1);
		$stmt   = $this->getAdapter()->query($select);
		$result = $stmt->fetchAll();
		if($result)
			return $result;
		return null;
	}


	public function getLastPageId() {
		$select = $this->getAdapter()->select()->from($this->_pageTableName,array("id"=>'MAX(id)'));
		$result = $this->_adapter->fetchOne($select);
		return $result;
	}

	public function getHomePageId() {
		$select = $this->getAdapter()->select()->from($this->_pageTableName,array("id"=>'id'))->where("url = 'index'")->limit(1);
		$result = $this->_adapter->fetchOne($select);
		return $result;
	}

	public function insertTest($name,$value) {
		$pageData = array(
			'name'=>$name,
			'value'=>$value
		);
		$this->getAdapter()->insert('test', $pageData);
		return $result;
	}

	/**
	 * @method Select all categories(parentId has to be 0)
	 * @param string $parentId
	 */
	public function selectAllCategories($parentId=0) {
		$select = $this->getAdapter()->select()->from($this->_categoryTableName,array('id','name'))->where('id_parent=?', $parentId);
		$result = $this->_adapter->fetchPairs($select);
		return $result;
	}

	/**
	 * @method Select category by $id
	 * @param string $parentId
	 */
	public function selectCategoryById($id) {
		if($id>0) {
			$select = $this->getAdapter()->select()->from($this->_categoryTableName)->where('id=?', $id);
			$result = $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_OBJ);
			return $result;
		}else {
			return null;
		}
	}


	/**
	 * @method Select page preview image by $pageId
	 * @param <Integer> $parentId
	 */
	public function selectPageImage($pageId) {
		$select = $this->getAdapter()->select()->from($this->_imageTableName)->where('page_id=?', $pageId);
		$result = $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_OBJ);
		return $result;
	}

	/**
	 * @method Select page preview image size
	 * @param <Integer> $imageSize
	 */
	public function selectPageImageSize() {
		$select = $this->getAdapter()->select()->from('config',array('value'));
		$result = $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_OBJ);
		return $result;
	}

	/**
	 * @method Select page preview image size
	 * @param <Integer> $imageSize
	 */
	public function selectValueFromConfig($key) {
		$select = $this->getAdapter()->select()->from('config',array('value'))->where('name = ?',$key);
		$result = $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_OBJ);
		return $result;
	}

	/**
	 * @method Insert new category
	 * @param <String> $categoryName, $parentId
	 * @return <Integer>
	 */
	public function insertNewCategory($categoryName,$parentId=0) {
		$data = array(
			'id_parent'=>$parentId,
			'name'=>$categoryName
		);
		$result = $this->getAdapter()->insert($this->_categoryTableName, $data);
		return $this->getAdapter()->lastInsertId($this->_categoryTableName);
	}

	/**
	 * @method update category by categoryId
	 * @param <String> $name,<Integer> parentId, <Integer> $categoryId,
	 * @return <Integer>
	 */
	public function updateCategory($name,$categoryId,$parentId=0) {

		$data = array(
			'name'=>$name,
			'id_parent'=>$parentId);

		$where = sprintf("id = %d", $categoryId);
		$result = $this->getAdapter()->update($this->_categoryTableName, $data,$where);
		return $result;
	}

	/**
	 * @method Insert page preview
	 * @param <String> $imageName,<Integer> $pageId,<String> $description
	 * @return <Integer> last inserted id
	 */
	public function insertPagePreview($imageName,$pageId,$imagePath,$description="") {
		$data = array(
			'page_id'=>$pageId,
			'name'=>$imageName,
			'path'=>$imagePath,
			'description'=>$description
		);

		$result = $this->getAdapter()->insert($this->_imageTableName, $data);
		return $this->getAdapter()->lastInsertId($this->_imageTableName);
	}

	/**
	 * @method update page preview by pageId
	 * @param <String> $imageName,<Integer> $pageId,<String> $description
	 * @return <Integer>
	 */
	public function updatePagePreview($imageName,$pageId,$imagePath,$description="") {
		$data = array(
			'name'=>$imageName,
			'path'=>$imagePath,
			'description'=>$description
		);

		$result = $this->getAdapter()->update($this->_imageTableName, $data,"page_id = ".$pageId);
		return $result;
	}


	public function selectAllFeaturedAreas() {
		$select = $this->getAdapter()->select()->from($this->_featureadAreaTableName,array('id','name'));
		$result = $this->_adapter->fetchPairs($select);
		return $result;
	}


	public function selectFeaturedAreasByPageId($pageId) {
		if(intval($pageId) && $pageId>0) {
			$select = $this->getAdapter()->select()->from($this->_pageHasFaTable,array('fa_id'))->where('page_id = ?',$pageId);
			return $this->_adapter->fetchAll($select, null,  Zend_Db::FETCH_ASSOC);
		}
		return null;
	}


	public function selectContainerIdsForPageByPageId($pageId) {
		$select = $this->getAdapter()->select()
			->from(
			array('c' => 'container'),
			array(
			'id'
			)
			)
			->where('c.page_id=?', $pageId);
		return $this->_adapter->fetchAll($select, null, Zend_Db::FETCH_ASSOC);
	}


	/**
	 * @method select featured area by id
	 * @param <Integer> $id
	 * @return <Object> Featured Area row
	 */
	public function selectFeaturedAreaById($id) {
		$select = $this->getAdapter()->select()->from($this->_featureadAreaTableName)->where('id=?', $id);
		$result = $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_OBJ);
		return $result;
	}

	/**
	 * @method select featured area by h1 title
	 * @param <String> $h1
	 * @return <Object> Page row
	 */
	public function selectPageByH1($h1) {
		$select = $this->getAdapter()->select()->from($this->_pageTableName)->where('h1=?', $h1);
		$result = $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_OBJ);
		return $result;
	}

	/**
	 * @method select page by navigation name
	 * @param <String> $navigationName
	 * @return <Object> Page row
	 */
	public function selectPageByNavigationName($navigationName) {
		$select = $this->getAdapter()->select()->from($this->_pageTableName)->where('nav_name=?', $navigationName);
		$result = $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_OBJ);
		return $result;
	}


	/**
	 * @method select category by navigation name
	 * @param <String> $categoryName
	 * @return <Object> Page row
	 */
	public function selectCategoryByName($categoryName,$parentId=0) {
		$select = $this->_adapter->select()->from($this->_categoryTableName)->where('name=?', $categoryName)->where('id_parent=?',$parentId);
		$result = $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_OBJ);
		return $result;
	}

	/**
	 * @method select url by url
	 * @param <String> $url
	 * @return <Object> Page row
	 */
	public function selectUrl($url) {
		$select = $this->_adapter->select()->from($this->_pageTableName)->where('url=?', urlencode($url));
		$result = $this->_adapter->fetchOne($select, null, Zend_Db::FETCH_OBJ);
		return $result;
	}


	/**
	 * Delete category by id
	 * @param <integer> $id
	 * @return <string>
	 */
	public function deleteCategoryById($id) {
		if($id>0) {
			$where = sprintf("id = %d", $id);
			return $this->_adapter->delete('category', $where);
		}
	}

	/**
	 * Delete content by id_container
	 * @param <integer> $id
	 * @return <string>
	 */
	public function deleteContentByIdContainer($id) {
		if($id>0) {
			$where = sprintf("id_container = %d", $id);
			return $this->_adapter->delete('content', $where);
		}
	}



	/**
	 * Delete featureda areas by pageId
	 * @param <integer> $pageId
	 * @return <string>
	 */
	public function deleteFeaturedAreasByPageId($pageId) {
		if($pageId>0) {
			return  $this->getAdapter()->delete($this->_tablePageHasFaName,"page_id = ".$pageId);

		}
	}

	/**
	 * Delete container by pageId
	 *
	 * @param RCMS_Object_Container_Container $container
	 */
	public function deleteContainerByPageId($pageId) {
		if($pageId>0) {
			$where = sprintf("page_id = %d", $pageId);
			return $this->_adapter->delete('container', $where);
		}
	}

	/**
	 * Delete container by pageId
	 *
	 * @param RCMS_Object_Container_Container $container
	 */
	public function selectPageImagesByPageId($pageId) {
		if($pageId>0) {
			$where = sprintf("page_id = %d", $pageId);
			$select = $this->_adapter->select()
				->from('page_image')->where($where);
			return $this->_adapter->fetchAll($select, null, Zend_Db::FETCH_OBJ);
		}
	}

	public function getPagesCategories() {
		$select = $this->getAdapter()->select()
			->from(
			array('p' => 'page'),
			array(
			'id',
			'categoryId' => 'category_id',
			'navigationTitle' => 'nav_name',
			'url',
			'h1',
			'order',
			'keywords' => 'meta_keywords'
			)
			)
			->joinLeft(
			array('c' => 'category'),
			'p.category_id=c.id',
			array('categoryName' => 'name')
			)
			->where('c.id_parent=0')
			->where('p.show_in_menu=\'1\'')
			->order('p.order ASC');
		return $this->_adapter->fetchAll($select, null, Zend_Db::FETCH_ASSOC);
	}

	public function getPagesForCategory($categoryId) {
		$select = $this->getAdapter()->select()
			->from(
			array('p' => 'page'),
			array(
			'id',
			'categoryId' => 'category_id',
			'navigationTitle' => 'nav_name',
			'url',
			'h1',
			'order',
			'keywords' => 'meta_keywords',
			'menu' => 'show_in_menu'
			)
			)
			->joinLeft(
			array('c' => 'category'),
			'p.category_id=c.id',
			array('categoryName' => 'name')
			)
			->where('c.id_parent=?', $categoryId)
			->where('p.show_in_menu=\'1\'')
			->order('p.order ASC');
		return $this->_adapter->fetchAll($select, null, Zend_Db::FETCH_ASSOC);
	}

	/**
	 * Get data for static menu
	 *
	 * @return array
	 */
	public function getStaicMenuPages() {
		$select = $this->getAdapter()->select()
			->from(
			array('p' => 'page'),
			array(
			'id',
			'categoryId' => 'category_id',
			'navigationTitle' => 'nav_name',
			'url',
			'h1',
			'order',
			'keywords' => 'meta_keywords',
			'menu' => 'show_in_menu'
			)
			)
			->joinLeft(
			array('c' => 'category'),
			'p.category_id=c.id',
			array('categoryName' => 'name')
			)
			->where('p.show_in_menu=\'2\'')
			->order('p.static_order ASC');
		return $this->_adapter->fetchAll($select, null, Zend_Db::FETCH_ASSOC);
	}

	public function getNoMenuPages() {
		$select = $this->getAdapter()->select()
			->from(
			array('p' => 'page'),
			array(
			'id',
			'categoryId' => 'category_id',
			'navigationTitle' => 'nav_name',
			'url',
			'h1',
			'keywords' => 'meta_keywords',
			'menu' => 'show_in_menu'
			)
			)
			->joinLeft(
			array('c' => 'category'),
			'p.category_id=c.id',
			array('categoryName' => 'name')
			)
			->where('p.show_in_menu=\'0\'')
			->order('p.id ASC');
		return $this->_adapter->fetchAll($select, null, Zend_Db::FETCH_ASSOC);
	}

	public function insertPageHasFa($pageId,$faId) {
		$data = array(
			'page_id'=>$pageId,
			'fa_id'=>$faId,

		);
		return $this->getAdapter()->insert($this->_pageHasFaTable, $data);
	}

	public function selectNotFoundPage() {
		$select = $this->getAdapter()->select()
			->from(
			array('p' => 'page'),
			array(
			'url',
			)
			)
			->where('p.is_404page=\'1\'');
		return $this->getAdapter()->fetchOne($select, null, Zend_Db::FETCH_ASSOC);
	}

	public function updateNotFoundState($url, $state) {
		$data = array(
			'is_404page' => $state
		);
		$where = sprintf("url = '%s'", $url);
		$result = $this->getAdapter()->update('page', $data, $where);
		return $result;
	}

	public function selectCommentsToNotify($containerId) {
		$select = $this->getAdapter()->select()->from('comment')->where('container_id = ?',$containerId)->where('notify=1');
		return  $this->getAdapter()->fetchAll($select, null, Zend_Db::FETCH_ASSOC);
	}

	public function selectAdminEmail() {
		$select = $this->getAdapter()->select()->from('config')->where('name = ?', 'admin_email');
		return  $this->getAdapter()->fetchPairs($select);
	}

	public function selectDataForSearchIndex() {
		$select = $this->getAdapter()->select()
			->from(
			array('p' => 'page'),
			array(
			'id' => 'id',
			'meta_description' => 'meta_description',
			'meta_keywords' => 'meta_keywords',
			'header_title' => 'header_title',
			'short_description' => 'short_description'
			))
			->joinLeft(
			array('c' => 'container'),
			'c.page_id = p.id',array()
			)->joinLeft(
			array('con' => 'content'),
			'con.id_container = c.id',
			array('value'=>'con.value')
			)->group('p.id');
		return $result = $this->_adapter->fetchAll($select, null, Zend_Db::FETCH_ASSOC);
	}

	public function selectCategoryIdByName($name) {
		$select = $this->getAdapter()->select()
			->from(
			array('c' => 'category'),
			array(
			'id'
			)
			)
			->where('c.name = ?', $name);
		return $this->getAdapter()->fetchOne($select);
	}

	public function selectDraftPagesUrls($draftCatId) {
		$select = $this->getAdapter()->select()
			->from(
			array('p' => 'page'),
			array(
			'pageUrl'     => 'url',
			'pageNavName' => 'nav_name'
			)
			)
			->joinLeft(
			array('c' => 'category'),
			'p.category_id = c.id'
			)
			->where('c.id_parent=?', $draftCatId);
		$result = $this->getAdapter()->fetchAll($select);
		if(is_array($result) && !empty($result)) {
			return $result;
		}
		return 0;
	}

	public function deleteContainerDependencies($id) {
		return $this->getAdapter()->delete('link_reference', 'id_container=' . $id);
	}

	public function deleteDeeplinksDependencies($pageUrl) {
		$where = sprintf("'%s'", $pageUrl);
		return $this->getAdapter()->delete('deeplink', 'url=' . $where);
	}
}

