<?php

/**
 * Index model for Login Controller
 *
 * @author eugene
 */
class Default_Model_IndexModel extends RCMS_Core_BaseModel {

    private $_templateTable = "template";
    private $_categoryTable = "category";
    private $_pageTable = "page";
	private $_configTable = "config";

    public function getRequestedData($pageUrl) {
        $select = $this->getAdapter()->select()
			->from(
				array('p' => 'page')
			)
			->join(
				array('t' => 'template'),
					'p.template_id=t.id',
				array(
					'templateId' => 'id',
					'templateName'=>'name',
					'templateContent' => 'content',
					'templatePreview' => 'preview_path',
					'templateTheme' => 'theme_name'
				))
			->join(
				array('c' => 'category'),
					'p.category_id=c.id',
				array(
					'categoryId' => 'id',
					'parentCategory' => 'id_parent',
                    'categoryName' => 'name'
				))
			->where('url=?', $pageUrl);
        return $result = $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_ASSOC);
    }

      public function selectCategoryByName($categoryName) {
        $select = $this->getAdapter()->select()
			->from($this->_categoryTable)
			->where('name=?', $categoryName);
        return $result = $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_ASSOC);
    }

	    public function getRequestedNewsData($newsUrl) {
        $select = $this->getAdapter()->select()
        ->from(
            array('n' => 'news'),
            array(
                                'newsId' => 'id',
                                'newsTitle' => 'title',
                                'newsUrl' => 'page_url',
                                'newsIntro' => 'intro',
                                'newsText' => 'text',
                                'newsDate' => 'date',
                                'newsOrder' => 'order',
                                'newsArchived' => 'is_archived',
                                'newsFeatured' => 'is_featured',
                                'newsDisableArchive' => 'disable_archive',
                                'newsLastUpdate' => 'last_update',
								'newsMetaDescription' => 'news_meta_description',
								'newsMetaKeywords' => 'news_meta_keywords'
            ))
        ->joinLeft(
            array('nc' => 'newscategory'),
                            'n.id_newscategory=nc.id',
            array(
                                'newsCtaegoryId' => 'id',
                                'newsCtaegoryName' => 'name'
            ))->where('n.page_url=?', $newsUrl);
        return $result = $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_ASSOC);
    }

    public function selectCurrentTheme()
    {
        $sql = $this->_adapter->select()
        ->from(array('config'=>'config'), array('value'=>'value'))
        ->where("name='current_theme'");
        return $this->_adapter->fetchOne($sql);
    }

    public function selectTemplateByName($name)
    {
        $where = sprintf("name = '%s'", $name);
        $select = $this->_adapter->select()->from($this->_templateTable)->where($where);
        return $this->getAdapter()->fetchOne($select);
    }
    public function updatePublishedContent()
    {
        $data = array('published'=>'1');
        $where[] = "publishing_date<=NOW()";
        $where[] = "publishing_date!='0000-00-00 00:00:00'";
        $result = $this->getAdapter()->update('container', $data,$where);
        return $result;
    }

	public function getPage404Url() {
		$select = $this->getAdapter()->select()
        ->from(
            array('p' => 'page'),
            array(
                    'url',
            )
        )
        ->where('p.is_404page=\'1\'');
		return $this->getAdapter()->fetchOne($select, null, Zend_Db::FETCH_ASSOC);
	}

      public function insertNewCategory($categoryName,$parentId=0)
    {
        if($categoryName=='no category')
        {
            $data = array(
             'id'=>'-1',
             'id_parent'=>$parentId,
             'name'=>$categoryName
        );
        }else
        {

        $data = array(
             'id_parent'=>$parentId,
             'name'=>$categoryName
        );
            }
        $result = $this->getAdapter()->insert($this->_categoryTable, $data);
        return $this->getAdapter()->lastInsertId($this->_categoryTable);
    }

    public function getPageByUrl($pageUrl)
    {
        $select = $this->getAdapter()->select()->from($this->_pageTable)->where('url=?', $pageUrl);
        return $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_OBJ);
    }

	/**
	 * Trying to get content for services
	 */
	public function selectServicesContent() {
		$select = $this->_adapter->select()
		->from(
			array('wls' => 'whitelabel_services'),
			array(
				'servicesContent' => 'services_content'
			)
		);
		return $this->_adapter->fetchAll($select, null, zend_Db::FETCH_ASSOC);
	}

	 public function selectConfigValue($name) {
        $select = $this->getAdapter()->select()->from($this->_configTable)->where('name = ?',$name);
        $result = $this->getAdapter()->fetchRow($select, null, Zend_Db::FETCH_OBJ);
		if($result->value){
        return $result->value;
		}else
		{
			return "";
		}
    }

	public function getCategoryIdByName($name) {
		$select = $this->getAdapter()->select()
			->from(
				array('c' => 'category'),
				array(
					'id'
				)
			)
			->where('c.name = ?', $name);
		return $this->getAdapter()->fetchOne($select);
	}

	public function countDraftPages($draftCatId) {
		$select = $this->getAdapter()->select()
			->from(
				array('p' => 'page'),
				array('pageId' => 'id')
			)
			->joinLeft(
				array('c' => 'category'),
				'p.category_id = c.id'
			)
			->where('c.id_parent=?', $draftCatId);
		$result = $this->getAdapter()->fetchAll($select);
		return (count($result));
	}
}