<?php
/**
 * Description for Featured Area Model
 *
 * @author Pavel Savchuk
 */
class Default_Model_FeaturedareaModel extends RCMS_Core_BaseModel {

	protected $_faTableName = 'featured_area';
	protected $_pageTableName = 'page';

	/**
	 *Selects all featured areas
	 * @return <array>
	 */
	public function  selectAllFeaturedAreas() {
		$select = $this->_adapter->select()
			->from(
			array('featured_area' => 'featured_area'),
			array('id' => 'id',
			'name' => 'name',
			'order' => 'order'
			)
			)
			->joinLeft(
			array('page_has_fa'=>'page_has_fa'),
			'featured_area.id = page_has_fa.fa_id'
			)
			->joinLeft(
			array('page' => 'page'),
			'page_has_fa.page_id = page.id',
			array('pages' => 'count(page.id)')
			)
			->group('featured_area.id');
		//return $this->_adapter->fetchAll($select);
		return $this->_adapter->fetchAll($select, null, Zend_Db::FETCH_ASSOC);

	}
	/**
	 *Selects featured area by name
	 * @param string $name
	 * @return <array>
	 */
	public function  selectFeaturedAreaByName($name) {
		$select = $this->getAdapter()->select()
			->from('featured_area')
			->where('name=?',$name);
		return $this->_adapter->fetchOne($select);

	}

	/**
	 *Inserts featured area
	 * @param <string> $name
	 * @return <integer>
	 */
	public function inserFeaturedArea($name) {
		$pageData = array(
			'name'=>$name,
		);
		$this->getAdapter()->insert($this->_faTableName, $pageData);
		return $this->getAdapter()->lastInsertId($this->_faTableName);

	}


}
