<?php

class Default_Model_DeeplinkModel extends RCMS_Core_BaseModel {
    
    protected $_deeplinkTableName = 'deeplink';
    protected $_pageTableName = 'page';

    /**
     * Select count overlaps
     * @param <string> $name
     * @return <string>
     */
    public function selectDeeplinkByName($name)
    {
        $where = sprintf("name = '%s'", $name);
        $select = $this->_adapter->select()->from($this->_deeplinkTableName,"COUNT(*)")
        ->where($where);
        return $this->_adapter->fetchOne($select);
    }

    /**
    * Get all pages
    * @return <array>
    */
    public function selectAllPages()
    {
		$select = $this->_adapter->select()
			->from(
				array('p' => 'page'),
				array(
					'id',
					'nav_name',
					'url',
					'h1',
					'category_id'
				)
			)
			->joinLeft(
				array('c' => 'category'),
				'c.id = p.category_id',
				array(
					'parentCategoryId' => 'id_parent',
				)
			)
			->where('url <> ?', RCMS_Object_QuickConfig_QuickConfig::$draftCategoryUrl)
			->where("url <> 'no-category'");
        return $this->_adapter->fetchAll($select);


//        $select = $this->_adapter->select()->from($this->_pageTableName)->where('url <> "no-category"');
//        return $this->_adapter->fetchAll($select);
    }

    public function selectAllDeeplinks()
    {
        $select = $this->_adapter->select()->from($this->_deeplinkTableName)->where('name != ""')->order("name ASC");
        return $this->_adapter->fetchAll($select);
    }

	public function selectDraftCategoryId() {
	   $select = $this->getAdapter()->select()
		->from(
			array('c' => 'category'),
			array(
				'id'
			)
		)
		->where('c.name=?', RCMS_Object_QuickConfig_QuickConfig::$draftCategoryName);
		return $this->getAdapter()->fetchOne($select);
   }

}
