<?php

/**
 * Description of ContainerModel
 *
 * @author NE
 */
class Default_Model_ContainerModel extends RCMS_Core_BaseModel {

	private $_pageTableName = 'page';
    private $_variableTableName = 'variable_content';
    private $_formsTableName = 'forms';
	private $_categoryTableNAme = 'category';
    private $_shoppingGroup = 'shopping_groups';
    private $_shoppingProducts = 'shopping_products';
    private $_shoppingProductsGroups = 'shopping_products_groups';

	//@todo move it from here!
	public function selectConfigForImage() {
        $select = $this->_adapter->select('name, value')->from('config')->where('name IN("img_small","img_medium","img_large")');        
        return $this->_adapter->fetchAssoc($select);
    }

    /**
     * Get all featured areas names
     * @return <array>
     */
    public function selectFeaturedAreasNames()
    {
        $select = $this->_adapter->select()->from('featured_area',array('name'=>'name'))->order("name ASC");
        $adapter = $this->getAdapter();
        return $adapter->fetchAssoc($select, null, Zend_Db::FETCH_ASSOC);
    }

	/**
     * Get all pages 
     * @return <array>
     */
    public function selectAllPages()
    {
        $select = $this->_adapter->select()
			->from(
				array('p' => 'page'),
				array(
					'id',
					'nav_name',
					'url',
					'h1',
					'category_id',
					'is_404page'
				)
			)
			->joinLeft(
				array('c' => 'category'),
				'c.id = p.category_id',
				array(
					'parentCategoryId' => 'id_parent',
				)
			)
			->where('url <> ?', RCMS_Object_QuickConfig_QuickConfig::$draftCategoryUrl)
			->where("url <> 'no-category'");
        return $this->_adapter->fetchAll($select);
    }

	public function selectDraftCategoryId() {
	   $select = $this->getAdapter()->select()
		->from(
			array('c' => 'category'),
			array(
				'id'
			)
		)
		->where('c.name=?', RCMS_Object_QuickConfig_QuickConfig::$draftCategoryName);
		return $this->getAdapter()->fetchOne($select);
   }

    public function selectAllVariables()
    {
        $select = $this->_adapter->select()->from($this->_variableTableName, array('name'=>'name') );
        return $this->_adapter->fetchAll($select);
    }

    public function selectAllForms()
    {
        $select = $this->getAdapter()->select()->from($this->_formsTableName,array('id','name'));
        return $this->_adapter->fetchPairs($select);

    }

	 public function selectPagesIdsAndNavigationName()
    {
        $select = $this->getAdapter()->select()->from($this->_pageTableName,array('id','nav_name'))->where("url <> 'no-category'");
        return $this->_adapter->fetchPairs($select);
    }

	/**
	 * @method Select all categories
	 * @param string $parentId
	 */
	public function selectAllCategories($parentId=0) {
		$select = $this->getAdapter()->select()->from($this->_categoryTableNAme,array('id','name'))->where('id_parent=?', $parentId)->where('name != "no category"')->where('name != ?', RCMS_Object_QuickConfig_QuickConfig::$draftCategoryName);
		$result = $this->getAdapter()->fetchPairs($select);
		return $result;
	}


	public function select404PageId(){
		$select = $this->getAdapter()->select()->from($this->_pageTableName)->where('is_404page != 0');
		$result = $this->getAdapter()->fetchAll($select);
		return $result;
	}

    public function selectGroups()
    {
        $sql = $this->_adapter->select()->from($this->_shoppingGroup);
        return $this->_adapter->fetchAll($sql);
    }

    public function selectBrands()
    {
        $sql = $this->_adapter->select()->from($this->_shoppingProducts, 'brand')->where("brand <> ''")->distinct();
        return $this->_adapter->fetchAll($sql);
    }

    public function selectProductsForGroup($groupId)
    {
        $sql = $this->getAdapter()->select()->from(array('pg' => $this->_shoppingProductsGroups), array())
                ->join(array('p' => $this->_shoppingProducts), 'p.id = id_product', array('id','name','item_id','photo','brand'))
                ->where("id_group = ?", $groupId);
        return $this->_adapter->fetchAll($sql);
    }

    public function selectBrandByName($name)
    {
        $sql = $this->_adapter->select()->from($this->_shoppingProducts, array('id','name','item_id','photo','brand'))
                ->where("brand <> '' AND brand = ?", $name)->distinct();
        return $this->_adapter->fetchAll($sql);
    }
}

