<?php

/**
 * Description of PageModel
 *
 * @author Pavel Savchuk
 */
class Default_Model_ConfigModel extends RCMS_Core_BaseModel {

    protected $_configTableName = 'config';
    protected $_userTableName = 'user';
    protected $_roleTableName = 'role';


    /**
     * @method Select all categories(parentId has to be 0)
     * @param string $parentId
     */
    public function selectAll() {
        $select = $this->getAdapter()->select()->from($this->_configTableName);
        $result = $this->_adapter->fetchPairs($select);
        return $result;
    }

     public function selectSuperAdmin() {
        $select = $this->getAdapter()->select()
        ->from(
            array('u' => $this->_userTableName),
            array('userId'=>'id')
        )
        ->joinLeft(
            array('r' => $this->_roleTableName),
                'u.role_id=r.id',
                array('roleName'=>'r.name')
        )
        ->where('r.name="superadmin"')->limit(1);
        return $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_ASSOC);
    }

   

  public function selectUserLogin($login)
    {
        $where = sprintf(" login = '%s'", $login);
        $select = $this->getAdapter()->select()->from($this->_userTableName)->where($where);
        $result = $this->_adapter->fetchRow($select);
        return $result;
    }

    public function updateConfigVariableByName($name,$value)
    {
        $array = array(
           'value' => $value
        );
        $where =  sprintf(" name = '%s'", $name);
        $result = $this->getAdapter()->update($this->_configTableName, $array,$where);
        return $result;
    }

        public function selectUserRole($userId)
    {
        $select = $this->getAdapter()->select()
        ->from(
            array('u' => $this->_userTableName),
            array('userId'=>'id')
        )
        ->joinLeft(
            array('r' => $this->_roleTableName),
                'u.role_id=r.id',
                array('roleName'=>'r.name')
        )
        ->where('u.id= ? ',$userId)->where('r.name = "superadmin"')->limit(1);
        return $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_ASSOC);
    }

}

