<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of ApiserverModel
 *
 * @author NE
 */

class Default_Model_ApiserverModel extends RCMS_Core_BaseModel {
	
	public function getWebsitePages($id = 0) {
		$sitePages = array();
		$select = $this->getAdapter()->select()
			->from(
				array('p' => 'page'),
				array(
					'categoryId' => 'category_id',
					'navigationTitle' => 'nav_name',
					'url',
					'description' => 'short_description',
					'metaDescription' => 'meta_description',
					'metaKeyWords' => 'meta_keywords',
					'headerTitle' => 'header_title',
					'is404Page' => 'is_404page',
					'useBestPracticies' => 'bestpractices',
					'showInMenu' => 'show_in_menu',
					'order',
					'staticOrder' => 'static_order',
					'h1',
					'id',
					'ruleId' => 'seosamba_rule_id',
					'targetedKeyPhrase' => 'targeted_key_phrase'
				)
			)
			->joinLeft(
				array('c' => 'category'),
				'p.category_id=c.id',
				array(
					'categoryName' => 'name',
					'parentCatId' => 'id_parent'
				)
			)
			->where('c.id_parent=?', $id);
		$pages =  $this->_adapter->fetchAll($select, null, Zend_Db::FETCH_ASSOC);
		foreach($pages as $page) {
			$selectRawContent = $this->getAdapter()->select()
				->from(
					array('cnt' => 'content'),
					array(
						'value'
					)
				)
				->where(
					'id_container IN(?)',
					$this->getAdapter()->select()
						->from(
							array('ct' => 'container'),
							'id'
						)
						->where('page_id=?', $page['id'])
				);
			$page['rawContent'] = $this->getAdapter()->fetchAll($selectRawContent, null, Zend_Db::FETCH_COLUMN);
			$page['rawContent'] = join("\n", $page['rawContent']);
			$sitePages[] = $page;
		}
		return $sitePages;
	}

	public function getDeeplinks() {
		$select = $this->getAdapter()->select()
			->from(
				array('d' => 'deeplink'),
				array(
					'name',
					'url',
					'type',
					'ban',
					'nofollow',
					'extWebsiteId' => 'ext_ws_id'
				)
			);
		return $this->getAdapter()->fetchAll($select, null, Zend_Db::FETCH_ASSOC);
	}

	public function getPageIdByDeeplinkUrl($url) {
		$select = $this->getAdapter()->select()
        ->from(
            array('p' => 'page'),
            array(
                    'id',
            )
        )
        ->where('p.url=?', $url);
		$result = $this->getAdapter()->fetchOne($select, null, Zend_Db::FETCH_ASSOC);
		if($result) {
			return $result;
		}
		return 0;
	}
}

