<?php
class Default_Model_AjaxModel extends RCMS_Core_BaseModel {

    protected $_configTableName = 'config';
    protected $_pageTableName = 'page';
    protected $_commentTableName = 'comment';
    protected $_variableTableName = 'variable_content';
    protected $_deeplinkTableName = 'deeplink';
    protected $_renamedTableName = 'renamed_pages';
    protected $_thesaurusTable = 'thesaurus_en';
	protected $_userTable = 'user';
	protected $_passwordRecoveringTable = 'password_recovering';



    /**
     * @method Select configuration
     * @return Array
     */
    public function selectConfigForImage()
    {
        $select = $this->_adapter->select('name, value')->from($this->_configTableName)->where('name IN("img_small","img_medium","img_large")');        
        return $this->_adapter->fetchAssoc($select);
    }

    /**
     * @method Select all pages
     * @return Array
     */
    public function selectAllPages()
    {
        $select = $this->_adapter->select()->from($this->_pageTableName);
        return $this->_adapter->fetchAll($select);
    }

	/**
     * @method Select payment button by name
     * @return Array
     */
    public function selectConfigForVideo()
    {
        $select = $this->_adapter->select('name, value')->from('config')->where('name IN("video_width","video_height")');
        return $this->_adapter->fetchAssoc($select);
    }

	/**
     * @method Select payment button by name
	 * @param String $name
     * @return Integer
     */
    public function selectIfExistPaymentButtonByName($name)
    {
        $where = sprintf("name = '%s'", $name);
        $select = $this->_adapter->select()->from($this->_variableTableName, "COUNT(*)")->where($where);
        return $this->_adapter->fetchOne($select);
    }

	/**
     * @method Inserts payment button
	 * @param String $name
	 * @param String $content
     * @return Integer
     */
    public function insertPaymentButton($name, $content)
    {
        $data = array('name' => $name, 'value' => $content);
        return $this->_adapter->insert($this->_variableTableName, $data);
    }

	/**
     * @method Selects all variables
     * @return Array
     */
    public function selectAllVariables()
    {
        $select = $this->_adapter->select()->from($this->_variableTableName);
        return $this->_adapter->fetchAll($select);
    }

	/**
     * @method Selects content for payment button by name
	 * @param String $name
     * @return Array
     */
    public function selectContentPaymentButtonByName($name)
    {
        $where = sprintf("name = '%s'", $name);
        $select = $this->_adapter->select()->from($this->_variableTableName,array('value'=>'value'))->where($where);
        return $this->_adapter->fetchAll($select);
    }

	/**
     * @method Updates payment button
	 * @param String $name
	 * @param String $content
     * @return Integer
     */
    public function updatePaymentButton($name, $content)
    {
        $where = sprintf("name = '%s'", $name);
        return $this->_adapter->update($this->_variableTableName, array('value' => $content), $where);
    }

/**
     * @method Select comments to notify
	 * @param Integer $containerId
     * @return Array
     */
    public function selectCommentsToNotify($containerId)
    {
        $select = $this->getAdapter()->select()->from('comment')->where('container_id = ?',$containerId)->where('notify=1');
        return  $this->getAdapter()->fetchAll($select, null, Zend_Db::FETCH_ASSOC);
    }

	/**
     * @method Selects admin email
     * @return Array
     */
    public function selectAdminEmail()
    {
        $select = $this->getAdapter()->select()->from('config')->where('name = ?', 'admin_email');
        return  $this->getAdapter()->fetchPairs($select);
    }

/**
     * @method select existed topic and keyword in comments
	 * @param String $topic
	 * @param String $keyword
     * @return Integer
     */
    public function selectIfExistTopicAndKeyword($topic, $keyword)
    {
        $where = sprintf("topic = '%s' AND keyword = '%s'", $topic, $keyword);
        $select = $this->_adapter->select()->from($this->_commentTableName, "COUNT(*)")->where($where);
        return $this->_adapter->fetchOne($select);
    }


/**
     * @method Inserts redirect
	 * @param String $oldUrl
	 * @param String $originalOldUrl
     * @param RCMS_Object_Page_Page $pageObj
     * @return Integer
     */
      public function insertRedirect($oldUrl,$originalOldUrl,RCMS_Object_Page_Page $pageObj)
    {
        $data = array(
             'id_page'=>$pageObj->getId(),
             'url'=>$oldUrl,
             'new_url'=>urldecode($pageObj->getUrl()),
             'original_old_url'=>$originalOldUrl
        );
        
        return $this->getAdapter()->insert($this->_renamedTableName, $data);
    }


	/**
     * @method Checks existed redirect
	 * @param String $oldUrl
     * @return Array
     */
   public function checkExistedRedirect($oldUrl)
   {
       $select = $this->getAdapter()->select()->from($this->_renamedTableName)->where("original_old_url = ?",$oldUrl);
       $result = $this->getAdapter()->fetchRow($select);
       return $result;
   }


	/**
     * @method Deletes redirect
	 * @param Integer $pageId
     * @return Array
     */
   public function deleteRedirect($pageId)
   {
        $where = sprintf("id_page = %d", $pageId);
        return $this->_adapter->delete($this->_renamedTableName, $where);
   }

	/**
     * @method Select additional varriables names
     * @return Array
     */
	public function getAdditionalVarriablesNames() {
		$select = $this->getAdapter()->select()
			->from(
				array('vc' => 'variable_content'),
				array(
					'name'
				)
			);
		return $this->getAdapter()->fetchAll($select, null, Zend_Db::FETCH_NUM);
	}

/**
     * @method Select page by url
     * @param String $name
     * @return Array
     */
    public function getPageByUrl($url) {
		$select = $this->getAdapter()->select()->from($this->_pageTableName)->where('url = ?',$url);
            return $this->getAdapter()->fetchRow($select);
	}

    
    /**
     * @method Select deeplink  by deeplink name
     * @param String $name
     * @return Integer
     */
    public function selectDeeplinkByName($name)
    {
        $where = sprintf("name = '%s'", $name);
        $select = $this->_adapter->select()->from($this->_deeplinkTableName,"COUNT(*)")
        ->where($where);
        return $this->_adapter->fetchOne($select);
    }

    /**
     * @method Select all config settings
     * @return Array
     */
    public function selectAllConfigSettings() {
        $select = $this->getAdapter()->select()->from($this->_configTableName);
        $result = $this->_adapter->fetchPairs($select);
        return $result;
    }

	 public function selectPlugin($pluginName){
        $select = $this->getAdapter()->select()->from('plugin')->where('name =?',$pluginName);
        return $this->getAdapter()->fetchRow($select);
    }

    public function selectUserEmail($email,$one=false){
        $select = $this->getAdapter()->select()->from($this->_userTable)->where('email = ?',$email)->limit(1);
		if(!$one){
			return $this->getAdapter()->fetchAssoc($select);
		}else{
			return $this->getAdapter()->fetchOne($select);
		}
    }

	  public function insertPasswordRecovering($link){
        $data = array('link' => $link, 'time' => time());
        return $this->_adapter->insert($this->_passwordRecoveringTable, $data);
    }

	 public function selectPasswordRecovering($link){
        $select = $this->getAdapter()->select()->from($this->_passwordRecoveringTable)->where('link = ?',$link)->limit(1);
        return $this->getAdapter()->fetchAssoc($select);
    }

	public function deletePasswordRecoveringLink($link){
       $where = sprintf("link = %s", $link);
       return $this->_adapter->delete($this->_passwordRecoveringTable, $where);
	}

	public function deleteAllOldLinks(){
	   $currentTime = time();
	   $where = sprintf(" %s - `time` >86400", $currentTime);
       return $this->_adapter->delete($this->_passwordRecoveringTable, $where);
	}


}

