<?php

/**
 * RobotsController responsible for work with robots scripts
 *
 * @author Pavel Savchuk
 */
class Backend_RobotsController extends RCMS_Core_BaseController {

    private $_robotsPath = '';

    public function init() {
        parent::init();
        parent::checkLogin();
        $this->_model = new Default_Model_RobotsModel();
        $this->_robotsPath = $this->_config->website->website->path . 'public/robots.txt';
    }

    /**
     * Edit current robots script for current theme
     *
     */
    public function editrobotsAction() {
        $websiteUrl = unserialize(Zend_Registry::get('config'))->website->website->url;
        $this->_helper->getHelper('layout')->disableLayout();

        $form = new RCMS_Form_EditrobotsForm();
        $this->view->form = $form;

        try {
            $robotsFileContent = RCMS_Tools_FilesystemTools::getFile($this->_robotsPath);
            $form->getElement('content')->setValue($robotsFileContent);
        }
        catch (Exception $e) {
            $this->view->errorMessage = $e->getMessage();
        }

        if($this->getRequest()->isPost()) {
            if($this->view->form->isValid($this->getRequest()->getParams())) {
                $robotsFormData = $this->view->form->getValues();
                $editedRobotsContent = $robotsFormData['content'];
             if(file_put_contents($this->_robotsPath, $editedRobotsContent))
                    {
                        $this->view->successMessage = 'Robots.txt file saved!';
                    }else
                    {
                        $this->view->errorMessage = "Problem was occured while saving Robots.txt";
                    }
            
            }
        }
		$content = $this->_translator->processScreen($this->view->render($this->getViewScript()));
		$this->_helper->viewRenderer->setNoRender(true);
		echo $content;
    }
}

