<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of PrsculptingController
 *
 * @author NE
 */
class Backend_PrsculptingController extends RCMS_Core_BaseController {


    public function init() {
		$this->_model = new Default_Model_PrsculptingModel();
		parent::init();
		parent::checkLogin();
		$this->_cache->clean('all');
    }

    public function indexAction() {
		$this->_helper->layout->disableLayout();
		$form = new RCMS_Form_SiloForm();
		$form->getElement('websiteUrl')->setValue($this->getWebSiteUrl());
		$form->setDecorators(array(
			array('ViewScript', array('viewScript' => 'forms/prsculpting.phtml'))
		));

		$cmsPages = $this->_model->getPages();
		foreach($cmsPages as $key => $category) {
				$cmsPages[$key]['pages'] = $this->_model->getPages($category['categoryId']);
			}
		$silos = $this->_model->selectSilos();
		$this->view->websiteUrl = $this->getWebSiteUrl();
		$this->view->form = $form;
		$this->view->pages = $cmsPages;
		$this->view->silos = $silos;
		$content = $this->_translator->processScreen($this->view->render($this->getViewScript()));
		$this->_helper->viewRenderer->setNoRender(true);
		echo $content;
    }


    public function savesiloAction() {
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender(true);
		if($this->getRequest()->isPost()) {
			$siloName = RCMS_Tools_Tools::stripSlashesIfQuotesOn(trim($this->getRequest()->getParam('name')));
			$asCat = $this->getRequest()->getParam('asCat');
			if(empty($siloName)) {
				echo json_encode(array('error' => 'empty', 'data' => ''));
				exit;
			}
			if(strlen($siloName) < 3) {
				echo json_encode(array('error' => 'toshort', 'data' => ''));
				exit;
			}
			if(strlen($siloName) > 255) {
				echo json_encode(array('error' => 'tolong', 'data' => ''));
				exit;
			}
			if($this->_siloExists($siloName)) {
				if(isset($asCat)) {
					$updSilo = new RCMS_Object_Silo_Silo();
					$updSilo->loadByName($siloName);
					$updSilo->setAsCat('1');
					$updSilo->save();
				}
				echo json_encode(array('error' => 'exists', 'data' => ''));
				exit;
			}

			if(!preg_match('/^[\w0-9-\s\p{L}\p{M}\p{P}]+$/u', $siloName)) {
				echo json_encode(array('error' => 'forbid', 'data' => ''));
				exit;
			}
			$silo = new RCMS_Object_Silo_Silo();
			$silo->setName($siloName);
			if(isset($asCat)) {
				$silo->setAsCat('1');
			}
			$newSiloId = $silo->save();
			echo json_encode(array('error' => 0, 'data' => $newSiloId, 'additional' => $this->_model->selectSilos()));
			exit;
		}
    }


    public function removeascatAction() {
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender(true);
		if($this->getRequest()->isPost()) {
			$siloName = RCMS_Tools_Tools::stripSlashesIfQuotesOn(htmlentities(trim($this->getRequest()->getParam('name'))));
			$result = $this->_model->removeAsCat($siloName);
			echo $result;
			exit;
		}
    }


    private function _siloExists($siloName) {
		$siloId = $this->_model->selectSiloIdByName($siloName);
		return (empty($siloId)) ? false : true;
    }

    public function saveprsculptingAction() {
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender(true);

		if($this->getRequest()->isPost()) {
			$toPrSculpting = $this->getRequest()->getParam('toPrSculpt');
			foreach ($toPrSculpting as $pageId => $value) {
				//if(isset ($value['on']) && $value['on'] == 'on') {
				$page = new RCMS_Object_Page_Page($pageId);
				//$page->setUrl(urldecode($page->getUrl()));
				$page->setSiloId(($value['silo'] == -1) ? 0 : $value['silo']);
				$page->setWeight($value['weight']);
				$page->save();
				//}
			}
			$seoParser = new RCMS_Object_Parser_SeoParser();
			$seoParser->syncPRSFile();
		}
		echo "<script>top.location.reload();</script>";
    }

	/**
	 * Get list of all silos (AJAX calling in prsculpting.js)
	 * 
	 */
	public function getsiloslistAction() {
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender(true);
		$silos = $this->_model->selectSilos();
		if(!empty ($silos) && is_array($silos)) {
			echo json_encode(array('error' => 0, 'data' => $silos));
		}
		else {
			echo json_encode(array('error' => 1, 'data' => 'No silos'));
		}
		exit;
	}

	/**
	 * Remove silo by id (AJAX calling in prsculpting.js)
	 *
	 */
	public function removesiloAction() {
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender(true);
		$siloId = intval($this->getRequest()->getParam('siloId'));
		$silo = new RCMS_Object_Silo_Silo($siloId);
		$result = $silo->delete();
		$silos = $this->_model->selectSilos();
		if($result) {
			$this->_removeDependencies($siloId);
			echo json_encode(array('error' => 0, 'msg' => 'Silo removed', 'data' => $silos));
		}
		else {
			echo json_encode(array('error' => 1, 'msg' => 'Can not remove silo', 'data' => ''));
		}
	}

	private function _removeDependencies($siloId) {
		return $this->_model->removeDependencies($siloId);
	}
}