<?php

/**
 *Form Controller
 *
 * @author Pavel Savchuk
 */
class Backend_FormController extends RCMS_Core_BaseController {

    public function init() {
        parent::init();
        parent::checkLogin();
        $this->_model = new Default_Model_FormModel();
    }

    public function indexAction()
    {
        $this->_helper->getHelper('layout')->disableLayout();
        $this->_helper->viewRenderer->setNoRender(true);
    }


  /**
   * @method  adds new form
   * @return void
   */
    public function addformAction() {
        $this->_helper->getHelper('layout')->disableLayout();
        $form = new RCMS_Form_FormsForm();

        $form->setDecorators(array(
                array('ViewScript', array('viewScript' => 'forms/addform.phtml'))
            ));
        $name = $this->getRequest()->getParam('name');
        $pageId = $this->getRequest()->getParam('pageId');
        if(isset($pageId) && $pageId>0)
        {
            $pageObj = new RCMS_Object_Page_Page($pageId);
            $form->getElement('pageUrl')->setValue($pageObj->getUrl());
        }

        $adminEmail = $this->_model->selectAdminEmail();
        $form->getElement('name')->setValue($name);
        $form->getElement('email')->setValue($adminEmail['admin_email']);
        $form->getElement('emailFrom')->setValue($adminEmail['admin_email']);

        if(empty ($name))
        {
            throw new Exception('Form name is not setted!');
        }

        $this->view->form = $form;
        $this->view->name = $name;

        if($this->getRequest()->isPost()) {
            if($this->view->form->isValid($this->getRequest()->getParams())) {
                $formObj = new RCMS_Object_Form_Form();

                $name= htmlspecialchars($this->getRequest()->getParam('name'));
                $useSMTP = $this->getRequest()->getParam('useSmtp');
                $code=$this->getRequest()->getParam('code');
                $email = htmlspecialchars($this->getRequest()->getParam('email'));
                $successMessage = htmlspecialchars($this->getRequest()->getParam('successMessage'));
                $errorMessage = htmlspecialchars($this->getRequest()->getParam('errorMessage'));
                $emailFrom = htmlspecialchars($this->getRequest()->getParam('emailFrom'));
                $emailMessage = htmlspecialchars($this->getRequest()->getParam('emailMessage'));
                $pageUrl = $this->getRequest()->getParam('pageUrl');

                $formObj->setName((isset($name))? $name : "error");
                $formObj->setUseSMTP((isset($useSMTP))? $useSMTP :0);
                $formObj->setCode((isset($code))? $code : "");
                $formObj->setEmail((isset($email))? $email : "");
                $formObj->setSuccessMessage((isset($successMessage))? $successMessage : "");
                $formObj->setErrorMessage((isset($errorMessage))? $errorMessage :"");
                $formObj->setEmailFrom((isset($emailFrom))? $emailFrom : "");
                $formObj->setEmailMessage((isset($emailMessage))? $emailMessage :"");

                $flag = $formObj->save();
                if($flag)
                {
                    $this->view->redirect = $this->getWebSiteUrl().$pageUrl.".html";
                }
            }else
            {
               $this->view->errorElements = $this->processErrors($this->view->form->getMessages());
            }
        }
		$content = $this->_translator->processScreen($this->view->render($this->getViewScript()));
		$this->_helper->viewRenderer->setNoRender(true);
		echo $content;
    }

  /**
   * @method  fiils form with existed data
   *@param <RCMS_Object_Form_Form> $formObj
   * @return void
   */
    public function fillForm(RCMS_Object_Form_Form $formObj)
    {
        $form = new RCMS_Form_FormsForm();
        $form->setDecorators(array(
                array('ViewScript', array('viewScript' => 'forms/editform.phtml'))
            ));
        $form->getElement('id')->setValue($formObj->getId());
        $form->getElement('name')->setValue($formObj->getName());
        $form->getElement('code')->setValue($formObj->getCode());
        $form->getElement('email')->setValue($formObj->getEmail());
        $form->getElement('emailFrom')->setValue($formObj->getEmailFrom());
        $form->getElement('useSmtp')->setValue($formObj->getUseSMTP());
        $form->getElement('emailMessage')->setValue($formObj->getEmailMessage());
        $form->getElement('successMessage')->setValue($formObj->getSuccessMessage());
        $form->getElement('errorMessage')->setValue($formObj->getErrorMessage());
        return $form;
    }

  /**
   * @method  edits form
   *
   * @return void
   */
    public function editformAction() {
        $this->_helper->getHelper('layout')->disableLayout();

        $formId = $this->getRequest()->getParam('formId');
        $pageId = $this->getRequest()->getParam('pageId');
        $this->view->pageId = $pageId;
        $this->view->formId = $formId;

        if($formId>0 && $pageId>0)
        {
            $formObj = new RCMS_Object_Form_Form($formId);
            $pageObj = new RCMS_Object_Page_Page($pageId);
            $form = $this->fillForm($formObj);
            $this->view->form = $form;
            $this->view->name= $formObj->getName();

            $form->getElement('pageUrl')->setValue($pageObj->getUrl());

            if($this->getRequest()->isPost()) {
                if($this->view->form->isValid($this->getRequest()->getParams())) {
                    $name= htmlspecialchars($this->getRequest()->getParam('name'));
                    $useSMTP = $this->getRequest()->getParam('useSmtp');
                    $code=$this->getRequest()->getParam('code');
                    $email = htmlspecialchars($this->getRequest()->getParam('email'));
                    $successMessage = htmlspecialchars($this->getRequest()->getParam('successMessage'));
                    $errorMessage = htmlspecialchars($this->getRequest()->getParam('errorMessage'));
                    $emailFrom = htmlspecialchars($this->getRequest()->getParam('emailFrom'));
                    $emailMessage = htmlspecialchars($this->getRequest()->getParam('emailMessage'));
                    $pageUrl = $this->getRequest()->getParam('pageUrl');

                    $formObj->setName((isset($name))? $name : "error");
                    $formObj->setUseSMTP((isset($useSMTP))? $useSMTP :0);
                    $formObj->setCode((isset($code))? $code : "");
                    $formObj->setEmail((isset($email))? $email : "");
                    $formObj->setSuccessMessage((isset($successMessage))? $successMessage : "");
                    $formObj->setErrorMessage((isset($errorMessage))? $errorMessage :"");
                    $formObj->setEmailFrom((isset($emailFrom))? $emailFrom : "");
                    $formObj->setEmailMessage((isset($emailMessage))? $emailMessage :"");

                    $flag = $formObj->save();
                    $this->view->redirect = $this->getWebSiteUrl().$pageUrl.".html";
                }
                else
                {
                     $this->view->errorElements = $this->processErrors($this->view->form->getMessages());
                }
            }

        }else
        {
            throw new Exception('Form Id or Page Id were not setted!');
        }
		$content = $this->_translator->processScreen($this->view->render($this->getViewScript()));
		$this->_helper->viewRenderer->setNoRender(true);
		echo $content;
    }

  /**
   * @method  deletes form
   *
   * @return void
   */
    public function deleteformAction()
    {
        $this->_helper->getHelper('layout')->disableLayout();
        $this->_helper->viewRenderer->setNoRender(true);

        $formId = $this->getRequest()->getParam('formId');
        $pageId = $this->getRequest()->getParam('pageId');

        

        if($formId>0 && $pageId>0)
        {
            $formObj = new RCMS_Object_Form_Form($formId);
            $pageObj = new RCMS_Object_Page_Page($pageId);
            if($formObj->delete())
            $this->_redirect($this->getWebSiteUrl()."".$pageObj->getUrl().".html");
        }else
        {
            throw new Exception(" Page Id or Form Id was not set!");
        }
    }

 public function processErrors($array)
    {
        $messages = array();
        $htmlUl = "";
       
        foreach ($array as $key => $value)
        {
            switch ($key)
            {
                case 'code':
                    if(isset($value['isEmpty']))
                    $messages[]="Content field can't be empty.";
                    if(isset($value['stringLengthTooShort']))
                    $messages[]="Content field can't less than 3 characters.";
                    break;

                case 'email':
                    if(isset($value['isEmpty']))
                    $messages[]="Mail To can't be empty.";
                    if(isset($value['regexNotMatch']))
                    $messages[]="Mail To is not valid.";
                    if(isset($value['stringLengthTooShort']))
                    $messages[]="Mail To field can't less than 3 characters.";
                     if(isset($value['stringLengthTooLong']))
                    $messages[]="Mail To field can't more than 255 characters.";
                    break;

                case 'emailFrom':
                    if(isset($value['isEmpty']))
                    $messages[]="Email From field can't be empty.";
                    if(isset($value['regexNotMatch']))
                   $messages[]="Email From is not valid.";
                    if(isset($value['stringLengthTooShort']))
                    $messages[]="Email From field can't less than 3 characters.";
                     if(isset($value['stringLengthTooLong']))
                    $messages[]="Email From field can't more than 255 characters.";
                    break;

                case 'successMessage':
                    if(isset($value['isEmpty']))
                    $messages[]="Success Message field can't be empty.";
                    if(isset($value['stringLengthTooShort']))
                    $messages[]="Success Message field can't be less than 3 characters.";
                    if(isset($value['stringLengthTooLong']))
                    $messages[]="Success Message field can't be more than 1800 characters.";
                    break;

                case 'errorMessage':
                    if(isset($value['isEmpty']))
                    $messages[]="Error Message field can't be empty.";
                    if(isset($value['stringLengthTooShort']))
                    $messages[]="Error Message field can't be less than 3 characters.";
                    if(isset($value['stringLengthTooLong']))
                    $messages[]="Error Message field can't be more than 1800 characters.";
                    break;

                case 'emailMessage':
                    if(isset($value['stringLengthTooShort']))
                    $messages[]="Email Message field can't be less than 3 characters.";
                    if(isset($value['stringLengthTooLong']))
                    $messages[]="Email Message field can't be more than 3800 characters.";
                    break;
            }
        }

        if(!empty($messages))
        {
            $htmlUl = "<ul>";
            foreach ($messages as $message)
            {
                $htmlUl .= "<li>".$message."</li>";
            }
            $htmlUl .= "<ul>";
            return $htmlUl;
        }
        return null;
    }


}

