<?php
/**
 * Controller manage featured area controller.
 *
 * @author Pavel Savchuk
 */
class Backend_FeaturedareaController extends RCMS_Core_BaseController {

    public $websiteUrl;
    
    public function init()
    {
        $this->_model = new Default_Model_FeaturedareaModel();
        parent::init();
        parent::checkLogin();
		$this->websiteUrl= unserialize(Zend_Registry::get('config'))->website->website->url;
    }

    public function indexAction()
    {
        $this->_helper->viewRenderer->setNoRender(true);
        $this->_helper->layout->disableLayout();
    }

    /**
     * This function is editing featured area
     * @return <void>
     */
    public function managefaAction()
    {
        //$this->_helper->getHelper('layout')->disableLayout();
        $websiteUrl = unserialize(Zend_Registry::get('config'))->website->website->url;
        $featuredAreasArray =  $this->_model->selectAllFeaturedAreas();
        $this->_helper->getHelper('layout')->disableLayout();
        $form = new RCMS_Form_FeaturedAreaForm();
        $form->getElement('website_url')->setValue($websiteUrl);
        $form->setDecorators(array(
                array('ViewScript', array('viewScript' => 'forms/managefeaturedarea.phtml'))
            ));

        /* $name = trim(strip_tags($this->getRequest()->getParam('name')));
         $url = trim(strip_tags($this->getRequest()->getParam('url')));*/

        $this->view->form = $form;
        $this->view->featuredAreasArray = $featuredAreasArray;
		$content = $this->_translator->processScreen($this->view->render($this->getViewScript()));
		$this->_helper->viewRenderer->setNoRender(true);
		echo $content;
    }

/**
 * @method adds new featured area
 * @return void
 */
    public function addfaAction()
    {
        $this->_helper->getHelper('layout')->disableLayout();
        $this->_helper->viewRenderer->setNoRender(true);

        if($this->getRequest()->isPost() && $this->getRequest()->getParam('featured_name') != '')
        {
            $name = trim(strip_tags($this->getRequest()->getParam('featured_name')));
            $id = $this->_model->inserFeaturedArea($name);
            if($id)
            {
            $featuredArea = new RCMS_Object_FeaturedArea_FeaturedArea($id);
            $html = '<tr id="featuredarea_'.$featuredArea->getId().'">';
            $html .= '<td class="new"  align="left" style="width:260px;font-weight:bold;text-indent:10px;">';
            $html .= $featuredArea->getName();
            $html .= '</td>';
            $html .= '<td class="new" align="left" style="width:80px;text-indent:10px;">';
            $html .= 0;
            $html .= '</td>';
            $html .= '<td class="new"  align="left" style="width:80px;text-align:center;">';
            $html .= '<input type="checkbox" name="facheck-';
            $html .= $featuredArea->getId();
            $html .= '" id="facheck-';
            $html .= $featuredArea->getId();
            $html .= '" value="';
            $html .= $featuredArea->getId();
            $html .= '" onclick="selectFeaturedArea(\'';
            $html .= $featuredArea->getId();
            $html .='\',this.checked);" />';
            $html .= '</td>';
            $html .= '<td class="new"  align="left" style="width:80px;text-align:center;">';
            $html .= '<img style="cursor:pointer;" alt="ico-delete" title="Delete this featured area." src="';
            $html .= $this->websiteUrl;
            $html .= 'system/images/ico_delete.gif" onclick="deletefeaturedarea(\'';
            $html .= $this->websiteUrl;
            $html .= '\', \'';
            $html .= $featuredArea->getId();
            $html .= '\');"/>';
            $html .= '</td>';
            $html .= '</tr>';
            echo $html;
            }else
            {
                echo "error";
            }
        }

    }

/**
 * @method check if featured area exists
 * @return string
 */
    public function isfaAction()
    {
         
        $this->_helper->getHelper('layout')->disableLayout();
        $this->_helper->viewRenderer->setNoRender(true);

        if($this->getRequest()->isPost() && $this->getRequest()->getParam('name') != '')
        {
            $name = trim(strip_tags($this->getRequest()->getParam('name')));
            if(!empty ($name))
            {
              if($this->_model->selectFeaturedAreaByName($name))
                {
                    echo "yes";
                }else
                {
                    echo "no";
                }
            }
        }
    }

/**
 * @method deletes featured area
 * @return void
 */
public function deletefaAction()
    {

        $this->_helper->getHelper('layout')->disableLayout();
        $this->_helper->viewRenderer->setNoRender(true);

        if($this->getRequest()->isPost() && $this->getRequest()->getParam('id') != '')
        {
            $id = (int)$this->getRequest()->getParam('id');
            if($id>0)
            {
              $featuredAreaObj = new RCMS_Object_FeaturedArea_FeaturedArea($id);
              $featuredAreaObj->delete();
            }
        }
    }

}
