<?php
/**
 * Controller manage deeplinks screen.
 *
 * @author Pavel Savchuk
 */
class Backend_DeeplinkController extends RCMS_Core_BaseController {

    public function init() {
        $this->_model = new Default_Model_DeeplinkModel();
        parent::init();
        parent::checkLogin();
		$this->_cache->clean('all');
    }

    public function indexAction() {
        $this->_helper->viewRenderer->setNoRender(true);
        $this->_helper->layout->disableLayout();
    }


    public function managedeeplinksAction() {
        $this->_helper->getHelper('layout')->disableLayout();
        $form = new RCMS_Form_DeeplinkForm();
        $form->setDecorators(array(
            array('ViewScript', array('viewScript' => 'forms/managedeeplinks.phtml'))
        ));
        $form->selectpage->setMultiOptions($this->_getAllPagesForSelectPageElement());
        $this->view->deeplinks = $this->_model->selectAllDeeplinks();
        $this->view->websiteUrl = $this->getWebSiteUrl();
        $this->view->form = $form;
		$content = $this->_translator->processScreen($this->view->render($this->getViewScript()));
		$this->_helper->viewRenderer->setNoRender(true);
		echo $content;
    }



    /**
     * This function is get all pages (ajax)
     * @return <void>
     */
    public function getallpagesforcurrentwebsiteAction() {
        $this->_helper->getHelper('layout')->disableLayout();
        $this->_helper->viewRenderer->setNoRender(true);

        if($this->getRequest()->isPost() && $this->getRequest()->getParam('id') != '') {
            $id = intval($this->getRequest()->getParam('id'));

            if($id === 0) {
                $listPages = $this->_model->selectAllPages();
                echo json_encode($listPages);
            }
            else {

            }
        }
    }

    /**
     * This function is validating name and url
     * @param <string> $name
     * @param <string> $url
     * @return <array>
     */
    private function _validateDeeplink($name, $url) {
        if($name === '') {
            return array('error'=>true,'message'=>'Please enter field "Anchor Text"');
        }
        if($url === '') {
            return array('error'=>true,'message'=>'Please enter field "URL"');
        }

        if(!preg_match("/^[a-zA-Z-'\s]{1,255}$/", $name)) {
            return array('error'=>true,'message'=>'Field "Anchor Text" must contain only letters');
        }

        if(!preg_match("/^.{2,255}$/", $name)) {
            return array('error'=>true,'message'=>'Field "Anchor Text" must contain at least 2 letters');
        }

        if (!preg_match('/^(http|https):\/\/[a-zA-Z0-9-.\/]{2,210}$/', $url)) {
            return array('error'=>true,'message'=>'Select page for this anchor');
        }

        return array();
    }

 /**
     * This function gets all pages for page element
     * @return <array>
     */
    private function _getAllPagesForSelectPageElement() {
		$draftCategoryId = $this->_model->selectDraftCategoryId();
        $listPages = $this->_model->selectAllPages();
        if(!empty($listPages) && is_array($listPages)) {
            $selectListPages = array('' => 'select page');
            foreach ($listPages as $key => $page) {
				if($draftCategoryId) {
					if($page['parentCategoryId'] == $draftCategoryId) {
						unset($listPages[$key]);
						continue;
					}
				}
                $selectListPages[$this->_config->website->website->url . urldecode($page['url']) . '.html'] = $page['nav_name'] ;
            }
            return $selectListPages;
        }
        else {
            return array();
        }
    }
}
