<?php

/**
 * CssController responsible for work with css scripts
 *
 * @author Eugene I. Nezhuta
 */
class Backend_CssController extends RCMS_Core_BaseController {

	private $_currThemePath = '';

	public function init() 
	{
		parent::init();
        parent::checkLogin();
		$this->_model = new Default_Model_CssModel();
		$this->_currThemePath = $this->_config->website->website->path . 'public/themes/'. $this->_session->currentThemeName;
    }

	/**
	 * Edit current css script for current theme.
	 * @return <void> 
	 */
	public function editcssAction() 
	{
		$this->_cache->clean('all');
        $this->_helper->getHelper('layout')->disableLayout();
		$websiteUrl = $this->_config->website->website->url;
        $pageId = $this->getRequest()->getParam('pageId');
        
        if($pageId > 0){
            $pageObj = new RCMS_Object_Page_Page($pageId);
            $pageUrl = $websiteUrl.$pageObj->getUrl().".html";
            $this->view->pageUrl = $pageUrl;
        }else
		{
			$configArray = $this->_model->selectAllFromConfig();
			if($configArray['default_news_folder']){
			$this->view->pageUrl = $websiteUrl.$configArray['default_news_folder']."/";
			}else
			{
				$this->view->pageUrl = $websiteUrl."news/";
			}
		}
		

                
        $form = new RCMS_Form_EditcssForm();
		$this->view->form = $form;
		$cssFiles = $this->_findCssFilesForOptions();		
		$cssFilePath = $this->_currThemePath . '/' . $cssFiles[0];
        try {
            $cssFileContent = RCMS_Tools_FilesystemTools::getFile($cssFilePath);
            $form->getElement('content')->setValue($cssFileContent);
			$form->getElement('selectcss')->setMultiOptions($cssFiles);
			$form->getElement('selectcss')->setValue(0);
        }
        catch (Exception $e){
            $this->view->errorMessage = $e->getMessage();
        }
        if($this->getRequest()->isPost()){
            if($this->view->form->isValid($this->getRequest()->getParams())){				
				$cssFormData = $this->view->form->getValues();
                $editedCssContent = $cssFormData['content'];
				$cssFilePath = $this->_currThemePath . '/' . $cssFiles[$cssFormData['selectcss']];
                try {
                    RCMS_Tools_FilesystemTools::saveFile($cssFilePath, $editedCssContent);
                    $this->view->successMessage = 'Css file saved!';
                }
                catch (Exception $e) {
                    $this->view->errorMessage = $e->getMessage();
                }
            }
        }
		$content = $this->_translator->processScreen($this->view->render($this->getViewScript()));
		$this->_helper->viewRenderer->setNoRender(true);
		echo $content;
    }
	
    /**
     * This function returns array of css files for current theme.
     * @return <array>
     */
	private function _findCssFilesForOptions() 
	{
		$cssFiles = RCMS_Tools_FilesystemTools::findFilesByExt($this->_currThemePath, 'css');
		if(!empty ($cssFiles) && $cssFiles !== 'false') {
			return array_reverse($cssFiles);
		}
		return array( 0 => 'no css found');
	}
	
	/**
	 * This function loads content for css file (ajax).
	 * @return <void>
	 */
	public function changecssAction() 
	{
		$this->_helper->getHelper('layout')->disableLayout();
        $this->_helper->viewRenderer->setNoRender(true);
		$cssFileName = $this->getRequest()->getParam('cssFileName');
		$cssFileContent = RCMS_Tools_FilesystemTools::getFile($this->_currThemePath . '/' . $cssFileName);
		echo json_encode($cssFileContent);
	}
}
