<?php
class RCMS_Tools_Tools {

    /**
     * This function did resize image. Type image: gif,png,jpg.
	 * 
     * @param <string> $file
     * @param <int> $width
     * @param <int> $height
     * @return <boolean>  true|false
     */
    static public function resizeImage($file, $width, $height, $proportion = true, $fullQuality=false)
    {
        $file = (string) trim($file);
        $width = (integer) $width;
        $height = (integer) $height;
        $proportion = (boolean) $proportion;
		$quality = RCMS_Object_QuickConfig_QuickConfig::$imageQuality;
		/*if($fullQuality){
			$quality = 100;
		}*/

        if($file === '' && $width === 0 && $height === 0)
        {
            return false;
        }

        if(file_exists($file))
        {
            $nameFile = basename($file);
            $dirFile = dirname($file);

            $array = explode('.', $nameFile);
            $typeFile = $array[count($array)-1];

            switch ($typeFile) {
                case 'jpg':
                    $image = imagecreatefromjpeg($file);
                    break;
                case 'png':
                    $image = imagecreatefrompng($file);
                    break;
                case 'gif':
                    $image = imagecreatefromgif($file);
                    break;
                default:
                    return false;
            }

            $x = imagesx($image);
            $y = imagesy($image);

            if($proportion === true)
            {
                $getX_Y = self::calcProportion($x, $y, $width);
                $width = $getX_Y['width'];
                $height = $getX_Y['height'];
            }

            $newImage = imagecreatetruecolor($width, $height);
           imagecopyresampled($newImage, $image, 0, 0, 0, 0, $width, $height, $x, $y);
			//imagecopyresized($newImage, $image, 0, 0, 0, 0, $width, $height, $x, $y);
              switch ($typeFile) {
                case 'jpg':
					header("Content-Type: image/jpg");
					imagejpeg($newImage, $file, $quality);
					break;
                case 'png':
					header("Content-Type: image/png");
                    imagepng($newImage, $file, $quality);
                    break;
                case 'gif':
					header("Content-Type: image/gif");
                    imagegif($newImage, $file);
                    break;
                default:
                    return false;
            }
            
            imagedestroy($newImage);
            return true;
        }
        else
            return false;
    }

    static public function calcProportion($imgWidth, $imgHeight, $newWidthSize)
    {
        $proportion = array();
		$propPercents = ceil(($imgHeight / $imgWidth) * 100);
		$proportion['width'] = $newWidthSize;
		$proportion['height'] = ceil(($newWidthSize / 100 ) * $propPercents);
		return $proportion;
	}

    static public function cropImage($nw, $nh, $source,$dest) {
		$size = getimagesize($source);
		$w = $size[0];
		$h = $size[1];
		switch($size['mime']) {
			case 'image/gif':
				$simg = imagecreatefromgif($source);
			break;
			case 'image/jpeg':
				$simg = imagecreatefromjpeg($source);
			break;
			case 'image/png':
				$simg = imagecreatefrompng($source);
			break;
		}
		$dimg = imagecreatetruecolor($nw, $nh);
		$wm = $w/$nw;
		$hm = $h/$nh;
		$h_height = $nh/2;
		$w_height = $nw/2;
		if($w> $h) {
			$adjusted_width = $w / $hm;
			$half_width = $adjusted_width / 2;
			$int_width = $half_width - $w_height;
			imagecopyresampled($dimg,$simg,-$int_width,0,0,0,$adjusted_width,$nh,$w,$h);
		}
		elseif(($w <$h) || ($w == $h)) {
			$adjusted_height = $h / $wm;
			$half_height = $adjusted_height / 2;
			$int_height = $half_height - $h_height;
			imagecopyresampled($dimg,$simg,0,-$int_height,0,0,$nw,$adjusted_height,$w,$h);
		}
		else {
			imagecopyresampled($dimg,$simg,0,0,0,0,$nw,$nh,$w,$h);
		}
		imagejpeg($dimg,$dest,RCMS_Object_QuickConfig_QuickConfig::$imageQuality);
       // imagejpeg($dimg,100);
	}

    /**
 * This function generates todays date
 * @return <date>
 */
    public static function generateTodaysDateComments()
    {
        return date("F j, Y g:i a");
    }
/**
 * This function generates date to sql format
 * @return <date>
 */
    public static function proccessDateToSqlComments($date)
    {
        $dateArray = explode("-", trim($date));
        $date = date("Y-m-d", mktime(0, 0, 0, $dateArray[0], $dateArray[1],$dateArray[2]));
        return $date;
    }
/**
 * This function generates date from sql format
 * @return <date>
 */
    public static function proccessPublishingDateCommentsFromSql($date)
    {
            $tmpDateArray  = explode(" ",trim($date));
            $dateArray = explode("-", $tmpDateArray[0]);
            $timeArray = explode(":",$tmpDateArray[1]);
            $date = date("F j, Y g:i a", mktime($timeArray[0], $timeArray[1], $timeArray[2],  $dateArray[1],$dateArray[2],$dateArray[0]));
            return $date;
    }

    public static function divideStringOnParts($string,$length=50)
    {
     /*   $result ="";
        $partsCount = (int)(strlen($string)/$length);
        for($i=0;$i<$partsCount+1;$i++)
        {
			$result .= substr($string,($i*$length),$i+$length).'<br/>';
			//$result .= substr($string,($i*$length),$i+$length)." ";
            
        }
        $end = sizeof($result)-6;
        $result = substr($result, 0,$end);
        return $result;*/
		return $string;
    }
    
	/**
	 * Remove slashes from give value
	 *
	 * @param mixed $value
	 * @return mixed value without slashes
	 */
	public static function stripSlashesIfQuotesOn($value) {
		if(get_magic_quotes_gpc()) {
			return (is_array($value)) ? array_map('self::stripSlashesIfQuotesOn', $value) : stripslashes($value);
		}
		return $value;
	}

}
