<?php

/**
 * UserModel model for User object
 *
 * @author eugene
 */
class RCMS_Object_User_UserModel extends RCMS_Core_BaseModel {
	
	protected $_name = 'user';

	public function selectUserDataById($id)
    {
		$select = $this->_adapter->select()->from($this->_name)->where('id=?', $id);
		$result = $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_OBJ);
		return $result;
	}

    public function deleteUser($id)
    {
        $where = sprintf("id = %d", $id);
        return $this->_adapter->delete('user', $where);
    }

    public function insertUser(RCMS_Object_User_User $user)
    {
        $data = array (
            'role_id'			=> $user->getRoleId(),
            'id_user_seosamba'	=> $user->getIdSeosambaUser(),
            'login'             => $user->getLogin(),
            'password'          => $user->getPassword(),
            'email'             => $user->getEmail(),
            'status'            => $user->getStatus(),
            'nickname'          => $user->getNickName(),
            'last_login'        => $user->getLastLogin(),
            'ipaddress'         => $user->getIpAddress(),
            'reg_date'          => $user->getRegDate()
		);
		$this->_adapter->insert('user', $data);
		return $this->_adapter->lastInsertId('user');
    }

    public function updateUser(RCMS_Object_User_User $user)
    {
        $data = array (
            'role_id'			=> $user->getRoleId(),
            'id_user_seosamba'	=> $user->getIdSeosambaUser(),
            'login'             => $user->getLogin(),
            'password'          => $user->getPassword(),
            'email'             => $user->getEmail(),
            'status'            => $user->getStatus(),
            'nickname'          => $user->getNickName(),
            'last_login'        => ($user->getLastLogin()) ? $user->getLastLogin() : null,
            'ipaddress'         => $user->getIpAddress(),
            'reg_date'          => $user->getRegDate()
		);
		$where = sprintf("id = %d", $user->getId());
		return $this->_adapter->update('user', $data, $where);
    }
}
