<?php

/**
 * User class defines User object.
 *
 * @author eugene
 */
class RCMS_Object_User_User extends RCMS_Core_BaseObject {

	const USER_ROLE_ADMIN = 1;

	const USER_ROLE_USER = 2;

    const USER_ROLE_SUPERADMIN = 3;

    protected $_model;

    private $_roleId;

    private $_idUserSeosamba;

    private $_login;

    private $_password;

    private $_email;

    private $_status;

    private $_nickName;

    private $_lastLogin;

    private $_ipAddress;

	private $_regDate;
	
	/**
	 * Constructor.
	 * Here we should specify object's model and other initial information that we may need
	 */
	public function  __construct($userId = false) {
		$this->_model = new RCMS_Object_User_UserModel();
		if($userId) {
			$userData = $this->_model->selectUserDataById($userId);
			if(!empty ($userData)) {
				$this->setId($userData->id);
				$this->setRoleId($userData->role_id);
				$this->setIdSeosambaUser($userData->id_user_seosamba);
				$this->setLogin($userData->login);
				$this->setEmail($userData->email);
				$this->setStatus($userData->status);
				$this->setNickName($userData->nickname);
				$this->setIpAddress($userData->ipaddress);
				$this->setRegDate($userData->reg_date);
				$this->setPassword($userData->password);
				$this->setLastLogin($userData->last_login);
			}
		}
	}
	
	/*
	 * Returns value of user's roleId
	 * @return integer
	 */
    public function getRoleId()
    {
        return $this->_roleId;
    }

	/**
	 * Update the user method.
	 * @return boolean
	 */
	protected function _update()
    {
        $flag = $this->_model->updateUser($this);
		if($flag > 0)
            return true;
		 return false;
	}

	/**
	 * Insert the uset method.
	 * @return boolean	
	 */
	protected function _insert()
    {
        $id = $this->_model->insertUser($this);
		if($id !== false)
		{
			$this->setId($id);
			return true;
		}
		return false;
	}

	/**
	 * Sets value of user's roleId
	 * @param integer $_roleId
	 * @return void
	 */
    public function setRoleId($_roleId)
    {
        $this->_roleId = $_roleId;
    }

	/*
	 * Returns value of user's seosamba Id.
	 * @return integer
	 */
    public function getIdSeosambaUser()
    {
        return $this->_idUserSeosamba;
    }

	/*
	 * Sets value of user's seosamba user Id.
	 * @param integer $_idUserSeosamba
	 * @return void
	 */
    public function setIdSeosambaUser($_idUserSeosamba)
    {
        $this->_idUserSeosamba = $_idUserSeosamba;
    }

	/*
	 * Gets User's Login name.
	 * @return string
	 */
    public function getLogin()
    {
        return trim($this->_login);
    }

	/*
	 * Sets value of user's login.
	 * @param string $_login
	 * @return void
	 */
    public function setLogin($_login)
    {
        $this->_login = trim($_login);
    }

	/*
	 * Returns user's password.
	 * @return string
	 */
    public function getPassword()
    {
        return trim($this->_password);
    }

	/*
	 * Sets value of user's password.
	 * @param string  $_password
	 * @return void
	 */
    public function setPassword($_password)
    {
        $this->_password = trim($_password);
    }

	/*
	 * Returns value of user's email.
	 * @return string
	 */
    public function getEmail()
    {
        return trim($this->_email);
    }

	/*
	 * Sets value of user's email.
	 * @param string  $_email
	 * @return void
	 */
    public function setEmail($_email)
    {
        $this->_email = trim($_email);
    }

	/*
	 * Returns user's status.
	 * @return string
	 */
    public function getStatus()
    {
        return trim($this->_status);
    }

	/*
	 * Sets value of user's status.
	 * @param string  $_status
	 * @return void
	 */
    public function setStatus($_status)
    {
        $this->_status = trim($_status);
    }

	/*
	 * Returns a value of user's nickName.
	 * @return string
	 */
    public function getNickName()
    {
        return trim($this->_nickName);
    }

	  /*
	 * Sets a value of user's nickName.
	 * @param string  $_nickName
	 * @return void
	 */
    public function setNickName($_nickName)
    {
        $this->_nickName = trim($_nickName);
    }

	/*
	 * Return user's lastLoginDate.
	 * @return string (date)
	 */
    public function getLastLogin()
    {
        return trim($this->_lastLogin);
    }
    
	/*
	 * Sets value of user's lsatLoginDate.
	 * @param date $_lastLogin
	 * @return void
	 */
    public function setLastLogin($_lastLogin)
    {
        $this->_lastLogin = trim($_lastLogin);
    }

	/*
	 * Returns users's IpAddress.
	 * @return string
	 */
    public function getIpAddress()
    {
        return trim($this->_ipAddress);
    }

	/*
	 * Sets value of user's Ip Address.
	 * @param date $_ipAddress
	 * @return void
	 */
    public function setIpAddress($_ipAddress)
    {
        $this->_ipAddress = trim($_ipAddress);
    }

	/*
	 * Returns a value of user's registration date
	 * @return date
	 */
    public function getRegDate()
    {
        return trim($this->_regDate);
    }

	/*
	 * Sets value of user's registration date.
	 * @param date $_regDate
	 * return void
	 */
    public function setRegDate($_regDate)
    {
        $this->_regDate = trim($_regDate);
    }
	
    /**
     * Deletes the user.
     * @see app/core/RCMS_Core_BaseObject#delete()
     */
	public function delete()
    {
        return $this->_model->deleteUser($this->getId());
	}
	
	/**
	 * This function checks if user is admin.   
	 * @return bollean
	 */
	public function isAdmin() {
		return (bool)$this->getRoleId() == self::USER_ROLE_ADMIN;
	}
}

