<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of UpdaterModel
 *
 * @author NE
 */
class RCMS_Object_Updater_UpdaterModel extends RCMS_Core_BaseModel {

	public function cleanDeeplinks() {
		return $this->getAdapter()->delete('deeplink');
	}

	public function cleanNews() {
		$this->getAdapter()->delete('news');
		$this->getAdapter()->delete('newscategory');
	}

	public function cleanVars() {
		$this->getAdapter()->delete('variable_content');
	}

	public function saveNewsCategory($name) {
		$data = array(
			'name' => $name
        );
        $this->getAdapter()->insert('newscategory', $data);
        return $this->getAdapter()->lastInsertId('newscategory');
	}

	public function saveNewsFolder($newsFolderName) {
		$data = array(
			'value' => $newsFolderName
		);
		$where = sprintf("name='default_news_folder'");
		return $this->getAdapter()->update('config', $data, $where);
	}

	/**
	 * Save variable's attributes to the database
	 *
	 * @param string $name variable name
	 * @param string $value variable code
	 * @return integer
	 */
	public function saveVariables($name, $value) {
		$data  = array(
			'name'  => $name,
			'value' => $value
		);
		return $this->getAdapter()->insert('variable_content', $data);
	}

	public function cleanSeoData() {
		$this->getAdapter()->delete('seo_data');
	}

	public function saveSeoData($top, $bottom, $id) {
		$data = array(
			'seo_top' => $top,
			'seo_bottom' => $bottom,
			'page_id' => $id
		);
		return $this->getAdapter()->insert('seo_data', $data);
	}

	public function updateServicesContent($servicesContent) {
		$this->getAdapter()->delete('whitelabel_services');
		$data = array(
			'services_content' => $servicesContent
		);
		return $this->getAdapter()->insert('whitelabel_services', $data);
	}

	public function checkCategory($categoryName) {
		$select = $this->getAdapter()->select()
			->from(
				array('c' => 'category'),
				array(
					'id'
				)
			)
			->where('name=?', $categoryName)
			->where('id_parent=\'0\'');
		return $this->getAdapter()->fetchRow($select);
	}

	public function insertCategory($categoryName, $parentId = 0) {
		$data = array(
			'id_parent' => $parentId,
			'name' => $categoryName
		);
		$this->getAdapter()->insert('category', $data);
		return $this->getAdapter()->lastInsertId('category');
	}

	public function getTemplateIdByName($templateName) {
		$select = $this->getAdapter()->select()
			->from(
				array('t' => 'template'),
				array(
					'id'
				)
			)
			->where('name=?', $templateName);
		$result = $this->getAdapter()->fetchRow($select);
		return $result['id'];
	}

	public function cleanCategories($parentId) {
		$where = sprintf("id_parent=%d", $parentId);
		return $this->getAdapter()->delete('category', $where);
	}

	public function getCategoryPagesIds($catId) {
		$select = $this->getAdapter()->select()
			->from(
				array('p' => 'page'),
				array(
					'id'
				)
			)
			->join(
				array('c' => 'category'),
				'p.category_id = c.id'
			)
			->where('c.id_parent = ?', $catId);
		return $this->getAdapter()->fetchCol($select);
	}

	public function cleanGrubbedPages($idsSet) {
		$where = sprintf("id IN (%s)", $idsSet);
		return $this->getAdapter()->delete('page', $where);
	}

	public function cleanGrubbed301s($idsSet) {
		$where = sprintf("id_page IN (%s)", $idsSet);
		return $this->getAdapter()->delete('renamed_pages', $where);
	}

	public function cleanImportedCategory($catId) {
		$catWhere = sprintf("id = %d", $catId);
		$pageWhere = sprintf("category_id = %d", $catId);
		$this->getAdapter()->delete('page', $pageWhere);
		$this->getAdapter()->delete('category', $catWhere);
	}

	public function getDeeplinksIds() {
		$select = $this->getAdapter()->select()
			->from(
				array('dlc' => 'deeplink_content'),
				'deeplink_id'
			);
		return $this->getAdapter()->fetchCol($select);
	}

	public function updateLanguage($languageName) {
		$data = array(
			'value' => strtolower($languageName)
		);
		 $where = " name  = 'translate_language' ";
		return $this->getAdapter()->update('config', $data, $where);
	}

	public function selectUrl($url) {
		$select = $this->getAdapter()->select()
			->from(
				array('p' => 'page'),
				'id'
			)
			->where('p.url = ?', $url);
		return $this->getAdapter()->fetchOne($select);
	}

	public function selectDeeplinkByName($deeplinkName) {
		$select = $this->getAdapter()->select()
			->from(
				array('dl' => 'deeplink'),
				'name'
			)
			->where('dl.name=?', $deeplinkName);
		return $this->getAdapter()->fetchOne($select);
	}
}

