<?php

class RCMS_Object_Template_Template  extends RCMS_Core_BaseObject {

	/**
	 * template of name 
	 * @var string
	 */	
	private $_name;
	
	/**
	 * template of content
	 * @var string
	 */
	private $_content;
	
	/**
	 * the name image for preview template
	 * @var string
	 */
	private $_preview_path;
	
	/**
	 * the name theme for template
	 * @var string
	 */
	private $_theme_name;
	
	/**
	 * object's model for template	  
	 * @var object (RCMS_Object_Template_TemplateModel)
	 */
	protected $model;
	
	/**
	 * Constructor. 
	 * @param integer $id
	 * @return void
	 */
	public function __construct($id = null)
	{	
		$this->model = new RCMS_Object_Template_TemplateModel();			
		if($id !== null){
			$this->init(intval($id));
		}				
	}
	
	/**
	 *  This function returns name of template.  
	 * @return string
	 */
	public function getName()
	{
		return $this->_name;
	}
	
	/**
	 * This function sets name for template.
	 * @param string $name
	 * @return void
	 */
	public function setName($name)
	{
		$this->_name = (string) trim($name);
	}
	
	/**
	 *  This function returns content of template. 
	 * @return string
	 */
	public function getContent()
	{
		return $this->_content;
	}
	
	/**
	 *  This function sets content for template. 
	 * @param string $content
	 * @return void
	 */
	public function setContent($content)
	{
		$this->_content = (string) trim($content);		
	}
	
	/**
	 * This function returns preview image of template.
	 * @return string
	 */
	public function getPreviewImage()
	{
		return $this->_preview_path;
	}
	
	/**
	 *  This function sets preview image for template.
	 * @param string $image
	 * @return void
	 */
	public function setPreviewImage($image)
	{
		$image = (string) $image;
		$this->_preview_path = $image;
	}
	
	/**
	 * This function returns theme name of template.
	 * @return string
	 */
	public function getTheme()
	{
		return $this->_theme_name;
	}
	
	/**
	 * This function sets theme name for template.
	 * @param string $theme
	 * @return void
	 */
	public function setTheme($theme)
	{
		$theme = (string) $theme;
		$this->_theme_name = $theme;
	}
	
	/**
	 * Initialization.
	 * @param integer $id
	 * @return void
	 */
	protected function init($id)
	{
		$id = (integer) $id;
		
		if($id > 0)
		{
			$dataObject = $this->model->selectTemplateById($id);
			
			if($dataObject !== false && is_object($dataObject))
			{
				$this->setId($dataObject->id);
				$this->setName($dataObject->name);
				$this->setContent($dataObject->content);
				$this->setPreviewImage($dataObject->preview_path);
				$this->setTheme($dataObject->theme_name);
			}			
		}
	}
 	
	/**
	 * Insert new template into the database.
	 * @see app/core/RCMS_Core_BaseObject#_insert()
	 */
	protected function _insert()
	{
		$id = $this->model->insertTemplate($this);
		
		if($id !== false)
		{
			$this->setId($id);
			return true;
		}		
		return false;		
	}
	
	/**
	 * Update template.
	 * @see app/core/RCMS_Core_BaseObject#_update()
	 */
	protected function _update()
	{
		 $flag = $this->model->updateTemplate($this);
		 
		 if($flag > 0)
		 	return true;
		 return false;		
	}
	
	/**
	 * Delete template.
	 * @see app/core/RCMS_Core_BaseObject#delete()
	 */
	public function delete()
	{	
		$flag = $this->model->deleteTemplate($this->getId());
		
		if($flag > 0)
			return true;
		return false;	
	}

	/**
	 * This function returns object by name of template. 
	 * @param string $templateName
	 * @return object
	 */
    public function getTemplateByName($templateName)
    {
        if(!empty ($templateName))
        {
           $result =  $this->model->selectTemplateByName($templateName);
           if($result)
           {
               return $result;
           }else
           {
               return null;
           }
        }
    }
}
