<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of SiloModel
 *
 * @author NE
 */
class RCMS_Object_Silo_SiloModel extends RCMS_Core_BaseModel {

	public function selectSiloById($id) {
		$select = $this->getAdapter()->select()
			->from(
				array('s' => 'silo'),
				array(
					'name',
					'asCat' => 'as_cat'
				)
			)
			->where('id=?', $id);
		return $this->getAdapter()->fetchOne($select);
	}

	public function selectSiloByName($name) {
	    $where = sprintf("name='%s'", $name);
	    $select = $this->getAdapter()->select()
		->from(
		    array('s' => 'silo'),
		    array(
		    	'id',
			'asCat' => 'as_cat'
		    )
		)
		->where($where);
	    return $this->getAdapter()->fetchAll($select);
	}

	public function selectRelatedPages($id) {
		$select = $this->getAdapter()->select()
			->from(
				array('p' => 'page'),
				array(
					'id',
					'url',
				)
			)
			->where('silo_id=?', $id);
		return $this->getAdapter()->fetchPairs($select);
	}

	public function insertSilo(RCMS_Object_Silo_Silo $silo) {
		$data = array (
			'name' => $silo->getName(),
			'as_cat' => $silo->getAsCat()
		);
		$this->_adapter->insert('silo', $data);
		return $this->_adapter->lastInsertId('silo');
	}

	public function updateSilo(RCMS_Object_Silo_Silo $silo) {
	    $data = array (
		'name' => $silo->getName(),
		'as_cat' => $silo->getAsCat()
	    );
	    $where = sprintf("id=%d", $silo->getId());
	    $this->_adapter->update('silo', $data, $where);
	}

	public function deleteSilo($id) {
		return $this->getAdapter()->delete('silo', 'id=' . $id);
	}
}

