<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Silo
 *
 * @author NE
 */
class RCMS_Object_Silo_Silo extends RCMS_Core_BaseObject {

	/**
	 * Silo's name
	 *
	 * @var string
	 */
	protected $_name = '';

	/**
	 * Flag for silo a category name sign
	 *
	 * @var integer
	 */
	protected $_asCat = 0;

	public function  __construct($id = 0) {
		$this->_model = new RCMS_Object_Silo_SiloModel();
		if($id) {
			$siloData = $this->_model->selectSiloById($id);
			if(!empty ($siloData)) {
				$this->_name = $siloData['name'];
				$this->_id = $id;
				$this->_asCat = $siloData['asCat'];
			}
		}
	}
	public function getAsCat() {
	    return $this->_asCat;
	}

	public function setAsCat($asCat) {
	    $this->_asCat = $asCat;
	}

	public function loadByName($name) {
	    $siloData = $this->_model->selectSiloByName($name);
	    if(!empty ($siloData)) {
			foreach ($siloData as $data) {
				$this->_name = $name;
				$this->_id = $data['id'];
				$this->_asCat = $data['asCat'];
			}
	    }
	}

	public function getRelatedPagesIds() {
		//@todo implement this method if need
	}

	public function getRelatedPagesUrls() {
		//@todo implement this method if need
	}

	public function getRelatedPages() {
		$relatedPages = array();
		$relatedPages = $this->_model->selectRelatedPages($this->_id);
		return $relatedPages;
	}

	public function setName($name) {
		$this->_name = trim($name);
	}

	public function getName() {
		return $this->_name;
	}

	protected function _insert() {
		return $this->_model->insertSilo($this);
	}

	protected function _update() {
		return $this->_model->updateSilo($this);
	}

	public function delete() {
		return $this->_model->deleteSilo($this->_id);
	}
}

