<?php

class RCMS_Object_Product_Product  extends RCMS_Core_BaseObject {

    private $_name = '';

    private $_itemId = '';

    private $_price = 0;

    private $_photo = '';

    private $_brand = '';

    private $_desc = '';

    private $_pageId = 0;

    private $_options = '';

    private $_related = '';
    
    public function  __construct($id = null)
    {
        $this->_model = new RCMS_Object_Product_ProductModel();
        if ($id !== null) {
            $this->_init($id);
        }
    }

    private function _init($id)
    {
        $data = $this->_model->selectProductById($id);
        if (is_array($data) && count($data) > 0) {
            $this->setId($id);
            $this->setName($data['name']);
            $this->setItemId($data['item_id']);
            $this->setPrice($data['price']);
            $this->setPhoto($data['photo']);
            $this->setBrand($data['brand']);
            $this->setDescription($data['desc']);
            $this->setOptions($data['options']);
            $this->setRelated($data['related']);
            $this->setPageId($data['page_id']);
        }
    }

    public function setName($name)
    {
        $this->_name = $name;
    }

    public function getName()
    {
        return  $this->_name;
    }

    public function setItemId($itemId)
    {
        $this->_itemId = $itemId;
    }

    public function getItemId()
    {
        return $this->_itemId;
    }

    public function setPrice($price)
    {
        $this->_price = $price;
    }

    public function getPrice()
    {
        return $this->_price;
    }

    public function setPhoto($photo)
    {
        $this->_photo = $photo;
    }

    public function getPhoto()
    {
        return $this->_photo;
    }

    public function getBrand()
    {
        return $this->_brand;
    }

    public function setBrand($brand)
    {
        $this->_brand = $brand;
    }

    public function setRelated($related)
    {
        $this->_related = $related;
    }

    public function getRelated()
    {
        return $this->_related;
    }

    public function getPageId()
    {
        return $this->_pageId;
    }

    public function setPageId($pageId)
    {
        $this->_pageId = $pageId;
    }

    public function getOptions()
    {
        return $this->_options;
    }

    public function setOptions($options)
    {
        $this->_options = $options;
    }

    public function getDescription()
    {
        return $this->_desc;
    }

    public function setDescription($desc)
    {
        $this->_desc = $desc;
    }

    public function getGroups()
    {
        if ($this->_id) {
            return $this->_model->selectGroupsForProduct($this->_id);
        }
    }

    public function setGroups($groups)
    {
        if ($this->_id && is_array($groups) && count($groups) > 0) {
            $this->_model->deleteGroupForProduct($this->_id);
            foreach ($groups as $idGroup) {
                $this->_model->insertGroupForProduct($this->_id, $idGroup);
            }
        }
    }

    protected function _insert()
    {
        return $this->_model->insertProduct($this);
    }

    protected function _update()
    {
        return $this->_model->updateProduct($this);
    }

    public function delete()
    {
        $flagDelete = $this->_model->deleteProduct($this->_id);
        if ($flagDelete) {
            $this->_model->deleteGroupForProduct($this->_id);
        }
        return $flagDelete;
    }
}
