<?php
/**
 * PluginModel Object
 * @author Pavel Savchuk
 */
class RCMS_Object_Plugin_PluginModel extends RCMS_Core_BaseModel {

	/**
	 * The name of table in the database.
	 * @var string
	 */
	protected $table = 'plugin';

	/**
	 * This function selects data by id.
	 * @param integer $id
	 * @return object
	 */
	public function selectPluginById($id)
	{
		$select = $this->_adapter->select()->from($this->table)->where('id = ?', $id);
		return $select->query()->fetchObject();
	}


	/**
	 * Insert new plugin into the database.
	 * @param object RCMS_Object_Plugin_Plugin $plugin
	 * @return integer
	 */
	public function insertPlugin(RCMS_Object_Plugin_Plugin $plugin)
	{
		$data = array (
			'name'	  => $plugin->getName(),
			'status'  => $plugin->getStatus(),
			'cache'   =>$plugin->getCache()
		);

		$this->_adapter->insert($this->table, $data);
		return $this->_adapter->lastInsertId($this->table);
	}

	/**
	 * Update the plugin.
	 * @param object RCMS_Object_Plugin_Plugin $plugin
	 * @return integer
	 */
	public function updatePlugin(RCMS_Object_Plugin_Plugin $plugin)
	{
		$data = array (
			'name'	  => $plugin->getName(),
			'status'  => $plugin->getStatus(),
			'cache'   =>$plugin->getCache()
		);

		$where =  sprintf("id = %d", $plugin->getId());

		return $this->_adapter->update($this->table, $data, $where);
	}

	/**
	 * Deletes the plugin.
	 * @param integer $id
	 * @return integer
	 */
	public function deletePlugin($id)
	{
		$where = sprintf("id = %d", $id);
		return $this->_adapter->delete($this->table, $where);
	}
}
