<?php
/**
 * Plugin Object
 * @author Pavel Savchuk
 */
class RCMS_Object_Plugin_Plugin  extends RCMS_Core_BaseObject {

	/**
	 * plugin name
	 * @var string
	 */
	private $_name;

	/**
	 * plugin status
	 * @var string
	 */
	private $_status;

	private $_cache;

	/**
	 * object's model for template
	 * @var object (RCMS_Object_Template_TemplateModel)
	 */
	protected $_model;

	/**
	 * Constructor.
	 * @param integer $id
	 * @return void
	 */
	public function __construct($id = null)
	{
		$this->_model = new RCMS_Object_Plugin_PluginModel();
		if($id !== null){
			$this->init(intval($id));
		}
	}

	/**
	 *  This function returns name of plugin.
	 * @return string
	 */
	public function getName()
	{
		return $this->_name;
	}

	/**
	 * This function sets name for plugin.
	 * @param string $name
	 * @return void
	 */
	public function setName($name)
	{
		$this->_name = (string) trim($name);
	}

	/**
	 *  This function returns status of plugin.
	 * @return string
	 */
	public function getStatus()
	{
		return $this->_status;
	}

	/**
	 *  This function sets status for plugin
	 * @param string $status
	 * @return void
	 */
	public function setStatus($status)
	{
		$this->_status = (string) trim($status);
	}


	public function getCache()
	{
		return $this->_cache;
	}

	public function setCache($cache)
	{
		$this->_cache = intval($cache);
	}

	/**
	 * Initialization.
	 * @param integer $id
	 * @return void
	 */
	protected function init($id)
	{
		$id = (integer) $id;

		if($id > 0)
		{
			$dataObject = $this->_model->selectPluginById($id);

			if($dataObject !== false && is_object($dataObject))
			{
				$this->setId($dataObject->id);
				$this->setName($dataObject->name);
				$this->setStatus($dataObject->status);
				$this->setCache($dataObject->cache);
				
			}
		}
	}

	/**
	 * Insert new plugin into the database.
	 * @see app/core/RCMS_Core_BaseObject#_insert()
	 */
	protected function _insert()
	{
		$id = $this->_model->insertPlugin($this);

		if($id !== false)
		{
			$this->setId($id);
			return true;
		}
		return false;
	}

	/**
	 * Update plugin.
	 * @see app/core/RCMS_Core_BaseObject#_update()
	 */
	protected function _update()
	{
		 $flag = $this->_model->updatePlugin($this);

		 if($flag > 0)
		 	return true;
		 return false;
	}

	/**
	 * Deletes plugin.
	 * @see app/core/RCMS_Core_BaseObject#delete()
	 */
	public function delete()
	{
		$flag = $this->_model->deletePlugin($this->getId());

		if($flag > 0)
			return true;
		return false;
	}
	
}
