<?php

/**
 * Description of Ping
 *
 * @author NE
 */
class RCMS_Object_Ping_Ping {

	const RPCS_PING_O_MATIC = 'http://rpc.pingomatic.com/';

	const RPCQ_COMMON = 'weblogUpdates.ping';

	const RPCQ_EXTENDED = 'weblogUpdates.extendedPing';

	const RPCS_WBLOGS_COM = 'http://rpc.weblogs.com/';

	protected $_xmlRpcClient = null;

	protected $_siteTitle = '';

	protected $_siteUrl = '';

	protected $_changedUrl = '';

	protected $_catOrRss = '';

	protected $_isError = false;

	protected $_message = '';

	public function  __construct($rpcServer = self::RPCS_PING_O_MATIC) {
		$this->_xmlRpcClient = new Zend_XmlRpc_Client($rpcServer);
	}

	public function ping() {
		$params = $this->_buildParams();
		$result = $this->_xmlRpcClient->call(self::RPCQ_COMMON, $params);
		if($result && is_array($result)) {
			//return example array(2) { ["flerror"]=>  bool(false) ["message"]=>  string(37) "Pings being forwarded to 13 services!" }
			$this->_isError = $result['flerror'];
			$this->_message = $result['message'];
		}
	}

	protected function _buildParams() {
		$params = array();
		if($this->_siteTitle && $this->_siteUrl && $this->_changedUrl && $this->_catOrRss) {
			$params = array($this->_siteTitle, $this->_siteUrl, $this->_changedUrl, $this->_catOrRss);
		}
		elseif($this->_siteTitle && $this->_siteUrl && $this->_changedUrl) {
			$params = array($this->_siteTitle, $this->_siteUrl, $this->_changedUrl);
		}
		elseif($this->_siteTitle && $this->_siteUrl) {
			$params = array($this->_siteTitle, $this->_siteUrl);
		}
		else {
			return false;
		}
		return $params;
	}

	public function getSiteTitle() {
		return $this->_siteTitle;
	}

	public function setSiteTitle($siteTitle) {
		$this->_siteTitle = $siteTitle;
	}

	public function getSiteUrl() {
		return $this->_siteUrl;
	}

	public function setSiteUrl($siteUrl) {
		$this->_siteUrl = $siteUrl;
	}

	public function getChangedUrl() {
		return $this->_changedUrl;
	}

	public function setChangedUrl($changedUrl) {
		$this->_changedUrl = $changedUrl;
	}

	public function getCatOrRss() {
		return $this->_catOrRss;
	}

	public function setCatOrRss($catOrRss) {
		$this->_catOrRss = $catOrRss;
	}

	public function getIsError() {
		return $this->_isError;
	}

	public function getMessage() {
		return $this->_message;
	}


}

