<?php

/**
 * Description of LanguageParserModel
 *
 * @author NE
 */
class RCMS_Object_Parser_LanguageParserModel extends RCMS_Core_BaseModel {

	protected $_lexemTableName = 'lexem';

	protected $_lexemReferenceTableName = 'lexem_has_language';

	protected $_translateLanguagesTableName = 'translate_languages';

	protected $_configTableName = 'config';
	
    public function selectAllConfigData() {
        $select = $this->getAdapter()->select()->from($this->_configTableName);
        return $this->_adapter->fetchPairs($select);
    }

	public function selectIdOfOriginalValue($originalValue) {
		$select = $this->getAdapter()->select()->from($this->_lexemTableName)->where('original_value = ?',$originalValue);
		return $this->getAdapter()->fetchOne($select);
	}

	public function insertOriginalValue($originalValue) {
		$lexemData = array('original_value'=>$originalValue);
		$this->getAdapter()->insert($this->_lexemTableName, $lexemData);
        $result = $this->getAdapter()->lastInsertId($this->_lexemTableName);
        return $result;
	}

//	public function selectLanguageId($language){
//		$select = $this->getAdapter()->select()->from($this->_translateLanguagesTableName)->where('language = ?',$language);
//		return $this->getAdapter()->fetchOne($select);
//	}

	public function selectTranslatedLexem($lexemId,$languageId){
		$select = $this->getAdapter()->select()->from($this->_lexemReferenceTableName)->where('lexem_id = ?',$lexemId)->where('language_id = ?',$languageId)->limit(1);
		return $this->getAdapter()->fetchRow($select);
	}

	public function selectOriginalValue($lexemId)
	{
		$select = $this->getAdapter()->select()->from($this->_lexemTableName)->where('id = ?',$lexemId)->limit(1);
		return $this->getAdapter()->fetchRow($select);
	}
}
