<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
class RCMS_Object_Page_PageModel extends RCMS_Core_BaseModel
{
    protected $_name = 'page';

/**
 * @method This method make a select page data by pageID
 * @param <RCMS_Object_Page_Page> $pageObj
 * @return <Integer>
 */
    public function selectPageDataById($pageId)
    {
        if($pageId>0){
            $select = $this->getAdapter()->select()->from($this->_name)->where("id = ?",$pageId)->limit(1);
            $stmt   = $this->getAdapter()->query($select);
            $result = $stmt->fetchAll();
            if($result)
            return $result;
            return null;
        }
        else
        {
            return null;
        }

    }


	public function getParentCatId($id) {
		$select = $this->getAdapter()->select()
			->from(
				array('c' => 'category'),
				array(
					'parentId' => 'id_parent',
				)
			)
			->where('c.id=?', $id);
		return $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_ASSOC);
	}

	public function selectParentCategoryName($parentCatId) {
		$select = $this->getAdapter()->select()
			->from(
				array('c' => 'category'),
				array(
					'name'
				)
			)
			->where('c.id=?', $parentCatId);
		return $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_ASSOC);
	}


/**
 * @method This method is inserting new page
 * @param <RCMS_Object_Page_Page> $pageObj
 * @return <Integer> last insert id
 */
    public function inserPage(RCMS_Object_Page_Page $pageObj)
    {
        $pageData = array(
             'h1'=>$pageObj->getH1Tag(),
             'header_title'=>$pageObj->getHeaderTitle(),
             'url'=> urlencode($pageObj->getUrl()),
             'nav_name'=>$pageObj->getNavName(),
             'meta_description'=>$pageObj->getMetaDescription(),
             'meta_keywords'=>$pageObj->getMetaKeywords(),
             'short_description'=>$pageObj->getShortDescription(), 
             'is_404page'=>$pageObj->getIs404Page(),
             'template_id'=>$pageObj->getTemplateId(),
             'category_id'=>$pageObj->getCategoryId(),
             'bestpractices'=>$pageObj->getBestPractices(),
             'date'=>$pageObj->getDate(),
             'owner'=>$pageObj->getOwner(),
             'last_update'=>$pageObj->getLastUpdate(),
             'date'=>date("Y-m-d H:i:s"),
             'show_in_menu'=>$pageObj->getShowInMenu(),
			 'order' => $pageObj->getOrder(),
			 'static_order' => $pageObj->getStaticOrder(),
             'weight' => $pageObj->getWeight(),
			 'seosamba_rule_id' => $pageObj->getSeosambaRuleId(),
			 'silo_id' => $pageObj->getSiloId(),
			 'targeted_key_phrase' => $pageObj->getTargetedKeyPhrase()
        );
        $this->getAdapter()->insert($this->_name, $pageData);
        $result = $this->getAdapter()->lastInsertId($this->_name);
        return $result;
    }
/**
 * @method This method is updating page
 * @param <RCMS_Object_Page_Page> $pageObj
 * @return <Integer>
 */
    public function updatePage(RCMS_Object_Page_Page $pageObj)
    {
      $pageData = array(
             'h1'=>$pageObj->getH1Tag(),
             'header_title'=>$pageObj->getHeaderTitle(),
             'url'=> urlencode($pageObj->getUrl()),
             'nav_name'=>$pageObj->getNavName(),
             'meta_description'=>$pageObj->getMetaDescription(),
             'meta_keywords'=>$pageObj->getMetaKeywords(),
             'short_description'=>$pageObj->getShortDescription(),
             'is_404page'=>$pageObj->getIs404Page(),
	         'template_id'=>$pageObj->getTemplateId(),
             'category_id'=>$pageObj->getCategoryId(),
             'bestpractices'=>$pageObj->getBestPractices(),
             'date'=>$pageObj->getDate(),
             'owner'=>$pageObj->getOwner(),
             'last_update'=>date("Y-m-d H:i:s"),
             'show_in_menu'=>$pageObj->getShowInMenu(),
			 'order' => $pageObj->getOrder(),
			 'static_order' => $pageObj->getStaticOrder(),
             'weight' => $pageObj->getWeight(),
			 'seosamba_rule_id' => $pageObj->getSeosambaRuleId(),
			 'silo_id' => $pageObj->getSiloId(),
			 'targeted_key_phrase' => $pageObj->getTargetedKeyPhrase()
        );
     $result = $this->getAdapter()->update($this->_name, $pageData,"id = ".$pageObj->getId());
     return $result;
     
        
    }

/**
 * @method This method delete page in the database
 * @param <RCMS_Object_Page_Page> $pageObj
 * @return <Integer>
 */
    public function deletePage($pageId)
    {
        return $this->_adapter->delete($this->_name,"id = ".$pageId);
    }

	public function setParentCategory($pageId, $parentCatId) {
		$contentData = array(
			'id_parent' => $parentCatId,
		);
		$contentWhere = sprintf("id = %d", $pageId);
		return $this->_adapter->update('category', $contentData, $contentWhere);
	}

    /**
 * @method This method is updating temnplate_id to default template
 * @param <RCMS_Object_Page_Page> $pageObj
 * @return <Integer>
 */
    public function updateToDefaultTemplate($idDeletedTemplate)
    {
        $select = $this->getAdapter()->select()->from('template',array('id'))->where('name = "default"');
        $stmt   = $this->getAdapter()->query($select);
        $result = $stmt->fetchColumn();
              
        $pageData = array(
             'template_id'=>$result
        );
     $result = $this->getAdapter()->update($this->_name, $pageData,"template_id = ".$idDeletedTemplate);
     return $result;


    }

    public function deleteImages($pageId)
    {
       return $this->getAdapter()->delete("page_image","page_id = ".$pageId);
    }

    /*** delete dependence ***/

    public function selectContainerIdsForPageByPageId($pageId)
    {
        $select = $this->_adapter->select()->from(array('c' => 'container'),array('id'))->where('c.page_id=?', $pageId);
        return $this->_adapter->fetchAll($select, null, Zend_Db::FETCH_ASSOC);
    }

	public function deleteContentByIdContainer($id)
    {
        $where = sprintf("id_container = %d", $id);
		return $this->_adapter->delete('content', $where);		
	}

    public function deleteContainerDependencies($id)
    {
		return $this->_adapter->delete('link_reference', 'id_container=' . $id);
	}

    public function deleteDeeplinksDependencies($pageUrl)
    {
		$where = sprintf("'%s'", $pageUrl);
		return $this->_adapter->delete('deeplink', 'url=' . $where);
	}

    public function deleteContainerByPageId($pageId)
    {
        $where = sprintf("page_id = %d", $pageId);
        return $this->_adapter->delete('container', $where);
	}

    public function deleteCategoryById($id)
    {
        $where = sprintf("id = %d", $id);
        return $this->_adapter->delete('category', $where);
	}
    
    public function deleteFeaturedAreasByPageId($pageId)
    {
        return  $this->_adapter->delete('page_has_fa', "page_id = ".$pageId);
	}

    public function selectCategoryById($id)
    {
        $select = $this->_adapter->select()->from('category')->where('id=?', $id);
        $result = $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_OBJ);
        return $result;
	}

    public function selectAllCategories($parentId=0)
    {
		$select = $this->_adapter->select()->from('category', array('id','name'))->where('id_parent=?', $parentId);
		$result = $this->_adapter->fetchPairs($select);
		return $result;
	}

    public function selectPageImagesByPageId($pageId)
    {
        $where = sprintf("page_id = %d", $pageId);
        $select = $this->_adapter->select()->from('page_image')->where($where);
        return $this->_adapter->fetchAll($select, null, Zend_Db::FETCH_OBJ);
	}
    
    /*** end delete dependence ***/
}

