<?php

/**
 * ContainerModel class
 *
 * @author Eugene I. Nezhuta
 */
class RCMS_Object_News_NewsModel extends RCMS_Core_BaseModel {

    private $_newsTable = "news";
    private $_categoryNewsTable = "newscategory";

	public function selectNewsById($id) {
		$select = $this->getAdapter()->select()
			->from(
				array('n' => $this->_newsTable),
				array(
					'newsId'              => 'n.id',
					'newsCategoryId'      => 'n.id_newscategory',
					'newsTitle'           => 'n.title',
					'newsUrl'             => 'n.page_url',
					'newsIntro'           => 'n.intro',
					'newsText'            => 'n.text',
					'newsDate'            => 'n.date',
					'newsOrder'           => 'n.order',
					'newsArchived'        => 'n.is_archived',
					'newsFeatured'        => 'n.is_featured',
					'newsDisableArchive'  => 'n.disable_archive',
					'newsLastUpdate'      => 'n.last_update',
					'newsMetaDescription' => 'n.news_meta_description',
					'newsMetaKeywords'    => 'n.news_meta_keywords'
				)
			)
			->joinLeft(
				array('nc' =>$this->_categoryNewsTable),
				'n.id_newscategory=nc.id',
				array(
					'newsCategoryName' => 'nc.name'
				)
			)
			->where('n.id=?', $id);
		$result = $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_OBJ);
		return $result;
	}


/**
 * @method This method is inserting news
 * @param <RCMS_Object_News_News> $newsObj
 * @return <Integer> last insert id
 */
    public function insertNews(RCMS_Object_News_News $newsObj)
    {
        $newsData = array(
             'id_newscategory'       => $newsObj->getIdNewsCategory(),
             'title'                 => $newsObj->getTitle(),
             'page_url'              => $newsObj->getNewsUrl(),
             'intro'                 => $newsObj->getIntro(),
             'text'                  => $newsObj->getText(),
             'date'                  => $newsObj->getDate(),
             'order'                 => $newsObj->getOrder(),
             'is_archived'           => $newsObj->getIsArchived(),
             'is_featured'           => $newsObj->getIsFeatured(),
             'disable_archive'       => $newsObj->getDisableArchive(),
			 'news_meta_description' => $newsObj->getMetaDescription(),
			 'news_meta_keywords'    => $newsObj->getMetaKeywords()
        );
        $this->getAdapter()->insert($this->_newsTable, $newsData);
        return $this->getAdapter()->lastInsertId($this->_newsTable);
    }
/**
 * @method This method is updating news
 * @param  RCMS_Object_News_News $newsObj
 * @return <Integer>
 */
    public function updateNews(RCMS_Object_News_News $newsObj)
    {
      $newsData = array(
             'id_newscategory'       => $newsObj->getIdNewsCategory(),
             'title'                 => $newsObj->getTitle(),
             'page_url'              => $newsObj->getNewsUrl(),
             'intro'                 => $newsObj->getIntro(),
             'text'                  => $newsObj->getText(),
             'date'                  => $newsObj->getDate(),
             'order'                 => $newsObj->getOrder(),
             'is_archived'           => $newsObj->getIsArchived(),
             'is_featured'           => $newsObj->getIsFeatured(),
             'disable_archive'       => $newsObj->getDisableArchive(),
			 'news_meta_description' => $newsObj->getMetaDescription(),
			 'news_meta_keywords'    => $newsObj->getMetaKeywords()
        );
     return $this->getAdapter()->update($this->_newsTable, $newsData,"id = ".$newsObj->getId());
    }
    
/**
 * @method This method delete page in the database
 * @param RCMS_Object_News_News $newsObj
 * @return <Integer>
 */
    public function deleteNews(RCMS_Object_News_News $newsObj)
    {
        return $this->getAdapter()->delete($this->_newsTable,"id = ".$newsObj->getId());
    }

}

