<?php
/**
 * Container class
 *
 * @author Eugene I. Nezhuta
 */
class RCMS_Object_News_News extends RCMS_Core_BaseObject {


    private $_idNewsCategory = 0;

    private $_title = '';

    private $_newsUrl = '';

    private $_intro = '';

    private $_text = '';

    private $_date = '';

    private $_order = 0;

    private $_isArchived = 0;

    private $_isFeatured = 0;

    private $_disableArchive = 0;

    private $_lastUpdate = '';

	private $_metaDescription;

	private $_metaKeywords;

    /**
     * Constructor. If containerId not eq. false, then load container from db by id
     *
     * @param integer $containerId
     */
    public function  __construct($newsId = false) {
        $this->_model = new RCMS_Object_News_NewsModel();
        if($newsId) {
            $newsData = $this->_model->selectNewsById($newsId);
            if(!is_object($newsData)) {
                throw new Exception ('News loading is falied!');
            }
            $this->setId($newsData->newsId);
            $this->setIdNewsCategory($newsData->newsCategoryId);
            $this->setTitle($newsData->newsTitle);
            $this->setNewsUrl($newsData->newsUrl);
            $this->setIntro($newsData->newsIntro);
            $this->setText($newsData->newsText);
            $this->setDate($newsData->newsDate);
            $this->setOrder($newsData->newsOrder);
            $this->setIsArchived($newsData->newsArchived);
            $this->setIsFeatured($newsData->newsFeatured);
            $this->setDisableArchive($newsData->newsDisableArchive);
            $this->setLastUpdate($newsData->newsLastUpdate);
			$this->setMetaDescription($newsData->newsMetaDescription);
			$this->setMetaKeywords($newsData->newsMetaKeywords);
        }
    }


 public function setIdNewsCategory($_idNewsCategory)
    {
        $this->_idNewsCategory = $_idNewsCategory;
    }

    public function getIdNewsCategory()
    {
        return $this->_idNewsCategory;
    }

   public function setTitle($_title)
    {
        $this->_title = $_title;
    }

    public function getTitle()
    {
        return $this->_title;
    }

    public function setNewsUrl($_newsUrl)
    {
        $this->_newsUrl = $_newsUrl;
    }

    public function getNewsUrl()
    {
        return $this->_newsUrl;
    }

    public function setIntro($_intro)
    {
        $this->_intro = $_intro;
    }

    public function getIntro()
    {
        return $this->_intro;
    }

    public function setText($_text)
    {
        $this->_text = $_text;
    }

    public function getText()
    {
        return $this->_text;
    }

    public function setDate($_date)
    {
        $this->_date = $_date;
    }

    public function getDate()
    {
        return $this->_date;
    }

    public function setOrder($_order)
    {
        $this->_order = $_order;
    }

    public function getOrder()
    {
        return $this->_order;
    }

    public function setIsArchived($_isArchived)
    {
        $this->_isArchived = $_isArchived;
    }

    public function getIsArchived()
    {
        return $this->_isArchived;
    }

    public function setIsFeatured($_isFeatured)
    {
        $this->_isFeatured = $_isFeatured;
    }

    public function getIsFeatured()
    {
        return $this->_isFeatured;
    }

    public function setDisableArchive($_disableArchive)
    {
        $this->_disableArchive = $_disableArchive;
    }

    public function getDisableArchive()
    {
        return $this->_disableArchive;
    }

    public function setLastUpdate($_lastUpdate)
    {
        $this->_lastUpdate = $_lastUpdate;
    }

    public function getLastUpdate()
    {
        return $this->_lastUpdate;
    }

	public function getMetaDescription()
	{
		return $this->_metaDescription;
	}

	public function setMetaDescription($metaDescription)
	{
		$this->_metaDescription = trim($metaDescription);
	}

	public function getMetaKeywords()
	{
		return $this->_metaKeywords;
	}

	public function setMetaKeywords($metaKeywords)
	{
		$this->_metaKeywords = trim($metaKeywords);
	}

    /**
     * Delete news item
     *
     */
    public function delete() {

    }

    /**
     * Insert news item to the database
     *
     */
    protected function _insert() {
        return $this->_model->insertNews($this);
    }

    /**
     * Update news item
     *
     */
    protected function _update() {
        return $this->_model->update($this);
    }



}