<?php

/**
 * Description of Grabber
 *
 * @author NE
 */
class RCMS_Object_Grubber_Grubber {

	/**
	 * Google API url to search
	 * 
	 */
	const SEARCH_URL = 'http://ajax.googleapis.com/ajax/services/search/web?v=1.0&q=site:';

	/**
	 * Website url
	 *
	 * @var string
	 */
	private $_url = '';

	/**
	 * Grabbed data
	 *
	 * @var array
	 */
	private $_links = array();

	/**
	 * Search results
	 *
	 * @var integer
	 */
	private $_resultsCount = 0;
	
	public function  __construct($url = '') {
		if($url) {
			$this->_url = urlencode($url);
		}
	}

	/**
	 * Grub all data for the site
	 *
	 * @return array
	 */
	public function grub() {
		if(!$this->_url) {
			return;
		}
		if(!$this->_resultsCount) {
			$start = 0;
		}
		$fullUrl = self::SEARCH_URL . $this->_url . '&start=' . $start;
		$result = $this->_crawlQuery($fullUrl);
		if(!$result) {
			return;
		}
		foreach ($result as $item) {
			$this->_links[] = $item;
		}	
		if($this->_resultsCount) {
			for($i = 0; $i <= ($this->_resultsCount - 1); $i++) {
				$start += 4;
				$fullUrl = self::SEARCH_URL . $this->_url . '&start=' . $start;
				$result = $this->_crawlQuery($fullUrl);
				foreach ($result as $item) {
					$this->_links[] = $item;
				}
			}
		}
		return $this->_links;
	}

	/**
	 * Set website url
	 *
	 * @param string $url
	 */
	public function setUrl($url) {
		$this->_url = $url;
	}

	/**
	 * Querying Google for indext pages
	 *
	 * @param string $fullUrl
	 * @return array
	 */
	private function _crawlQuery($fullUrl) {
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $fullUrl);
		curl_setopt($ch, CURLOPT_REFERER, 'http://www.seotoaster.com/');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$response = curl_exec($ch);
		curl_close($ch);
		$googleResponse = json_decode($response);
		if(!$googleResponse) {
			return;
		}
		if(!isset($googleResponse->responseData->cursor->pages)) {
			return;
		}
		if(!$this->_resultsCount) {
			$this->_resultsCount = count($googleResponse->responseData->cursor->pages);
		}
		foreach ($googleResponse->responseData->results as $item) {
			$grubbedLinks[] = array(
				'url'     => $item->url,
				'title'   => $item->title,
				'content' => $item->content
			);
		}
		return $grubbedLinks;
	}
}

