<?php

/**
 * GeneratorModel class.
 *
 * @author Eugene I. Nezhuta
 */
class RCMS_Object_Generator_GeneratorModel extends RCMS_Core_BaseModel {

	/**
	 * News table
	 *
	 * @var string
	 */
	private $_newsTable = "news";

	/**
	 * News  category table
	 *
	 * @var string
	 */
	private $_categoryNewsTable = "newscategory";

	/**
	 * Comments table
	 *
	 * @var string
	 */
	private $_commentTable = "comment";

	/**
	 * Variable content table
	 *
	 * @var string
	 */
	private $_variableTable = 'variable_content';

	/**
	 * Forms table
	 *
	 * @var string
	 */
	private $_formsTable = 'forms';

	/**
	 * Page table
	 *
	 * @var string
	 */
	private $_pageTable = 'page';

	/**
	 * Plugin table
	 *
	 * @var string
	 */
	private $_pluginTable = 'plugin';

	/**
	 * Config table
	 *
	 * @var string
	 */
	private $_configTable = 'config';

    /**
     * Config table for shopping
     * @var string
     */
    private $_shoppingConfig = 'shopping_config';

	/**
	 * Select data from database for text container
	 *
	 * @param string $name
	 * @return Object
	 */
	public function selectContainerTextData($name, $pageId, $containerType = RCMS_Object_Container_Container::C_TYPE_CONTENT) {
		$select = $this->_adapter->select()->from('container')->joinLeft('content', 'container.id=content.id_container')->where('container.name=?', $name)->where('container.page_id=?', $pageId)->where('container.container_type_id=?', $containerType);
		$result = $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_ASSOC);
		return $result;
	}

	/**
	 * Select data from db for static containers
	 *
	 * @param string $containerName
	 * @return array
	 */
	public function selectStaticContainerData($containerName, $containerType = RCMS_Object_Container_Container::C_TYPE_STATIC) {
		$select = $this->getAdapter()->select()
			->from(
			array ('c' => 'container')
			)
			->joinLeft(
			array('co' => 'content'),
			'c.id = co.id_container'
			)
			->where('c.name=?', $containerName)
			->where('c.container_type_id=?', $containerType);
		return $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_ASSOC);
	}

	/**
	 * Get categories for main menu
	 *
	 * @return array
	 */
	public function getMainMenuCategories($takeDraft = true) {
		if(!$takeDraft) {
			$select = $this->getAdapter()->select()
				->from(
					array('p' => 'page'),
					array(
						'categoryId' => 'category_id',
						'navigationTitle' => 'nav_name',
						'url',
						'h1'
					)
				)
				->joinLeft(
					array('c' => 'category'),
					'p.category_id=c.id',
					array('categoryName' => 'name')
				)
				->where('c.id_parent=0')
				->where('p.show_in_menu=\'1\'')
				->where('c.name <> ?', RCMS_Object_QuickConfig_QuickConfig::$draftCategoryName)
				->order(array('p.order ASC'));
		}
		else {
			$select = $this->getAdapter()->select()
				->from(
					array('p' => 'page'),
					array(
						'categoryId' => 'category_id',
						'navigationTitle' => 'nav_name',
						'url',
						'h1'
					)
				)
				->joinLeft(
					array('c' => 'category'),
					'p.category_id=c.id',
					array('categoryName' => 'name')
				)
				->where('c.id_parent=0')
				->where('p.show_in_menu=\'1\'')
				->order(array('p.order ASC'));
		}
		return $this->_adapter->fetchAll($select, null, Zend_Db::FETCH_ASSOC);
	}

	/**
	 * Get pages for main menu category
	 *
	 * @param integer $categoryId
	 * @return array
	 */
	public function getMainMenuCategoryPages($categoryId) {
		$select = $this->getAdapter()->select()
			->from(
			array('p' => 'page'),
			array(
			'categoryId' => 'category_id',
			'navigationTitle' => 'nav_name',
			'url',
			'h1'
			)
			)
			->joinLeft(
			array('c' => 'category'),
			'p.category_id=c.id',
			array('categoryName' => 'name')
			)
			->where('c.id_parent=?', $categoryId)
			->where('p.show_in_menu=\'1\' OR p.show_in_menu=\'3\'')
			->order('p.order ASC');
		return $this->_adapter->fetchAll($select, null, Zend_Db::FETCH_ASSOC);
	}

	/**
	 * Get pages list data from db for category
	 *
	 * @param integer $categoryId
	 * @return array
	 */
	public function getCategoryPagesList($categoryId) {
		$select = $this->getAdapter()->select()
			->from(
			array('p' => 'page'),
			array(
			'categoryId' => 'category_id',
			'description' => 'short_description',
			'navigationTitle' => 'nav_name',
			'url',
			'h1'
			)
			)
			->joinLeft(
			array('c' => 'category'),
			'p.category_id=c.id',
			array('categoryName' => 'name')
			)
			->where('c.id_parent=?', $categoryId)
			->order('p.order ASC');
		return $this->_adapter->fetchAll($select, null, Zend_Db::FETCH_ASSOC);
	}

	/**
	 * Get categories list
	 *
	 * @return array
	 */
	public function getCategoriesList($takeDraft = true) {
		if(!$takeDraft) {
			$select = $this->getAdapter()->select()
				->from(
				array('p' => 'page'),
					array(
						'categoryId' => 'category_id',
						'description' => 'short_description',
						'navigationTitle' => 'nav_name',
						'url',
						'h1',
					)
				)
				->joinLeft(
					array('c' => 'category'),
					'p.category_id=c.id',
					array('categoryName' => 'name')
				)
				->joinLeft(
					array('pi' => 'page_image'),
					'p.id=pi.page_id',
					array(
						'pageImagePath' => 'path',
						'pageImageName' => 'name',
						'pageImageDescription' => 'description'
					)
				)
				->where('c.id_parent=0')
				->where('c.id <> -1')
				->where('c.name <> ?', RCMS_Object_QuickConfig_QuickConfig::$draftCategoryName)
				->group('c.id')
				->order(array('p.order ASC'));
		}
		else {
			$select = $this->getAdapter()->select()
				->from(
				array('p' => 'page'),
					array(
						'categoryId' => 'category_id',
						'description' => 'short_description',
						'navigationTitle' => 'nav_name',
						'url',
						'h1',
					)
				)
				->joinLeft(
					array('c' => 'category'),
					'p.category_id=c.id',
					array('categoryName' => 'name')
				)
				->joinLeft(
					array('pi' => 'page_image'),
					'p.id=pi.page_id',
					array(
						'pageImagePath' => 'path',
						'pageImageName' => 'name',
						'pageImageDescription' => 'description'
					)
				)
				->where('c.id_parent=0')
				->where('c.id <> -1')
				->group('c.id')
				->order(array('p.order ASC'));
		}
		return $this->_adapter->fetchAll($select, null, Zend_Db::FETCH_ASSOC);
	}

	/**
	 * Get category pages list
	 *
	 * @param integer $categoryId
	 * @return array
	 */
	public function getCategoryPagesListImg($categoryId) {
		$select = $this->getAdapter()->select()
			->from(
			array('p' => 'page'),
			array(
			'categoryId' => 'category_id',
			'description' => 'short_description',
			'navigationTitle' => 'nav_name',
			'url',
			'h1'
			)
			)
			->joinLeft(
			array('c' => 'category'),
			'p.category_id=c.id',
			array('categoryName' => 'name')
			)
			->joinLeft(
			array('pi' => 'page_image'),
			'p.id=pi.page_id',
			array(
			'pageImagePath' => 'path',
			'pageImageName' => 'name',
			'pageImageDescription' => 'description'
			)
			)
			->where('c.id_parent=?', $categoryId)
			->group('p.id')
			->order('p.order ASC');
		return $this->_adapter->fetchAll($select, null, Zend_Db::FETCH_ASSOC);
	}


	/**
	 * Get categories for site map
	 *
	 * @return array
	 */
	public function getSiteMapCategories() {
		$select = $this->getAdapter()->select()
			->from(
			array('p' => 'page'),
			array(
			'categoryId' => 'category_id',
			'navigationTitle' => 'nav_name',
			'url',
			)
			)
			->joinLeft(
			array('c' => 'category'),
			'p.category_id=c.id',
			array('categoryName' => 'name')
			)
			->where('c.id_parent=0')
			->where('p.is_404page != \'1\'')
			->where('c.name <> ?', RCMS_Object_QuickConfig_QuickConfig::$draftCategoryName)
			->order('p.order ASC');
		return $this->_adapter->fetchAll($select, null, Zend_Db::FETCH_ASSOC);
	}

	/**
	 * Get pages for site map category
	 *
	 * @param integer $categoryId
	 * @return array
	 */
	public function getSiteMapCategoryPages($categoryId) {
		$select = $this->getAdapter()->select()
			->from(
			array('p' => 'page'),
			array(
			'id',
			'categoryId' => 'category_id',
			'navigationTitle' => 'nav_name',
			'url',
			)
			)
			->joinLeft(
			array('c' => 'category'),
			'p.category_id=c.id',
			array('categoryName' => 'name')
			)
			->where('c.id_parent=?', $categoryId)
			->where('p.url <> "no-category" ')
			->where('p.is_404page <> \'1\'')
			->order('p.order ASC');
		return $this->_adapter->fetchAll($select, null, Zend_Db::FETCH_ASSOC);
	}

	/**
	 * Get data for static menu
	 *
	 * @return array
	 */
	public function getStaicMenuPages() {
		$select = $this->getAdapter()->select()
			->from(
			array('p' => 'page'),
			array(
			'categoryId' => 'category_id',
			'navigationTitle' => 'nav_name',
			'url',
			)
			)
			->joinLeft(
			array('c' => 'category'),
			'p.category_id=c.id',
			array('categoryName' => 'name')
			)
			->where('p.show_in_menu=\'2\'')
			->order('p.static_order ASC');
		return $this->_adapter->fetchAll($select, null, Zend_Db::FETCH_ASSOC);
	}

	/**
	 * Get pages list for featured area
	 *
	 * @param integer $featuredId
	 * @param integer $exeptPageId
	 * @param integer $count
	 * @return array
	 */
	public function getPagesListByFeaturedId($featuredId, $exeptPageId, $count = 0) {
		if($count == 0) {
			$select = $this->getAdapter()->select()
				->from(
				array('p' => 'page'),
				array(
				'description' => 'short_description',
				'navigationTitle' => 'nav_name',
				'url',
				'h1'
				)
				)->join(
				array('page_has_fa' => 'page_has_fa'),
				'page_has_fa.page_id = p.id')
				->where('page_has_fa.fa_id = ?',$featuredId)->where('p.id <> ?',$exeptPageId)->group('p.id')->order('p.order ASC');
		}else {
			$select = $this->getAdapter()->select()
				->from(
				array('p' => 'page'),
				array(
				'description' => 'short_description',
				'navigationTitle' => 'nav_name',
				'url',
				'h1'
				)
				)->join(
				array('page_has_fa' => 'page_has_fa'),
				'page_has_fa.page_id = p.id')
				->where('page_has_fa.fa_id = ?',$featuredId)->where('p.id <> ?',$exeptPageId)->group('p.id')->order('p.order ASC')->limit($count);
		}
		return $this->_adapter->fetchAll($select, null, Zend_Db::FETCH_ASSOC);
	}

	/**
	 * Get pages list with images for featured area
	 *
	 * @param integer $featuredId
	 * @param integer $exeptPageId
	 * @param integer $count
	 * @return array
	 */
	public function getPagesListImagesByFeaturedId($featuredId, $exeptPageId, $count = 0) {
		if($count != 0) {
			$select = $this->getAdapter()->select()
				->from(
				array('p' => 'page'),
				array(
				'description' => 'short_description',
				'navigationTitle' => 'nav_name',
				'url',
				'h1'
				))
				->join(
				array('page_has_fa' => 'page_has_fa'),
				'page_has_fa.page_id = p.id')
				->joinLeft(
				array('pi' => 'page_image'),
				'p.id=pi.page_id',
				array(
				'pageImagePath' => 'path',
				'pageImageName' => 'name',
				'pageImageDescription' => 'description'
				))
				->where('page_has_fa.fa_id = ?',$featuredId)->where('p.id <> ?',$exeptPageId)->group('p.id')->order('p.order ASC')->limit($count);
		}else {
			$select = $this->getAdapter()->select()
				->from(
				array('p' => 'page'),
				array(
				'description' => 'short_description',
				'navigationTitle' => 'nav_name',
				'url',
				'h1'
				))
				->join(
				array('page_has_fa' => 'page_has_fa'),
				'page_has_fa.page_id = p.id')
				->joinLeft(
				array('pi' => 'page_image'),
				'p.id=pi.page_id',
				array(
				'pageImagePath' => 'path',
				'pageImageName' => 'name',
				'pageImageDescription' => 'description'
				))
				->where('page_has_fa.fa_id = ?',$featuredId)->where('p.id <> ?',$exeptPageId)->group('p.id')->order('p.order ASC');
		}
		return $this->_adapter->fetchAll($select, null, Zend_Db::FETCH_ASSOC);
	}

	/**
	 * Get all pages ids and keywords
	 *
	 * @param integer $excludeId
	 * @return array
	 */
	public function getAllPagesIdsAndKeywords($excludeId) {
		$select = $this->getAdapter()->select()
			->from(
			array('p' => 'page'),
			array(
			'id',
			'keywords' => 'meta_keywords'
			)
			)
			->where('p.id != ?', $excludeId);
		return $this->getAdapter()->fetchAssoc($select);
	}

	/**
	 * Get data for related pages
	 *
	 * @param array $pagesIds
	 * @param integer $limit
	 * @param boolean $withImage
	 * @return array
	 */
	public function getRelatedPagesData($pagesIds, $limit, $withImage) {
		if($withImage) {
			$select = $this->getAdapter()->select()
				->from(
				array('p' => 'page'),
				array(
				'h1',
				'url',
				'navigationName' => 'nav_name',
				'description' => 'short_description'
				)
				)
				->joinLeft(
				array('pi' => 'page_image'),
				'p.id=pi.page_id',
				array(
				'pageImagePath' => 'path',
				'pageImageName' => 'name',
				'pageImageDescription' => 'description'
				)
				)
				->where('p.id IN (?)', $pagesIds)
				->limit(intval($limit));
		}
		else {
			$select = $this->getAdapter()->select()
				->from(
				array('p' => 'page'),
				array(
				'h1',
				'url',
				'navigationName' => 'nav_name',
				'description' => 'short_description'
				)
				)
				->where('p.id IN (?)', $pagesIds)
				->limit(intval($limit));
		}
		try {
			$result = $this->getAdapter()->fetchAssoc($select);
		}
		catch(Exception $e) {
			return array();
		}
		return $result;
	}

	/**
	 * Select news page by url
	 *
	 * @param string $url
	 * @return array
	 */
	public function selectNewsByUrl($url) {
		$select = $this->getAdapter()->select()
			->from(
			array('n' => $this->_newsTable),
			array(
			'newsId' => 'n.id',
			'newsCategoryId' => 'n.id_newscategory',
			'newsTitle' => 'n.title',
			'newsUrl' => 'n.page_url',
			'newsIntro' => 'n.intro',
			'newsText' => 'n.text',
			'newsDate'=> 'n.date',
			'newsOrder' => 'n.order',
			'newsArchived'=>'n.is_archived',
			'newsFeatured' => 'n.is_featured',
			'newsDisableArchive' => 'n.disable_archive',
			'newsLastUpdate' => 'n.last_update'
			)
			)
			->joinLeft(
			array('nc' =>$this->_categoryNewsTable),
			'n.id_newscategory=nc.id',
			array(
			'newsCategoryName' => 'nc.name'
			)
			)
			->where('n.page_url=?', $url);
		$result = $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_OBJ);
		return $result;
	}

	/**
	 * Select all news from database
	 *
	 * @param integer $id_newscategory
	 * @return array
	 */
	public function selectAllNews($id_newscategory = false) {
		if($id_newscategory===false) {
			$select = $this->getAdapter()->select()
				->from(
				array('n' => $this->_newsTable),
				array(
				'newsId' => 'n.id',
				'newsCategoryId' => 'n.id_newscategory',
				'newsTitle' => 'n.title',
				'newsUrl' => 'n.page_url',
				'newsIntro' => 'n.intro',
				'newsText' => 'n.text',
				'newsDate'=> 'n.date',
				'newsOrder' => 'n.order',
				'newsArchived'=>'n.is_archived',
				'newsFeatured' => 'n.is_featured',
				'newsDisableArchive' => 'n.disable_archive',
				'newsLastUpdate' => 'n.last_update'
				)
			)
			->order('n.date DESC')
			->order('n.order DESC');
		}
		else {
			$select = $this->getAdapter()->select()
				->from(
				array('n' => $this->_newsTable),
				array(
				'newsId' => 'n.id',
				'newsCategoryId' => 'n.id_newscategory',
				'newsTitle' => 'n.title',
				'newsUrl' => 'n.page_url',
				'newsIntro' => 'n.intro',
				'newsText' => 'n.text',
				'newsDate'=> 'n.date',
				'newsOrder' => 'n.order',
				'newsArchived'=>'n.is_archived',
				'newsFeatured' => 'n.is_featured',
				'newsDisableArchive' => 'n.disable_archive',
				'newsLastUpdate' => 'n.last_update'
				))->where('n.id_newscategory = ?',$id_newscategory)
				->order('n.date DESC')
				->order('n.order DESC');
		}
		$result = $this->_adapter->fetchAll($select, null, Zend_Db::FETCH_ASSOC);
		return $result;
	}

	/**
	 * Select all categories for news
	 * @return array
	 */
	public function selectAllNewsCategories() {
		$select = $this->getAdapter()->select()
			->from(
			array('nc' => $this->_categoryNewsTable),
			array(
			'newsCategoryId' => 'nc.id',
			'newsCategoryName' => 'nc.name'
			)
		);
		$result = $this->_adapter->fetchAll($select, null,Zend_Db::FETCH_ASSOC);
		return $result;
	}

	/**
	 * Select news for news-scroller
	 *
	 * @return array
	 */
	public function selectNewsItemsForScroller() {
		$select = $this->getAdapter()->select()
			->from(
				array('n' => 'news'),
				array(
					'title' => 'n.title',
					'url' => 'n.page_url',
					'description' => 'n.intro'
				)
			)
			->where('n.is_featured = \'1\'');
		return $this->getAdapter()->fetchAll($select, null, Zend_Db::FETCH_ASSOC);
	}

	/**
	 * Get page id by category id
	 *
	 * @param integer $categoryId
	 * @return array
	 */
	public function getPageIdByCategoryId($categoryId) {
		$select = $this->getAdapter()->select()
			->from(
			array('p' => 'page'),
			array(
			'id'
			)
			)
			->where('category_id=?', $categoryId);
		return $this->getAdapter()->fetchOne($select);
	}

	/**
	 * Get current news folder from the database
	 *
	 * @return string
	 */
	public function getNewsFolder() {
		$select = $this->getAdapter()->select()
			->from(
			array('c' => 'config'),
			array(
			'value'
			)
			)
			->where("name='default_news_folder'");
		return $this->getAdapter()->fetchOne($select);
	}

	/**
	 * Select comments for given container
	 *
	 * @param integer $containerId
	 * @param boolean $isLogged
	 * @return array
	 */
	public function selectCommenstByContainerId($containerId,$isLogged) {
		$where1 = sprintf("container_id = %d", $containerId);
		$where2 = "publish <> 0";
		if($isLogged) {
			$select = $this->_adapter->select()->from($this->_commentTable)->where($where1)->order('date DESC');
		}else {
			$select = $this->_adapter->select()->from($this->_commentTable)->where($where1)->where($where2)->order('date DESC');
		}

		$result = $this->_adapter->fetchAll($select, null, Zend_Db::FETCH_ASSOC);
		return $result;
	}

	/**
	 * Get admin email field from config
	 *
	 * @return array
	 */
	public function selectConfigGetEmailAdmin() {
		$select = $this->_adapter->select('name, value')->from('config')->where('name = "admin_email"');
		return $this->_adapter->fetchAssoc($select);
	}

	/**
	 * Select name of payment button
	 *
	 * @param string $name
	 * @return array
	 */
	public function selectPaymentButtonByName($name) {
		$where = sprintf("name = '%s'", $name);
		$select = $this->_adapter->select()->from($this->_variableTable,array('value'=>'value'))->where($where);
		return $this->_adapter->fetchAll($select);
	}

	/**
	 * Get code for variable
	 *
	 * @param string $name
	 * @return array
	 */
	public function getVariableCode($name) {
		$select = $this->getAdapter()->select()
			->from(
			array('vc' => 'variable_content'),
			array(
			'value'
			)
			)
			->where('vc.name=?', $name);
		return $this->getAdapter()->fetchOne($select);
	}

	/**
	 * Get form id by name
	 *
	 * @param string $name
	 * @return array
	 */
	public function getFormId($name) {
		$select = $this->getAdapter()->select()
			->from($this->_formsTable)
			->where('name=?', $name);
		return $this->getAdapter()->fetchOne($select);
	}

	/**
	 * Get seo top variable
	 *
	 * @param integer $pageId
	 * @return array
	 */
	public function getSeoTopVar($pageId) {
		$select = $this->getAdapter()->select()
			->from(
			array('sd' => 'seo_data'),
			array(
			'seo_top'
			)
			)
			->where('page_id=?', $pageId);
		return $this->getAdapter()->fetchOne($select);
	}

	/**
	 * Get seo boittom variable
	 *
	 * @param integer $pageId
	 * @return array
	 */
	public function getSeoBottomVar($pageId) {
		$select = $this->getAdapter()->select()
			->from(
			array('sd' => 'seo_data'),
			array(
			'seo_bottom'
			)
			)
			->where('page_id=?', $pageId);
		return $this->getAdapter()->fetchOne($select);
	}

	/**
	 * Get id of 404 page
	 *
	 * @return integer
	 */
	public function get404PageId() {
		$select = $this->getAdapter()->select()
			->from(
			array('p' => 'page'),
			array(
			'id'
			)
			)
			->where('is_404page=1');
		return $this->getAdapter()->fetchOne($select);
	}

	/**
	 * Selects a page with the page preview image by page id.
	 *
	 * @param <Integer> $pageId
	 * @return <Array>
	 */
	public function selectPageWithImageByPageId($pageId) {
		$select = $this->getAdapter()->select()
			->from(
			array('p' => 'page'),
			array(
			'description' => 'short_description',
			'navigationTitle' => 'nav_name',
			'url',
			'h1'
			))
			->joinLeft(
			array('pi' => 'page_image'),
			'p.id=pi.page_id',
			array(
			'pageImagePath' => 'path',
			'pageImageName' => 'name',
			'pageImageDescription' => 'description'
			))->where('p.id = ?',$pageId)->group('p.id')->order('p.order ASC')->limit(1);
		return $this->_adapter->fetchAll($select);
	}


	/**
	 * Selects a page id by page navigation name
	 *
	 * @param <String> $nav_name
	 * @return <Integer>
	 */
	public function selectPageIdByPageNavName($nav_name) {
		$select = $this->getAdapter()->select()->from($this->_pageTable)->where('nav_name = ?', $nav_name);
		return $this->_adapter->fetchOne($select);
	}

	/**
	 * This function selects plugin by name.
	 * @param string $name
	 * @return object
	 */
	public function selectPluginByName($name)
	{
		$select = $this->_adapter->select()->from($this->_pluginTable)->where('name = ?', $name);
		return $select->query()->fetchObject();
	}

	/**
	 * This function intalls plugin.
	 * 
	 * @param string $sql
	 * @return object
	 */
	public function installPlugin($sql)
	{
		try {
		$this->getAdapter()->query($sql);
		} catch (Exception $e) {
			return false;
		}

		return true;
	}

	/**
     * Select all from config
	 * 
     * @param string $parentId
     */
    public function selectDefaultNewsFolder() {
        $select = $this->getAdapter()->select()->from($this->_configTable)->where('name = "default_news_folder"');
        $result = $this->_adapter->fetchPairs($select);
        return $result;
    }

	public function getCategoryIdByName($name) {
		$select = $this->getAdapter()->select()
			->from(
				array('c' => 'category'),
				array(
					'id'
				)
			)
			->where('c.name = ?', $name);
		return $this->getAdapter()->fetchOne($select);
	}

	public function getConfigImagesPresets() {
		$select = $this->getAdapter()->select()->from('config');
		$result = $this->getAdapter()->fetchAll($select);
		$presets = array();
		foreach($result as $item) {
			if($item['name'] == 'img_small') {
				$presets['small'] = $item['value'];
			}
			if($item['name'] == 'img_medium') {
				$presets['medium'] = $item['value'];
			}
			if($item['name'] == 'img_large') {
				$presets['large'] = $item['value'];
			}
		}
		return $presets;
	}

    public function selectTemplateForProduct()
    {
        $sql = $this->getAdapter()->select()->from($this->_shoppingConfig, array('name', 'value'))->where("name = 'template' OR name = 'currency'");
        return  $this->getAdapter()->fetchAssoc($sql);
    }

    public function selectProductsByGroupName($groupName)
    {
        $sql = $this->getAdapter()->select()->from(array('sg' => 'shopping_groups'), array())
                ->join(array('p' => $this->_shoppingProducts), 'p.id = id_product', array('id','name','item_id','photo','brand'))
                ->where("id_group = ?", $groupId);
        return $this->_adapter->fetchAll($sql);
    }

    public function selectBrandByName($name)
    {
        $sql = $this->_adapter->select()->from($this->_shoppingProducts, array('id','name','item_id','photo','brand'))
                ->where("brand <> '' AND brand = ?", $name)->distinct();
        return $this->_adapter->fetchAll($sql);
    }

    /*
    public function selectNameProducts($name)
    {
        $sql = $this->_adapter->select()->from(array('sg' => 'shopping_groups'), array())
            ->join(array('spg' => 'shopping_products_groups'), 'spg.id_group = sg.id', array())
            ->join(array('sp' => 'shopping_products'), 'sp.id = spg.id_product', array('id', 'name'))
            ->where('sg.name = ?', $name);
        return $this->_adapter->fetchAll($sql);
    }
    */
}
