<?php
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
class RCMS_Object_Form_FormModel extends RCMS_Core_BaseModel
{
    protected $_formsTable = 'forms';

	public function selectFormById($id) {
		$select = $this->getAdapter()->select()
			->from(
				array('f' => $this->_formsTable),
				array(
					'formId' => 'f.id',
					'formName' => 'f.name',
					'formCode' => 'f.code',
					'formEmail' => 'f.email',
					'successMessage',
					'errorMessage',
					'emailFrom',
					'emailMessage',
					'useSMTP',
				)
			)
			->where('f.id=?', $id);
		return $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_OBJ);
	}

	public function insertForm(RCMS_Object_Form_Form $formObj) {

		$formData = array(
			'name' => $formObj->getName(),
            'code' => $formObj->getCode(),
            'email' => $formObj->getEmail(),
            'successMessage' => $formObj->getSuccessMessage(),
            'errorMessage' => $formObj->getErrorMessage(),
            'emailFrom' => $formObj->getEmailFrom(),
            'emailMessage' => $formObj->getEmailMessage(),
            'useSMTP' => $formObj->getUseSMTP(),
		);
        
		$this->_adapter->insert($this->_formsTable, $formData);
		return $this->_adapter->lastInsertId($this->_formsTable);
	}

	
	public function updateForm(RCMS_Object_Form_Form $formObj) {
		$formData = array(
			'name' => $formObj->getName(),
            'code' => $formObj->getCode(),
            'email' => $formObj->getEmail(),
            'successMessage' => $formObj->getSuccessMessage(),
            'errorMessage' => $formObj->getErrorMessage(),
            'emailFrom' => $formObj->getEmailFrom(),
            'emailMessage' => $formObj->getEmailMessage(),
            'useSMTP' => $formObj->getUseSMTP(),
		);
        
		$where = sprintf("id = %d", $formObj->getId());
		return  $this->_adapter->update($this->_formsTable, $formData, $where);
	}

    public function deleteForm(RCMS_Object_Form_Form $formObj) {
		 $where = sprintf("id = %d", $formObj->getId());
         return $this->_adapter->delete($this->_formsTable, $where);
	}
}
