<?php
/**
 * Class defines Form object.
 * @author Pavel Savchuk
 */
class RCMS_Object_Form_Form extends RCMS_Core_BaseObject {
/**
 * Form model
 *
 * @var string
 */
	protected $_model;

	/**
	 * Form name
	 *
	 * @var string
	 */
	private $_name;

	/**
	 * Form code
	 *
	 * @var string
	 */
	private $_code;

	/**
	 * Form email
	 *
	 * @var string
	 */
	private $_email;

	/**
	 * Form successMessage
	 *
	 * @var string
	 */
	private $_successMessage;

	/**
	 * Form errorMessage
	 *
	 * @var string
	 */
	private $_errorMessage;

	/**
	 * Form enail from
	 *
	 * @var string
	 */
	private $_emailFrom;

	/**
	 * Form emailmessage
	 *
	 * @var string
	 */
	private $_emailMessage;

	/**
	 * Form useSMTP
	 *
	 * @var integer
	 */
	private $_useSMTP;


	public function  __construct($formId = false) {
		$this->_model = new RCMS_Object_Form_FormModel();
		if($formId) {
			$formData = $this->_model->selectFormById($formId);
			if(!is_object($formData)) {
				throw new Exception ('Form loading is falied!');
			}
			$this->setId($formData->formId);
			$this->setName($formData->formName);
			$this->setCode($formData->formCode);
			$this->setEmail($formData->formEmail);
			$this->setSuccessMessage($formData->successMessage);
			$this->setErrorMessage($formData->errorMessage);
			$this->setEmailFrom($formData->emailFrom);
			$this->setEmailMessage($formData->emailMessage);
			$this->setUseSMTP($formData->useSMTP);
		}
	}

	/**
	 *Getter for name
	 *
	 *@return string
	 */
	public function getName() {
		return $this->_name;
	}

	/**
	 * Setter for name
	 *
	 * @param string $name
	 */
	public function setName($name) {
		$this->_name = trim($name);
	}
	/**
	 *Getter for code
	 *
	 *@return string
	 */
	public function getCode() {
		return $this->_code;
	}
	/**
	 * Setter for code
	 *
	 * @param string $code
	 */
	public function setCode($code) {
		$this->_code = trim($code);
	}
	/**
	 *Getter for email
	 *
	 *@return string
	 */
	public function getEmail() {
		return $this->_email;
	}
	/**
	 * Setter for name
	 *
	 * @param string $email
	 */
	public function setEmail($email) {
		$this->_email = trim($email);
	}
	/**
	 *Getter for success meassage
	 *
	 *@return string
	 */
	public function getSuccessMessage() {
		return $this->_successMessage;
	}
	/**
	 * Setter for success message
	 *
	 * @param string $successMessage
	 */
	public function setSuccessMessage($successMessage) {
		$this->_successMessage = trim($successMessage);
	}
	/**
	 *Getter for error message
	 *
	 *@return string
	 */
	public function getErrorMessage() {
		return $this->_errorMessage;
	}
	/**
	 * Setter for error message
	 *
	 * @param string $errorMessage
	 */
	public function setErrorMessage($errorMessage) {
		$this->_errorMessage = trim($errorMessage);
	}
	/**
	 *Getter for email from
	 *
	 *@return string
	 */
	public function getEmailFrom() {
		return $this->_emailFrom;
	}
	/**
	 * Setter for email from
	 *
	 * @param string $emailFrom
	 */
	public function setEmailFrom($emailFrom) {
		$this->_emailFrom = trim($emailFrom);
	}
	/**
	 *Getter for email message
	 *
	 *@return string
	 */
	public function getEmailMessage() {
		return $this->_emailMessage;
	}
	/**
	 * Setter for email message
	 *
	 * @param string $emailMessage
	 */
	public function setEmailMessage($emailMessage) {
		$this->_emailMessage = trim($emailMessage);
	}
	/**
	 *Getter for use SMTP
	 *
	 *@return integer
	 */
	public function getUseSMTP() {
		return $this->_useSMTP;
	}
	/**
	 * Setter for use SMTP
	 *
	 * @param integer $useSMTP
	 */
	public function setUseSMTP($useSMTP) {
		$this->_useSMTP = trim($useSMTP);
	}

	/**
	 * delete form
	 */
	public function delete() {
		return $this->_model->deleteForm($this);
	}

	/**
	 * insert form
	 */
	protected function _insert() {
		return $this->_model->insertForm($this);
	}

	/**
	 * update form
	 */
	protected function _update() {
		return $this->_model->updateForm($this);
	}

}
