<?php
/**
 * User class defines FeaturedAreaModel.
 * @author Pavel Savchuk
 */
class RCMS_Object_FeaturedArea_FeaturedAreaModel extends RCMS_Core_BaseModel {

    private $_tableName = "featured_area";
	
    private $_tablePageHasFaName = "page_has_fa";
    /**
     * Select container with content by it's id
     *
     * @param integer $id
     * @return Object
     */
    public function selectFeaturedAreaById($id) {
        $select = $this->getAdapter()->select()
        ->from(
            array('f' => 'featured_area'),
            array(
                    'id',
                    'name',
                    'order'
            )
        )->where('f.id = ?', $id);
        $result = $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_OBJ);
        return $result;
    }

    /**
     * Select container with content by it's id
     *
     * @param integer $id
     * @return Object
     */
    public function selectFeaturedAreas() {
        $select = $this->getAdapter()->select()
        ->from(
            array('f' => $this->_tableName),
            array(
                    'id' => 'f.id',
                    'name' => 'f.name',
                    'order' => 'f.order',
            )
        );
        $result = $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_OBJ);
        return $result;
    }

    public function selectFeaturedAreaByName($name) {
        $select = $this->getAdapter()->select()
        ->from(
            array('f' => $this->_tableName),
            array(
                    'id' => 'f.id',
                    'name' => 'f.name',
                    'content' => 'f.content',
            )
        )->where('f.name=?', $name);
        $result = $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_OBJ);
        return $result;
    }

    /**
     * Insert new container into database
     *
     * @param RCMS_Object_Container_Container $container
     */
    public function insertFeaturedArea(RCMS_Object_FeaturedArea_FeaturedArea $featuredArea) {
        $featuredData = array(
            'name' => $featuredArea->getName(),
            'content' => $featuredArea->getContent(),

        );
        $this->_adapter->insert($this->_tableName, $featuredData);
        $addedFeaturedAreaId = $this->_adapter->lastInsertId($this->_tableName);
        return $addedFeaturedAreaId;
    }

    /**
     * Update existing container with new data
     *
     * @param RCMS_Object_Container_Container $container
     */
    public function updateFeaturedArea(RCMS_Object_FeaturedArea_FeaturedArea $featuredArea) {
        $featuredAreaData = array(
            'name' =>$featuredArea->getName(),
            'content' => $featuredArea->getContent(),
        );
        $where = sprintf("id = %d", $featuredArea->getId());
        $result = $this->_adapter->update($this->_tableName, $featuredAreaData, $where);
        return $result;
    }

    public function deleteFeaturedArea(RCMS_Object_FeaturedArea_FeaturedArea $featuredArea)
    {
        $this->getAdapter()->delete($this->_tablePageHasFaName,"fa_id = ".$featuredArea->getId());
        return $this->getAdapter()->delete($this->_tableName,"id = ".$featuredArea->getId());
    }


}

