<?php
/**
 * FeaturedArea  object.
 * @author Pavel Savchuk
 */
class RCMS_Object_FeaturedArea_FeaturedArea extends RCMS_Core_BaseObject {

	/**
	 * Featured area name
	 *
	 * @var string
	 */
    private $_name;

	/**
	 * Featured area content
	 *
	 * @var string
	 */
    private $_content;

	/**
	 * Featured area model
	 *
	 * @var RCMS_Object_FeaturedArea_FeaturedAreaModel
	 */
    public $_model = null;

    /**
     * Constructor. If containerId not eq. false, then load container from db by id
     *
     * @param integer $containerId
     */
    public function  __construct($featuredId = false) {
        $this->_model = new RCMS_Object_FeaturedArea_FeaturedAreaModel();
        if($featuredId) {
            $featuredData = $this->_model->selectFeaturedAreaById($featuredId);
            if(!is_object($featuredData)) {
                throw new Exception ('Featured area loading is falied!');
            }
            $this->setId($featuredData->id);
            //$this->setContent($featuredData->content);
            $this->setName($featuredData->name);
        }
    }

/**
	 *Getter for content
	 *
	 *@return string
	 */
    public function getName()
    {
        return $this->_name;
    }

 /**
     * Setter for name
     *
     * @param string $name
     */
    public function setName($name)
    {
        $this->_name = trim($name);
    }

/**
	 *Getter for content
	 *
	 *@return string
	 */
    public function getContent()
    {
        return $this->_content;
    }

 /**
     * Setter for content
     *
     * @param string $content
     */
    public function setContent($content)
    {
        $this->_content = trim($content);
    }


    /**
     * Delete container
     *
     */
    public function delete()
    {
        return $this->_model->deleteFeaturedArea($this);
    }

    /**
     * Insert container to the database
     *
     */
    protected function _insert() {
        return $this->_model->insertFeaturedArea($this);
    }

    /**
     * Update container
     *
     */
    protected function _update() {
        return $this->_model->updateFeaturedArea($this);
    }



}