<?php
/**
 *  DeeplinkModel object.
 * @author Pavel Savchuk
 */
class RCMS_Object_Deeplink_DeeplinkModel extends RCMS_Core_BaseModel {

	/**
	 * Name of table in the database.
	 * @var string
	 */
    private $_tableName = 'deeplink';

    /**
     * Insert new deeplink into database.
     * @param object RCMS_Object_Deeplink_Deeplink $deeplink
     * @return integer
     */
    public function insertDeeplink(RCMS_Object_Deeplink_Deeplink $deeplink)
    {
          $data = array(
            'name'  => $deeplink->getName(),
            'url'   => $deeplink->getUrl(),
            'type'  => $deeplink->getType(),
            'ban'   => $deeplink->getBan(),
            'nofollow' => $deeplink->getNoFollow(),
			'ext_ws_id' => $deeplink->getExtWebsiteId()
        );

        $flag = $this->_adapter->insert($this->_tableName, $data);
        if($flag > 0)
        {
            return $this->_adapter->lastInsertId($this->_tableName);
        }
    }

    /**
     * Update the deeplink.
     * @param object RCMS_Object_Deeplink_Deeplink $deeplink
     * @return integer
     */
    public function updateDeeplink(RCMS_Object_Deeplink_Deeplink $deeplink)
    {
        $data = array(
            'name'  => $deeplink->getName(),
            'url'   => $deeplink->getUrl(),
            'type'  => $deeplink->getType(),
            'ban'   => $deeplink->getBan(),
            'nofollow' => $deeplink->getNoFollow(),
			'ext_ws_id' => $deeplink->getExtWebsiteId()
        );
        $where = sprintf("id = %d", $deeplink->getId());
        return $this->_adapter->update($this->_tableName, $data, $where);
    }

    /**
     * Select deeplink by id.
     * @param integer $id
     * @return integer
     */
    public function selectDeeplinkById($id)
    {
        $where = sprintf("id = %d", $id);
        $select = $this->_adapter->select()->from($this->_tableName)->where($where);
        return $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_OBJ);
    }
	
    /**
     * Delete deeplink.
     * @param integer $id
     * @return integer
     */
    public function deleteDeeplink($id)
    {
        $where = sprintf("id = %d", $id);
        return $this->_adapter->delete($this->_tableName, $where);
    }
}
