<?php
/**
 * Deeplink object.
 * @author Pavel Savchuk
 */
class RCMS_Object_Deeplink_Deeplink extends RCMS_Core_BaseObject {
	
	/**
	 * Deeplink of name
	 * @var string
	 */
    private $_name;

    /**
     * Deeplink of url
     * @var string
     */
    private $_url;
	
    /**
     * Deeplink of type
     * @var string
     */
    private $_type;
	
    /**
     * Deeplink of ban/unban
     * @var integer
     */
    private $_ban;
	
    /**
     * * Deeplink of follow/nofollow
     * @var integer
     */
    private $_nofollow;
	
    /**     
     * If deeplink have type of external 
     * @var integer
     */
	private $_extWebsiteId = 0;

    const TYPE_INTERNAL = 'int';

    const TYPE_EXTERNAL = 'ext';

	/*
	 * Constructor.
	 * @param integer $id
	 */
    public function  __construct($id = null)
    {
        $this->_model = new RCMS_Object_Deeplink_DeeplinkModel();
        if($id !== null){            
            $this->_init(intval($id));
        }
    }
    
    /**
     * This function returns $id for external website. 
     * @return integer
     */
	public function getExtWebsiteId() 
	{
		return $this->_extWebsiteId;
	}

	/**
	 * This function sets $id for external website.
	 * @param ingeter $extWebsiteId
	 * @return void
	 */
	public function setExtWebsiteId($extWebsiteId) 
	{
		$this->_extWebsiteId = $extWebsiteId;
	}

	/**
	 * Initialization.
	 * @param integer $id
	 * @return void
	 */
    private function _init($id)
    {
        $deeplink = $this->_model->selectDeeplinkById($id);

        if(is_object($deeplink))
        {
            $this->setId((integer)$deeplink->id);
            $this->setName($deeplink->name);
            $this->setUrl($deeplink->url);
            $this->setType($deeplink->type);
            $this->setBan($deeplink->ban);
            $this->setNoFollow($deeplink->nofollow);
			$this->setExtWebsiteId($deeplink->ext_ws_id);
        }
    }
	
    /**
     * This function returns name of deeplink.
     * @return string
     */
    public function getName()
    {
        return $this->_name;
    }

    /**
     * This function sets name for deeplink.
     * @param string $name
     * @return void
     */
    public function setName($name)
    {
        $this->_name = (string) $name;
    }

    /**
     * This function returns url of deeplink.
     * @return string
     */
    public function getUrl()
    {
        return $this->_url;
    }
	
    /**
     * This function sets url for deeplink.
     * @param string $url
     * @return void
     */
    public function setUrl($url)
    {
        $this->_url = (string) $url;
    }

    /**
     * This function returns type of deeplink.
     * @return string
     */
    public function getType()
    {
        return $this->_type;
    }

    /**
     * This function sets type for deeplink.
     * @param string $type
     * @return void
     */
    public function setType($type)
    {
        $type = (string) $type;

        if($type === self::TYPE_INTERNAL)
        {
            $this->_type = self::TYPE_INTERNAL;
        }
        else
        {
            $this->_type = self::TYPE_EXTERNAL;
        }
    }

    /**
     * This function returns ban of deeplink.
     * @return integer
     */
    public function getBan()
    {
        return $this->_ban;
    }

    /**
     * This function sets ban for deeplink.
     * @param integer $ban
     * @return void
     */
    public function setBan($ban)
    {
        $ban = (integer) $ban;
        if($ban === 1)
        {
            $this->_ban = 1;
        }
        else
        {
            $this->_ban = 0;
        }
    }

    /**
     * This function returns nofollow of deeplink.
     * @return integer
     */
    public function getNoFollow()
    {
        return $this->_nofollow;
    }

    /**
     * This function sets nofollow for deeplink.
     * @param integer $nofollow
     * @return void
     */
    public function setNoFollow($nofollow)
    {
         $nofollow = (integer) $nofollow;
        if($nofollow === 1)
        {
            $this->_nofollow = 1;
        }
        else
        {
            $this->_nofollow = 0;
        }
    }

    /**
     * This function deletes deeplink.
     * @see app/core/RCMS_Core_BaseObject#delete()
     */
    public function delete()
    {
        return $this->_model->deleteDeeplink($this->getId());
    }
    
    /**
     * This function inserts deeplink into the database.
     * @see app/core/RCMS_Core_BaseObject#_insert()
     */
    protected function _insert()
    {
        $id = (integer) $this->_model->insertDeeplink($this);
        if($id > 0)
        {
            $this->setId($id);
            return $id;
        }
    }
    
    /**
     * This function updates deeplink in the database.
     * @see app/core/RCMS_Core_BaseObject#_update()
     */
    protected function _update()
    {
        return $this->_model->updateDeeplink($this);
    }
}
