<?php

/**
 * ContainerModel class
 *
 * @author Eugene I. Nezhuta
 */
class RCMS_Object_Container_ContainerModel extends RCMS_Core_BaseModel {

	/**
	 * Select container with content by it's id
	 *
	 * @param integer $id
	 * @return Object
	 */
	public function selectContainerById($id) {
		$select = $this->getAdapter()->select()
			->from(
				array('co' => 'container'),
				array(
					'containerId' => 'co.id',
					'containerTypeId' => 'co.container_type_id',
					'ownerId' => 'co.user_id',
					'pageId' => 'co.page_id',
					'name' => 'co.name',
					'optValues' => 'co.options_values',
					'published',
					'forSale' => 'co.is_forsale',
					'price',
					'firstOpt' => 'co.first_option',
					'secondOpt' => 'co.second_option',
					'commentsAllowed' => 'co.allow_comments',
                    'publishingDate'=>'co.publishing_date',
				)
			)
			->joinLeft(
				array('con' =>'content'),
				'co.id=con.id_container',
				array(
					'contentId' => 'con.id',
					'contentLanguageId' => 'con.id_language',
					'value'
				)
			)
			->where('co.id=?', $id);
		$result = $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_OBJ);
		return $result;
	}

	/**
	 * Insert new container into database
	 *
	 * @param RCMS_Object_Container_Container $container
	 */
	public function insertContainer(RCMS_Object_Container_Container $container) {
		$containerData = array(
			'name' => $container->getName(),
			'container_type_id' => $container->getType(),
			'user_id' => $container->getUserId(),
			'page_id' => $container->getPageId(),
            'published' => $container->getPublished(),
            'publishing_date' => $container->getPublishingDate()
		);
		$this->_adapter->insert('container', $containerData);
		$addedContainerId = $this->_adapter->lastInsertId('container');
		$contentData = array(
			'id_language' => '1',
			'id_container' => $addedContainerId,
			'value' => $container->getContent()
		);
		$this->_adapter->insert('content', $contentData);
		return $addedContainerId;
	}

	/**
	 * Update existing container with new data
	 *
	 * @param RCMS_Object_Container_Container $container
	 */
	public function updateContainer(RCMS_Object_Container_Container $container) {
		$contentData = array(
			'id_language' => '1',
			'id_container' => $container->getId(),
			'value' => $container->getContent()
		);
		$contentWhere = sprintf("id_container = %d", $container->getId());
		$this->_adapter->update('content', $contentData, $contentWhere);
		$containerData = array(
			'name' => $container->getName(),
			'container_type_id' => $container->getType(),
			'user_id' => $container->getUserId(),
			'page_id' => $container->getPageId(),
            'published' => $container->getPublished(),
            'publishing_date'=>$container->getPublishingDate()
		);
		$containerWhere = sprintf("id = %d", $container->getId());
		$result = $this->_adapter->update('container', $containerData, $containerWhere);
		return $result;
	}
}

