<?php
/**
 * Container class
 *
 * @author Eugene I. Nezhuta
 */
class RCMS_Object_Container_Container extends RCMS_Core_BaseObject {
	
	/**
	 * Container type text
	 *
	 */
	const C_TYPE_CONTENT = 1;

	/**
	 * Container type video
	 *
	 */
	const C_TYPE_STATIC = 2;

	/**
	 * Container type text
	 *
	 */
	const C_TYPE_HEADER = 3;

	/**
	 * Container type code
	 * 
	 */
	const C_TYPE_CODE = 4;

	/**
	 * Container type static header
	 *
	 */
	const C_TYPE_STATICHEADER = 5;

	/**
	 * Container type google map
	 *
	 */
	const C_TYPE_GOOGLEMAP = 6;

	/**
	 * Type of container
	 *
	 * @var integer
	 */
	private $_containerTypeId = self::C_TYPE_CONTENT;

	/**
	 * Owner Id
	 *
	 * @var integer
	 */
	private $_userId = 0;

	/**
	 * Page id, where this container is placed
	 *
	 * @var integer
	 */
	private $_pageId = 0;

	/**
	 * Container name
	 *
	 * @var string
	 */
	private $_name = '';

	/**
	 * Additional options for container
	 *
	 * @var array
	 */
	private $_optionsValues = array();

	/**
	 * Determine visibility of container
	 *
	 * @var boolean
	 */
	private $_published = true;

	/**
	 * Determine that the content of this container are for sale (for simple e-shop)
	 *
	 * @var boolean
	 */
	private $_isForSale = false;

	/**
	 * Price for container's content (for simple e-shop)
	 *
	 * @var integer
	 */
	private $_price = 0;

	/**
	 * First addiotional option for item that is for sale (like color, etc..)
	 *
	 * @var string
	 */
	private $_firstOption = '';

	/**
	 * Second addiotional option for item that is for sale (like material, etc..)
	 *
	 * @var string
	 */
	private $_secondOption = '';

	/**
	 * Allow comments for this container
	 *
	 * @var boolean
	 */
	private $_allowComments = true;

	/**
	 * Container's content
	 *
	 * @var string
	 */
	private $_content = '';

	/**
	 * Container's publishing date
	 *
	 * @var string
	 */
    private $_publishingDate = '';



	/**
	 * Constructor. If containerId not eq. false, then load container from db by id
	 *
	 * @param integer $containerId
	 */
	public function  __construct($containerId = false) {
		$this->_model = new RCMS_Object_Container_ContainerModel();
		if($containerId) {
			$containerData = $this->_model->selectContainerById($containerId);
			if(!is_object($containerData)) {
				throw new Exception ('Container loading is falied!');
			}
			$this->setId($containerData->containerId);
			$this->setContent($containerData->value);
			$this->setName($containerData->name);
			$this->setType($containerData->containerTypeId);
			$this->setPageId($containerData->pageId);
			$this->setUserId($containerData->ownerId);
            $this->setPublished($containerData->published);
            $this->setPublishingDate($containerData->publishingDate);
		}
	}

	/**
	 * Setter for container type
	 *
	 * @param integer $containerType
	 */
	public function setType($containerType) {
		$this->_containerTypeId = $containerType;
	}

	/**
	 * Setter for container name
	 *
	 * @param string $name
	 */
	public function setName($name) {
		$this->_name = $name;
	}

	/**
	 * Setter for container's content
	 *
	 * @param string $content
	 */
	public function setContent($content) {
		$this->_content = $content;
	}

	/**
	 * Setter for container's page id
	 *
	 * @param integer $pageId
	 */
	public function setPageId($pageId) {
		$this->_pageId = $pageId;
	}

	/**
	 * Setter for container's owner id
	 *
	 * @param integer $userId
	 */
	public function setUserId($userId) {
		$this->_userId = $userId;
	}

	/**
	 * Setter for additional container's options
	 *
	 * @param array $options
	 */
	public function setOptionValues(array $options) {
		$this->_optionsValues = $options;
	}

	/**
	 * Setter for container's published value
	 *
	 * @param boolean $published
	 */
	public function setPublished($published) {
		$this->_published = $published;
	}

	/**
	 * Setter for sale trigger
	 *
	 * @param boolean $isForSale
	 */
	public function setIsForSale($isForSale) {
		$this->_isForSale = $isForSale;
	}

	/**
	 * Setter for container's content price
	 *
	 * @param float $price
	 */
	public function setPrice($price) {
		$this->_price = $price;
	}

	/**
	 * Setter for first additional option
	 *
	 * @param string $option
	 */
	public function setFirstOption($option) {
		$this->_firstOption = $option;
	}

	/**
	 * Setter for second additional option
	 *
	 * @param string $option
	 */
	public function setSecondOption($option) {
		$this->_secondOption = $option;
	}

	/**
	 * Setter for allow comments option
	 *
	 * @param boolean $allow
	 */
	public function setAllowComments($allow) {
		$this->_allowComments = $allow;
	}

	/**
	 * Getter for allow comments option
	 *
	 * @return boolean
	 */
	public function getAllowComments() {
		return $this->_allowComments;
	}

	/**
	 * Getter for first additional option
	 *
	 * @return string
	 */
	public function getFirstOption() {
		return $this->_firstOption;
	}

	/**
	 * Getter for second additional option
	 *
	 * @return string
	 */
	public function getSecondOption() {
		return $this->_secondOption;
	}

	/**
	 * Getter for container's content price
	 *
	 * @return float
	 */
	public function getPrice() {
		return $this->_price;
	}

	/**
	 * Getter for isForSale option
	 *
	 * @return boolean
	 */
	public function getIsForSale() {
		return $this->_isForSale;
	}

	/**
	 * Getter for container's published option
	 *
	 * @return boolean
	 */
	public function getPublished() {
		return $this->_published;
	}

	/**
	 * Getter for container's additional options
	 *
	 * @return array
	 */
	public function getOptionValues() {
		return $this->_optionsValues;
	}

	/**
	 * Getter for container's type
	 *
	 * @return integer
	 */
	public function getType() {
		return $this->_containerTypeId;
	}

	/**
	 * Getter for container's name
	 *
	 * @return string
	 */
	public function getName() {
		return $this->_name;
	}

	/**
	 * Getter for container's content
	 *
	 * @return string
	 */
	public function getContent() {
		return $this->_content;
	}

	/**
	 * Getter for container's page id
	 *
	 * @return integer
	 */
	public function getPageId() {
		return $this->_pageId;
	}

	/**
	 * Getter for container's owner id
	 *
	 * @return integer
	 */
	public function getUserId() {
		return $this->_userId;
	}

	/**
	 * Get publication date
	 *
	 * @return string
	 */
	public function getPublishingDate() {
		return $this->_publishingDate;
	}

	/**
	 * Set date of publishing
	 *
	 * @param string $publishingDate
	 */
	public function setPublishingDate($publishingDate) {
		$this->_publishingDate = $publishingDate;
	}

	/**
	 * Delete container
	 * 
	 */
	public function delete() {
		//@todo implement this method
	}

	/**
	 * Insert container to the database
	 * 
	 */
	protected function _insert() {
		return $this->_model->insertContainer($this);
	}

	/**
	 * Update container
	 * 
	 */
	protected function _update() {
		return $this->_model->updateContainer($this);
	}
}