<?php
/**
 * CommentModel class
 *
 * @author Pavel A. Savchuk
 */
class RCMS_Object_Comment_CommentModel extends RCMS_Core_BaseModel {

	/**
	 * Table name
	 *
	 * @var String
	 */
    private $_tableName = 'comment';

	/**
	 * Insert comment
	 *
	 * @param RCMS_Object_Comment_Comment $comment
	 * @return integer
	 */
    public function insertComment(RCMS_Object_Comment_Comment $comment)
    {
          $data = array(
            'content'  => $comment->getContent(),
            'container_id'   => $comment->getConteinerId(),
            'date'  => $comment->getDate(),
            'user_id'   => $comment->getUserId(),
            'user_email' => $comment->getUserEmail(),
            'abuse'   => $comment->getAbuse(),
            'user_sign' =>$comment->getUserSign(),
            'user_website' =>$comment->getUserWebsite(),
            'publish' =>$comment->getPublish(),
            'rank' =>$comment->getRank(),
            'topic' =>$comment->getTopic(),
            'keyword' =>$comment->getKeyword(),
            'notify' =>$comment->getNotify()
        );

        $flag = $this->_adapter->insert($this->_tableName, $data);
        if($flag > 0)
        {
            return $this->_adapter->lastInsertId($this->_tableName);
        }
    }

	/**
	 * Update comment
	 *
	 * @param RCMS_Object_Comment_Comment $comment
	 * @return integer
	 */
    public function updateComment(RCMS_Object_Comment_Comment $comment)
    {
        $data = array(
            'content'  => $comment->getContent(),
            'container_id'   => $comment->getConteinerId(),
            'date'  => $comment->getDate(),
            'user_id'   => $comment->getUserId(),
            'user_email' => $comment->getUserEmail(),
            'abuse'   => $comment->getAbuse(),
            'user_sign' =>$comment->getUserSign(),
            'user_website' =>$comment->getUserWebsite(),
            'publish' =>$comment->getPublish(),
            'rank' =>$comment->getRank(),
            'topic' =>$comment->getTopic(),
            'keyword' =>$comment->getKeyword(),
            'notify' =>$comment->getNotify()

        );
        $where = sprintf("id = %d", $comment->getId());
        return $this->_adapter->update($this->_tableName, $data, $where);
    }

	/**
	 * Select comment by comment id
	 *
	 * @param integer $id
	 * @return array
	 */
    public function selectCommentById($id)
    {
        $where = sprintf("id = %d", $id);
        $select = $this->_adapter->select()->from($this->_tableName)->where($where);
        return $this->_adapter->fetchRow($select, null, Zend_Db::FETCH_OBJ);
    }

   
	/**
	 * Delete comment by comment id
	 *
	 * @param integer $id
	 * @return integer
	 */
    public function deleteComment($id)
    {
        $where = sprintf("id = %d", $id);
        return $this->_adapter->delete($this->_tableName, $where);
    }

	/**
	 * Select comments by container id
	 *
	 * @param integer $containerId
	 * @return array
	 */
       public function selectCommenstByContainerId($containerId)
    {
        $where = sprintf("id = %d", $containerId);
        $select = $this->_adapter->select()->from($this->_tableName)->where($where)->order('date');
        return $this->_adapter->fetchAll($select, null, Zend_Db::FETCH_ASSOC);
    }
}
